/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin2;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Bin8;
import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.AS400Date;
import com.ibm.as400.access.AS400Float4;
import com.ibm.as400.access.AS400Float8;
import com.ibm.as400.access.AS400PackedDecimal;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.AS400Time;
import com.ibm.as400.access.AS400Timestamp;
import com.ibm.as400.access.AS400UnsignedBin2;
import com.ibm.as400.access.AS400UnsignedBin4;
import com.ibm.as400.access.AS400UnsignedBin8;
import com.ibm.as400.access.AS400ZonedDecimal;
import com.ibm.as400.access.BinaryFieldDescription;
import com.ibm.as400.access.CharacterFieldDescription;
import com.ibm.as400.access.DateFieldDescription;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.FloatFieldDescription;
import com.ibm.as400.access.HexFieldDescription;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.PackedDecimalFieldDescription;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.TimeFieldDescription;
import com.ibm.as400.access.TimestampFieldDescription;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.ZonedDecimalFieldDescription;
import com.ibm.as400.data.PcmlAttributeList;
import com.ibm.as400.data.PcmlDataValues;
import com.ibm.as400.data.PcmlDimensions;
import com.ibm.as400.data.PcmlDocNode;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.RfmlData;
import com.ibm.as400.data.XmlException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;

class RfmlRecordFormat
extends PcmlDocNode {
    static final long serialVersionUID = 5L;
    private static final String[] RECORD_FORMAT_ATTRIBUTES = new String[]{"name", "description"};
    private String m_Description;
    private static final int DESCRIPTION_MAX_LENGTH = 50;
    private static final int MAX_DDS_NAME_LENGTH = 10;
    private static final int MAX_FIELD_TEXT_LENGTH = 50;

    public RfmlRecordFormat(PcmlAttributeList attrs) {
        super(attrs);
        this.setNodeType(6);
        this.setDescription(this.getAttributeValue("description"));
    }

    public Object clone() {
        RfmlRecordFormat node = (RfmlRecordFormat)super.clone();
        return node;
    }

    private static void addFieldDescriptions(PcmlDocNode node, Vector fieldDescriptions, Vector keyFields, Vector namesAlreadyUsed, String preferredFieldName, TimeZone timeZone) throws XmlException {
        boolean typeIsStruct = false;
        String fieldName = null;
        if (node.getNodeType() == 3) {
            typeIsStruct = true;
            fieldName = preferredFieldName != null ? preferredFieldName : node.getName();
        } else if (node.getNodeType() == 4) {
            int fieldLength;
            RfmlData dNode = (RfmlData)node;
            PcmlDimensions noDimensions = new PcmlDimensions();
            try {
                fieldLength = dNode.getLength(noDimensions);
            }
            catch (PcmlException e) {
                throw new XmlException(e);
            }
            fieldName = preferredFieldName != null ? preferredFieldName : dNode.getName();
            FieldDescription fieldDesc = null;
            String initValue = dNode.getInit();
            int precision = dNode.getPrecision();
            block2 : switch (dNode.getDataType()) {
                case 7: {
                    typeIsStruct = true;
                    break;
                }
                case 1: {
                    int ccsid = dNode.getCcsid();
                    AS400Text convAS400Text = ccsid == 0 ? new AS400Text(fieldLength) : new AS400Text(fieldLength, ccsid);
                    fieldDesc = new CharacterFieldDescription(convAS400Text, fieldName);
                    if (ccsid != 0) {
                        ((CharacterFieldDescription)fieldDesc).setCCSID(Integer.toString(ccsid));
                    }
                    if (initValue == null) break;
                    ((CharacterFieldDescription)fieldDesc).setDFT(initValue);
                    break;
                }
                case 2: {
                    switch (fieldLength) {
                        case 2: {
                            if (precision == 16) {
                                fieldDesc = new BinaryFieldDescription(new AS400UnsignedBin2(), fieldName);
                                if (initValue == null) break block2;
                                ((BinaryFieldDescription)fieldDesc).setDFT(Integer.valueOf(initValue));
                                break block2;
                            }
                            fieldDesc = new BinaryFieldDescription(new AS400Bin2(), fieldName);
                            if (initValue == null) break block2;
                            ((BinaryFieldDescription)fieldDesc).setDFT(Short.valueOf(initValue));
                            break block2;
                        }
                        case 4: {
                            if (precision == 32) {
                                fieldDesc = new BinaryFieldDescription(new AS400UnsignedBin4(), fieldName);
                                if (initValue == null) break block2;
                                ((BinaryFieldDescription)fieldDesc).setDFT(Long.valueOf(initValue));
                                break block2;
                            }
                            fieldDesc = new BinaryFieldDescription(new AS400Bin4(), fieldName);
                            if (initValue == null) break block2;
                            ((BinaryFieldDescription)fieldDesc).setDFT(Integer.valueOf(initValue));
                            break block2;
                        }
                        case 8: {
                            if (precision == 64) {
                                fieldDesc = new BinaryFieldDescription(new AS400UnsignedBin8(), fieldName);
                                if (initValue == null) break block2;
                                ((BinaryFieldDescription)fieldDesc).setDFT(new BigInteger(initValue));
                                break block2;
                            }
                            fieldDesc = new BinaryFieldDescription(new AS400Bin8(), fieldName);
                            if (initValue == null) break block2;
                            ((BinaryFieldDescription)fieldDesc).setDFT(Long.valueOf(initValue));
                            break block2;
                        }
                        default: {
                            Trace.log(2, "Invalid field length for type=int: " + fieldLength);
                            throw new InternalErrorException(6);
                        }
                    }
                }
                case 4: {
                    AS400ZonedDecimal convZoned = new AS400ZonedDecimal(fieldLength, precision);
                    fieldDesc = new ZonedDecimalFieldDescription(convZoned, fieldName);
                    if (initValue == null) break;
                    BigDecimal bigDec = new BigDecimal(initValue);
                    if (bigDec.scale() != precision) {
                        bigDec = bigDec.setScale(precision, 6);
                    }
                    ((ZonedDecimalFieldDescription)fieldDesc).setDFT(bigDec);
                    break;
                }
                case 3: {
                    AS400PackedDecimal convPacked = new AS400PackedDecimal(fieldLength, precision);
                    fieldDesc = new PackedDecimalFieldDescription(convPacked, fieldName);
                    if (initValue == null) break;
                    BigDecimal bigDec = new BigDecimal(initValue);
                    if (bigDec.scale() != precision) {
                        bigDec = bigDec.setScale(precision, 6);
                    }
                    ((PackedDecimalFieldDescription)fieldDesc).setDFT(new BigDecimal(initValue));
                    break;
                }
                case 5: {
                    switch (fieldLength) {
                        case 4: {
                            fieldDesc = new FloatFieldDescription(new AS400Float4(), fieldName);
                            break;
                        }
                        case 8: {
                            fieldDesc = new FloatFieldDescription(new AS400Float8(), fieldName);
                            break;
                        }
                        default: {
                            Trace.log(2, "Invalid field length for type=float: " + fieldLength);
                            throw new InternalErrorException(6);
                        }
                    }
                    if (initValue != null) {
                        if (fieldLength == 4) {
                            ((FloatFieldDescription)fieldDesc).setDFT(new Float(initValue));
                        } else {
                            ((FloatFieldDescription)fieldDesc).setDFT(new Double(initValue));
                        }
                    }
                    ((FloatFieldDescription)fieldDesc).setLength(fieldLength);
                    break;
                }
                case 6: {
                    AS400ByteArray convByte = new AS400ByteArray(fieldLength);
                    fieldDesc = new HexFieldDescription(convByte, fieldName);
                    if (initValue == null) break;
                    Object convertedValue = PcmlDataValues.convertValue(initValue, 6, fieldLength, 0, dNode.getNameForException(), timeZone);
                    ((HexFieldDescription)fieldDesc).setDFT((byte[])convertedValue);
                    break;
                }
                case 8: {
                    AS400Date convDate;
                    String separatorName = dNode.getDateSeparator();
                    String format = dNode.getDateFormat();
                    if (format == null) {
                        convDate = new AS400Date(timeZone);
                    } else {
                        int formatInt = AS400Date.toFormat(format);
                        convDate = separatorName == null ? new AS400Date(timeZone, formatInt) : new AS400Date(timeZone, formatInt, RfmlRecordFormat.separatorAsChar(separatorName));
                    }
                    fieldDesc = new DateFieldDescription(convDate, fieldName);
                    if (initValue != null) {
                        String initValueNormalized = convDate.toString(AS400Date.parseXsdString(initValue, timeZone));
                        ((DateFieldDescription)fieldDesc).setDFT(initValueNormalized);
                    }
                    if (format != null) {
                        ((DateFieldDescription)fieldDesc).setDATFMT(format);
                    }
                    if (separatorName == null) break;
                    ((DateFieldDescription)fieldDesc).setDATSEP(RfmlRecordFormat.separatorAsChar(separatorName).toString());
                    break;
                }
                case 9: {
                    AS400Time convTime;
                    String separatorName = dNode.getTimeSeparator();
                    String format = dNode.getTimeFormat();
                    if (format == null) {
                        convTime = new AS400Time(timeZone);
                    } else {
                        int formatInt = AS400Time.toFormat(format);
                        convTime = separatorName == null ? new AS400Time(timeZone, formatInt) : new AS400Time(timeZone, formatInt, RfmlRecordFormat.separatorAsChar(separatorName));
                    }
                    fieldDesc = new TimeFieldDescription(convTime, fieldName);
                    if (initValue != null) {
                        String initValueNormalized = convTime.toString(AS400Time.parseXsdString(initValue, timeZone));
                        ((TimeFieldDescription)fieldDesc).setDFT(initValueNormalized);
                    }
                    if (format != null) {
                        ((TimeFieldDescription)fieldDesc).setTIMFMT(format);
                    }
                    if (separatorName == null) break;
                    ((TimeFieldDescription)fieldDesc).setTIMSEP(RfmlRecordFormat.separatorAsChar(separatorName).toString());
                    break;
                }
                case 10: {
                    AS400Timestamp convTimestamp = new AS400Timestamp(timeZone);
                    fieldDesc = new TimestampFieldDescription(convTimestamp, fieldName);
                    if (initValue == null) break;
                    String initValueNormalized = convTimestamp.toString(AS400Timestamp.parseXsdString(initValue, timeZone));
                    ((TimestampFieldDescription)fieldDesc).setDFT(initValueNormalized);
                    break;
                }
                default: {
                    Trace.log(2, "Invalid data field type: " + dNode.getDataType());
                    throw new InternalErrorException(6);
                }
            }
            if (fieldDesc != null) {
                String qualifiedName = dNode.getQualifiedName();
                if (qualifiedName.length() <= 50) {
                    fieldDesc.setTEXT(qualifiedName);
                } else {
                    int startPos = qualifiedName.length() - 50 + 2;
                    String truncatedName = ".." + qualifiedName.substring(startPos);
                    fieldDesc.setTEXT(truncatedName);
                }
                String ddsName = RfmlRecordFormat.generateUniqueName(fieldName, namesAlreadyUsed);
                fieldDesc.setDDSName(ddsName);
                namesAlreadyUsed.addElement(ddsName.toUpperCase());
                try {
                    int count = dNode.getCount(noDimensions);
                    if (count != 1 && count != 0) {
                        Trace.log(4, "Ignoring attribute 'count' (" + count + ") for field " + qualifiedName);
                    }
                }
                catch (PcmlException e) {
                    throw new XmlException(e);
                }
                fieldDescriptions.addElement(fieldDesc);
                if (dNode.isKeyField()) {
                    int fieldIndex = fieldDescriptions.size() - 1;
                    keyFields.addElement(new Integer(fieldIndex));
                }
            }
        }
        if (node.hasChildren()) {
            String nameForChild = typeIsStruct && node.getNbrChildren() == 1 ? fieldName : null;
            Enumeration children = node.getChildren();
            while (children.hasMoreElements()) {
                PcmlDocNode child = (PcmlDocNode)children.nextElement();
                RfmlRecordFormat.addFieldDescriptions(child, fieldDescriptions, keyFields, namesAlreadyUsed, nameForChild, timeZone);
            }
        }
    }

    private static String generateUniqueName(String initialName, Vector namesInUse) {
        if (initialName.length() <= 10 && !namesInUse.contains(initialName)) {
            return initialName;
        }
        int startPos = Math.max(0, initialName.length() - 10);
        String baseName = initialName.substring(startPos);
        if (!namesInUse.contains(baseName)) {
            return baseName;
        }
        int baseLength = baseName.length();
        String suffix = Integer.toString(0);
        StringBuffer newName = new StringBuffer(baseName);
        int i = 0;
        while (suffix.length() < 10) {
            newName.replace(0, baseLength, baseName);
            newName.setLength(baseLength);
            newName.append(suffix);
            startPos = Math.max(0, newName.length() - 10);
            newName.delete(0, startPos);
            if (!namesInUse.contains(newName.toString())) {
                return newName.toString();
            }
            suffix = Integer.toString(++i);
        }
        Trace.log(2, "Failed to generate unique DDS name for field: " + initialName);
        throw new InternalErrorException(6);
    }

    String[] getAttributeList() {
        return RECORD_FORMAT_ATTRIBUTES;
    }

    private static void getDataNodes(PcmlDocNode node, Vector dataNodes) throws XmlException {
        if (node.getNodeType() == 4) {
            RfmlData dNode = (RfmlData)node;
            PcmlDimensions noDimensions = new PcmlDimensions();
            try {
                int fieldLength = dNode.getLength(noDimensions);
            }
            catch (PcmlException e) {
                throw new XmlException(e);
            }
            String fieldName = dNode.getName();
            switch (dNode.getDataType()) {
                case 7: {
                    break;
                }
                default: {
                    dataNodes.addElement(dNode);
                }
            }
        }
        if (node.hasChildren()) {
            Enumeration children = node.getChildren();
            while (children.hasMoreElements()) {
                PcmlDocNode child = (PcmlDocNode)children.nextElement();
                RfmlRecordFormat.getDataNodes(child, dataNodes);
            }
        }
    }

    String getDescription() {
        return this.m_Description;
    }

    int parseBytes(byte[] bytes) throws XmlException {
        PcmlDimensions noDimensions = new PcmlDimensions();
        Hashtable offsetStack = new Hashtable();
        int offsetIntoBuffer = 0;
        Enumeration children = this.getChildren();
        while (children.hasMoreElements()) {
            PcmlDocNode child = (PcmlDocNode)children.nextElement();
            if (child.getNodeType() == 4) {
                try {
                    int bytesConsumed = ((RfmlData)child).parseBytes(bytes, offsetIntoBuffer, offsetStack, noDimensions);
                    offsetIntoBuffer += bytesConsumed;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Trace.log(2, e);
                    throw new XmlException("INSUFFICIENT_INPUT_DATA", new Object[]{"(unknown)", Integer.toString(bytes.length), "<recordformat>", this.getNameForException()});
                }
            }
            throw new XmlException("BAD_NODE_TYPE", new Object[]{new Integer(child.getNodeType()), child.getNameForException()});
        }
        return offsetIntoBuffer;
    }

    public void setValues(Record record) throws UnsupportedEncodingException, XmlException {
        Vector dataNodes = new Vector();
        RfmlRecordFormat.getDataNodes(this, dataNodes);
        for (int fieldNum = 0; fieldNum < dataNodes.size(); ++fieldNum) {
            RfmlData dataNode = (RfmlData)dataNodes.elementAt(fieldNum);
            Object fieldValue = record.getField(fieldNum);
            if (fieldValue != null) {
                dataNode.setValue(fieldValue);
                continue;
            }
            if (!Trace.isTraceWarningOn()) continue;
            String nameStr = dataNode.getName();
            Trace.log(4, "Record field " + fieldNum + "(" + nameStr + ") is null.");
        }
    }

    void setDescription(String desc) {
        this.m_Description = desc;
    }

    public byte[] toBytes() throws XmlException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(512);
        PcmlDimensions noDimensions = new PcmlDimensions();
        int offsetForNextField = 0;
        Enumeration children = this.getChildren();
        block6: while (children.hasMoreElements()) {
            PcmlDocNode child = (PcmlDocNode)children.nextElement();
            switch (child.getNodeType()) {
                case 3: {
                    continue block6;
                }
                case 4: {
                    RfmlData dataNode = (RfmlData)child;
                    int bytesWritten = dataNode.toBytes(bytes, offsetForNextField, noDimensions);
                    offsetForNextField += bytesWritten;
                    continue block6;
                }
            }
            throw new XmlException("BAD_NODE_TYPE", new Object[]{new Integer(child.getNodeType()), child.getNameForException()});
        }
        try {
            bytes.flush();
        }
        catch (IOException e) {
            throw new XmlException(e);
        }
        return bytes.toByteArray();
    }

    public RecordFormat toRecordFormat() throws XmlException {
        int i;
        Vector fieldDescriptions = new Vector();
        Vector namesAlreadyUsed = new Vector();
        Vector keyFields = new Vector();
        RfmlRecordFormat.addFieldDescriptions(this, fieldDescriptions, keyFields, namesAlreadyUsed, null, AS400.getDefaultTimeZone(this.getAs400()));
        RecordFormat recordFormat = new RecordFormat(this.getName());
        for (i = 0; i < fieldDescriptions.size(); ++i) {
            recordFormat.addFieldDescription((FieldDescription)fieldDescriptions.elementAt(i));
        }
        for (i = 0; i < keyFields.size(); ++i) {
            recordFormat.addKeyFieldDescription((Integer)keyFields.elementAt(i));
        }
        return recordFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        RfmlRecordFormat rfmlRecordFormat = this;
        synchronized (rfmlRecordFormat) {
            out.defaultWriteObject();
        }
    }
}

