/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceList;
import com.ibm.as400.resource.ResourceMetaData;

public class ArrayResourceList
extends ResourceList {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private Resource[] resources_;

    public ArrayResourceList(Resource[] resources, Presentation presentation, ResourceMetaData[] attributeMetaData) {
        super(presentation, attributeMetaData, null, null);
        this.setArray(resources);
    }

    public void open() throws ResourceException {
        super.open();
        for (int i = 0; i < this.resources_.length; ++i) {
            this.fireResourceAdded(this.resources_[i], i);
        }
        this.fireLengthChanged(this.resources_.length);
        this.fireListCompleted();
    }

    public Resource resourceAt(long index) throws ResourceException {
        super.resourceAt(index);
        return this.resources_[(int)index];
    }

    protected void setArray(Resource[] resources) {
        if (resources == null) {
            throw new NullPointerException("resources");
        }
        for (int i = 0; i < resources.length; ++i) {
            if (resources[i] != null) continue;
            throw new NullPointerException("resources[" + i + "]");
        }
        this.resources_ = resources;
    }
}

