/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.resource.AbstractValueMap;
import java.io.Serializable;

public class BooleanValueMap
extends AbstractValueMap
implements Serializable {
    static final long serialVersionUID = 4L;
    private Object[] falseValues_ = null;
    private Object[] trueValues_ = null;

    public BooleanValueMap(Object falseValue, Object trueValue) {
        this(new Object[]{falseValue}, new Object[]{trueValue});
    }

    public BooleanValueMap(Object[] falseValues, Object[] trueValues) {
        if (falseValues == null) {
            throw new NullPointerException("falseValues");
        }
        if (falseValues.length == 0) {
            throw new ExtendedIllegalArgumentException("falseValues", 2);
        }
        if (trueValues == null) {
            throw new NullPointerException("trueValues");
        }
        if (trueValues.length == 0) {
            throw new ExtendedIllegalArgumentException("trueValues", 2);
        }
        this.falseValues_ = falseValues;
        this.trueValues_ = trueValues;
    }

    public Object ltop(Object logicalValue) {
        if (logicalValue == null) {
            throw new NullPointerException("logicalValue");
        }
        if (!(logicalValue instanceof Boolean)) {
            throw new ExtendedIllegalArgumentException("logicalValue([class " + logicalValue.getClass().getName() + "]: " + logicalValue.toString() + ")", 2);
        }
        return (Boolean)logicalValue != false ? this.trueValues_[0] : this.falseValues_[0];
    }

    public Object ptol(Object physicalValue) {
        int i;
        if (physicalValue == null) {
            throw new NullPointerException("physicalValue");
        }
        for (i = 0; i < this.falseValues_.length; ++i) {
            if (!physicalValue.equals(this.falseValues_[i])) continue;
            return Boolean.FALSE;
        }
        for (i = 0; i < this.trueValues_.length; ++i) {
            if (!physicalValue.equals(this.trueValues_[i])) continue;
            return Boolean.TRUE;
        }
        throw new ExtendedIllegalArgumentException("physicalValue([class " + physicalValue.getClass().getName() + "]: " + physicalValue.toString() + ")", 2);
    }
}

