/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.Trace;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceEvent;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceListener;
import com.ibm.as400.resource.ResourceMetaData;
import com.ibm.as400.resource.ResourceMetaDataTable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class ChangeableResource
extends Resource {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private transient Hashtable bufferedValues_;
    private transient Hashtable uncommittedChanges_;
    private transient Hashtable uncommittedChangeBidiStringTypes_;

    public ChangeableResource() {
        this.initializeTransient();
    }

    public ChangeableResource(Presentation presentation, Object resourceKey, ResourceMetaData[] attributeMetaData) {
        super(presentation, resourceKey, attributeMetaData);
        this.initializeTransient();
    }

    public ChangeableResource(Presentation presentation, Object resourceKey, ResourceMetaDataTable attributes) {
        super(presentation, resourceKey, attributes);
        this.initializeTransient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAttributeChanges() throws ResourceException {
        ChangeableResource changeableResource = this;
        synchronized (changeableResource) {
            this.uncommittedChanges_.clear();
        }
        this.fireAttributeChangesCanceled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitAttributeChanges() throws ResourceException {
        this.fireBusy();
        try {
            int j;
            int uncommittedChangesCount = this.uncommittedChanges_.size();
            Object[] attributeIDs = new Object[uncommittedChangesCount];
            Object[] values = new Object[uncommittedChangesCount];
            int[] bidiStringTypes = new int[uncommittedChangesCount];
            boolean bidiEnabled = this.isBidiEnabled();
            Enumeration list = this.uncommittedChanges_.keys();
            int i = 0;
            while (list.hasMoreElements()) {
                attributeIDs[i] = list.nextElement();
                values[i] = this.uncommittedChanges_.get(attributeIDs[i]);
                if (bidiEnabled) {
                    bidiStringTypes[i] = (Integer)this.uncommittedChangeBidiStringTypes_.get(attributeIDs[i]);
                    if (bidiStringTypes[i] == -1) {
                        bidiStringTypes[i] = this.getDefaultBidiStringType();
                    }
                }
                ++i;
            }
            for (j = 0; j < attributeIDs.length; ++j) {
                if (attributeIDs[j] == null) {
                    throw new NullPointerException("attributeIDs[" + j + "]");
                }
                ResourceMetaData attributeMetaData = this.validateAttributeID(attributeIDs[j]);
                if (attributeMetaData.isReadOnly()) {
                    Trace.log(2, "Attempted to set read-only attribute: " + attributeIDs[j]);
                    throw new ResourceException(8);
                }
                if (values[j] == null) {
                    throw new NullPointerException("values[" + j + "]");
                }
                values[j] = attributeMetaData.validateValue(values[j]);
            }
            if (bidiEnabled) {
                this.commitAttributeChanges(attributeIDs, values, bidiStringTypes);
            } else {
                this.commitAttributeChanges(attributeIDs, values);
            }
            for (j = 0; j < attributeIDs.length; ++j) {
                this.bufferedValues_.put(attributeIDs[j], values[j]);
            }
            this.uncommittedChanges_.clear();
            this.uncommittedChangeBidiStringTypes_.clear();
            this.fireAttributeChangesCommitted();
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.fireIdle();
            throw throwable;
        }
        this.fireIdle();
    }

    protected void commitAttributeChanges(Object[] attributeIDs, Object[] values) throws ResourceException {
    }

    protected void commitAttributeChanges(Object[] attributeIDs, Object[] values, int[] bidiStringTypes) throws ResourceException {
    }

    protected void fireAttributeChangesCanceled() {
        ResourceEvent event = new ResourceEvent(this, 1);
        Vector temp = (Vector)this.resourceListeners_.clone();
        Enumeration list = temp.elements();
        while (list.hasMoreElements()) {
            ((ResourceListener)list.nextElement()).attributeChangesCanceled(event);
        }
    }

    protected void fireAttributeChangesCommitted() {
        ResourceEvent event = new ResourceEvent(this, 2);
        Vector temp = (Vector)this.resourceListeners_.clone();
        Enumeration list = temp.elements();
        while (list.hasMoreElements()) {
            ((ResourceListener)list.nextElement()).attributeChangesCommitted(event);
        }
    }

    protected void fireAttributeValueChanged(Object attributeID, Object value) {
        ResourceEvent event = new ResourceEvent(this, 4, attributeID, value);
        Vector temp = (Vector)this.resourceListeners_.clone();
        Enumeration list = temp.elements();
        while (list.hasMoreElements()) {
            ((ResourceListener)list.nextElement()).attributeValueChanged(event);
        }
    }

    protected void fireResourceCreated() {
        ResourceEvent event = new ResourceEvent(this, 5);
        Vector temp = (Vector)this.resourceListeners_.clone();
        Enumeration list = temp.elements();
        while (list.hasMoreElements()) {
            ((ResourceListener)list.nextElement()).resourceCreated(event);
        }
    }

    protected void fireResourceDeleted() {
        ResourceEvent event = new ResourceEvent(this, 6);
        Vector temp = (Vector)this.resourceListeners_.clone();
        Enumeration list = temp.elements();
        while (list.hasMoreElements()) {
            ((ResourceListener)list.nextElement()).resourceDeleted(event);
        }
    }

    public Object getAttributeUnchangedValue(Object attributeID) throws ResourceException {
        if (this.isBidiEnabled()) {
            return this.getAttributeUnchangedValue(attributeID, this.getDefaultBidiStringType());
        }
        return this.getAttributeUnchangedValueImplementation(attributeID, this.getDefaultBidiStringType());
    }

    public Object getAttributeUnchangedValue(Object attributeID, int bidiStringType) throws ResourceException {
        if (!this.isBidiEnabled()) {
            return this.getAttributeUnchangedValue(attributeID);
        }
        return this.getAttributeUnchangedValueImplementation(attributeID, bidiStringType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getAttributeUnchangedValueImplementation(Object attributeID, int bidiStringType) throws ResourceException {
        this.validateAttributeID(attributeID);
        ChangeableResource changeableResource = this;
        synchronized (changeableResource) {
            if (this.bufferedValues_.containsKey(attributeID)) {
                return this.bufferedValues_.get(attributeID);
            }
            return super.getAttributeValueImplementation(attributeID);
        }
    }

    public Object getAttributeValue(Object attributeID) throws ResourceException {
        if (this.isBidiEnabled()) {
            return this.getAttributeValue(attributeID, this.getDefaultBidiStringType());
        }
        return this.getAttributeValueImplementation(attributeID, this.getDefaultBidiStringType());
    }

    public Object getAttributeValue(Object attributeID, int bidiStringType) throws ResourceException {
        if (!this.isBidiEnabled()) {
            return this.getAttributeValue(attributeID);
        }
        return this.getAttributeValueImplementation(attributeID, bidiStringType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getAttributeValueImplementation(Object attributeID, int bidiStringType) throws ResourceException {
        ChangeableResource changeableResource = this;
        synchronized (changeableResource) {
            if (this.uncommittedChanges_.containsKey(attributeID)) {
                return this.uncommittedChanges_.get(attributeID);
            }
            return this.getAttributeUnchangedValue(attributeID, bidiStringType);
        }
    }

    public boolean hasUncommittedAttributeChanges(Object attributeID) {
        this.validateAttributeID(attributeID);
        return this.uncommittedChanges_.containsKey(attributeID);
    }

    protected void initializeAttributeValue(Object attributeID, Object value) {
        super.initializeAttributeValue(attributeID, value);
        this.bufferedValues_.put(attributeID, value);
    }

    private void initializeTransient() {
        this.uncommittedChanges_ = new Hashtable();
        this.uncommittedChangeBidiStringTypes_ = new Hashtable();
        this.bufferedValues_ = new Hashtable();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    public void refreshAttributeValues() throws ResourceException {
        this.bufferedValues_.clear();
        super.refreshAttributeValues();
    }

    public void setAttributeValue(Object attributeID, Object value) throws ResourceException {
        if (this.isBidiEnabled()) {
            this.setAttributeValue(attributeID, value, this.getDefaultBidiStringType());
        } else {
            this.setAttributeValueImplementation(attributeID, value, this.getDefaultBidiStringType());
        }
    }

    public void setAttributeValue(Object attributeID, Object value, int bidiStringType) throws ResourceException {
        if (!this.isBidiEnabled()) {
            this.setAttributeValue(attributeID, value);
        } else {
            this.setAttributeValueImplementation(attributeID, value, bidiStringType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAttributeValueImplementation(Object attributeID, Object value, int bidiStringType) throws ResourceException {
        ResourceMetaData attributeMetaData;
        if (Trace.isTraceOn()) {
            Trace.log(1, "Setting attribute value " + attributeID + " (for " + this + ") to " + value + "(" + value.getClass() + "), bidi string type = " + bidiStringType);
        }
        if ((attributeMetaData = this.validateAttributeID(attributeID)).isReadOnly()) {
            Trace.log(2, "Attempted to set read-only attribute: " + attributeID);
            throw new ResourceException(8);
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        value = attributeMetaData.validateValue(value);
        ChangeableResource changeableResource = this;
        synchronized (changeableResource) {
            this.uncommittedChanges_.put(attributeID, value);
            this.uncommittedChangeBidiStringTypes_.put(attributeID, new Integer(bidiStringType));
        }
        this.fireAttributeValueChanged(attributeID, value);
    }
}

