/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.DateTimeConverter;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.resource.ValueMap;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

class DateValueMap
implements ValueMap,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    public static final int FORMAT_6 = 6;
    public static final int FORMAT_7 = 7;
    public static final int FORMAT_13 = 13;
    public static final int FORMAT_DTS = 99;
    static final Date NO_DATE = new Date(0L);
    private static final String DTS = "*DTS";
    private static final String HHMMSS_ZEROS = "000000";
    private static final String CYYMMDD_ZEROS = "0000000";
    private int format_ = -1;

    public DateValueMap(int format) {
        if (format != 6 && format != 7 && format != 13 && format != 99) {
            throw new ExtendedIllegalArgumentException("format", 2);
        }
        this.format_ = format;
    }

    public Object ltop(Object logicalValue, AS400 system) {
        if (logicalValue == null) {
            throw new NullPointerException("logicalValue");
        }
        switch (this.format_) {
            case 13: {
                return DateValueMap.dateToString13((Date)logicalValue);
            }
            case 7: {
                return DateValueMap.dateToString13((Date)logicalValue).substring(0, 7);
            }
            case 6: {
                return DateValueMap.dateToString13((Date)logicalValue).substring(7);
            }
            case 99: {
                if (system == null) {
                    throw new NullPointerException("system");
                }
                try {
                    DateTimeConverter converter = new DateTimeConverter(system);
                    return converter.convert((Date)logicalValue, DTS);
                }
                catch (Exception e) {
                    throw new ExtendedIllegalArgumentException("logicalValue", 2);
                }
            }
        }
        throw new ExtendedIllegalStateException("format", 6);
    }

    public Object ptol(Object physicalValue, AS400 system) {
        if (physicalValue == null) {
            throw new NullPointerException("physicalValue");
        }
        switch (this.format_) {
            case 13: {
                return DateValueMap.string13ToDate((String)physicalValue);
            }
            case 7: {
                return DateValueMap.string13ToDate((String)physicalValue + HHMMSS_ZEROS);
            }
            case 6: {
                return DateValueMap.string13ToDate(CYYMMDD_ZEROS + (String)physicalValue);
            }
            case 99: {
                if (system == null) {
                    throw new NullPointerException("system");
                }
                try {
                    byte[] asBytes = (byte[])physicalValue;
                    if (asBytes[0] == 64 || asBytes[0] == 0) {
                        return NO_DATE;
                    }
                    DateTimeConverter converter = new DateTimeConverter(system);
                    return converter.convert((byte[])physicalValue, DTS);
                }
                catch (Exception e) {
                    if (Trace.isTraceOn()) {
                        Trace.log(2, "Error converting date from DTS format", (Throwable)e);
                    }
                    throw new ExtendedIllegalArgumentException("physicalValue", 2);
                }
            }
        }
        throw new ExtendedIllegalArgumentException("physicalValue", 2);
    }

    private static String dateToString13(Date date) {
        Calendar calendar = AS400Calendar.getGregorianInstance();
        calendar.setTime(date);
        StringBuffer buffer13 = new StringBuffer(13);
        int year13 = calendar.get(1);
        buffer13.append(year13 < 2000 ? (char)'0' : '1');
        buffer13.append(DateValueMap.twoDigits(year13 % 100));
        buffer13.append(DateValueMap.twoDigits(calendar.get(2) + 1));
        buffer13.append(DateValueMap.twoDigits(calendar.get(5)));
        buffer13.append(DateValueMap.twoDigits(calendar.get(11)));
        buffer13.append(DateValueMap.twoDigits(calendar.get(12)));
        buffer13.append(DateValueMap.twoDigits(calendar.get(13)));
        return buffer13.toString();
    }

    private static Date string13ToDate(String string13) {
        int length = string13.length();
        Calendar calendar = AS400Calendar.getGregorianInstance();
        if (length == 0) {
            return NO_DATE;
        }
        if (string13.charAt(0) == '*') {
            return NO_DATE;
        }
        int century = Integer.parseInt(string13.substring(0, 1));
        int year = Integer.parseInt(string13.substring(1, 3));
        int month = Integer.parseInt(string13.substring(3, 5));
        int day = Integer.parseInt(string13.substring(5, 7));
        int hour = Integer.parseInt(string13.substring(7, 9));
        int minute = Integer.parseInt(string13.substring(9, 11));
        int second = Integer.parseInt(string13.substring(11, 13));
        calendar.set(1, year + (century == 0 ? 1900 : 2000));
        calendar.set(2, month - 1);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private static String twoDigits(int value) {
        if (value > 99) {
            throw new ExtendedIllegalArgumentException("value", 2);
        }
        String full = "00" + Integer.toString(value);
        return full.substring(full.length() - 2);
    }
}

