/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileFilter;
import com.ibm.as400.access.IFSJavaFile;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.PresentationLoader;
import com.ibm.as400.resource.RIFSFile;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceList;
import com.ibm.as400.resource.ResourceMetaDataTable;
import java.beans.PropertyVetoException;
import java.util.Enumeration;
import java.util.Vector;

public class RIFSFileList
extends ResourceList {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static final String PRESENTATION_KEY_ = "IFSFILE_LIST";
    private static final String ICON_BASE_NAME_ = "RIFSFileList";
    private static PresentationLoader presentationLoader_ = new PresentationLoader("com.ibm.as400.resource.ResourceMRI");
    private static ResourceMetaDataTable selections_ = new ResourceMetaDataTable(presentationLoader_, "IFSFILE_LIST");
    public static final String FILTER = "FILTER";
    public static final String PATTERN = "PATTERN";
    private Vector cache_;
    private Enumeration enum_;
    private IFSFile file_ = new IFSFile();
    private String path_ = null;

    public RIFSFileList() {
        super(presentationLoader_.getPresentationWithIcon(PRESENTATION_KEY_, ICON_BASE_NAME_), RIFSFile.attributes_, selections_, null);
    }

    public RIFSFileList(AS400 system, String path) {
        this();
        try {
            this.setSystem(system);
            this.setPath(path);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public RIFSFileList(RIFSFile file) {
        this();
        try {
            this.setSystem(file.getSystem());
            this.setPath(file.getPath());
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    protected void establishConnection() throws ResourceException {
        if (this.file_.getPath() == null) {
            throw new ExtendedIllegalStateException("path", 4);
        }
        super.establishConnection();
        try {
            this.file_.setSystem(this.getSystem());
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    protected void freezeProperties() throws ResourceException {
        if (this.file_.getPath() == null) {
            throw new ExtendedIllegalStateException("path", 4);
        }
        Presentation presentation = this.getPresentation();
        presentation.setName(this.file_.getName());
        presentation.setFullName(this.file_.getPath());
        super.freezeProperties();
    }

    public String getPath() {
        return this.path_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws ResourceException {
        if (this.isOpen()) {
            return;
        }
        super.open();
        this.fireBusy();
        try {
            RIFSFileList rIFSFileList = this;
            synchronized (rIFSFileList) {
                if (!this.isConnectionEstablished()) {
                    this.establishConnection();
                }
                try {
                    String pattern = (String)this.getSelectionValue(PATTERN);
                    this.enum_ = pattern == null ? this.file_.enumerateFiles((IFSFileFilter)this.getSelectionValue(FILTER)) : this.file_.enumerateFiles((IFSFileFilter)this.getSelectionValue(FILTER), pattern);
                    this.cache_ = new Vector();
                    if (!this.enum_.hasMoreElements()) {
                        this.fireListCompleted();
                    }
                }
                catch (Exception e) {
                    throw new ResourceException(e);
                }
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.fireIdle();
            throw throwable;
        }
        this.fireIdle();
    }

    public void refreshContents() throws ResourceException {
        if (this.isOpen()) {
            this.close();
        }
        super.refreshContents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource resourceAt(long index) throws ResourceException {
        RIFSFileList rIFSFileList = this;
        synchronized (rIFSFileList) {
            Resource resource = super.resourceAt(index);
            if (resource == null) {
                Vector vector = this.cache_;
                synchronized (vector) {
                    if (index < (long)this.cache_.size()) {
                        return (Resource)this.cache_.elementAt((int)index);
                    }
                    int i = this.cache_.size();
                    while ((long)i <= index) {
                        resource = new RIFSFile((IFSFile)this.enum_.nextElement());
                        this.cache_.addElement(resource);
                        resource.freezeProperties();
                        this.fireResourceAdded(resource, i);
                        this.fireLengthChanged(i + 1);
                        if (!this.enum_.hasMoreElements()) {
                            this.fireListCompleted();
                            break;
                        }
                        ++i;
                    }
                }
            }
            return resource;
        }
    }

    public void setPath(String path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (this.arePropertiesFrozen()) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        String oldValue = this.file_.getPath();
        try {
            this.path_ = path;
            String tempPath = path.replace(IFSJavaFile.separatorChar, '/');
            this.file_.setPath(tempPath);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.firePropertyChange("path", oldValue, path);
    }

    public void waitForComplete() throws ResourceException {
        super.waitForComplete();
        int i = 0;
        while (!this.isComplete()) {
            this.resourceAt(i++);
        }
    }

    public void waitForResource(long index) throws ResourceException {
        super.waitForResource(index);
        int i = 0;
        while (!this.isComplete() && (long)i <= index) {
            this.resourceAt(i++);
        }
    }

    static {
        selections_.add((Object)FILTER, IFSFileFilter.class, false);
        selections_.add((Object)PATTERN, String.class, false);
    }
}

