/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.access.Trace;
import com.ibm.as400.util.commtrace.BitBuf;
import com.ibm.as400.util.commtrace.Data;
import com.ibm.as400.util.commtrace.Dec;
import com.ibm.as400.util.commtrace.Field;
import com.ibm.as400.util.commtrace.FormatProperties;
import com.ibm.as400.util.commtrace.Formatter;
import com.ibm.as400.util.commtrace.Header;
import com.ibm.as400.util.commtrace.Hex;
import com.ibm.as400.util.commtrace.IP6Address;

public class IP6Header
extends Header {
    Field version;
    Field trafficclass;
    Field flowlabel;
    Field payloadlength;
    Field nextheaderh;
    Field nextheader;
    Field hoplimit;
    Field src;
    Field dst;
    private static final String CLASS = "IP6Header";
    private static final String ICMPV6 = "ICMPv6";
    private static final String TCP = "TCP";
    private static final String UDP = "UDP";
    private static final String EXTHOPHOP = "ExtHeader Hop by Hop";
    private static final String EXTROUTE = "ExtHeader Routing";
    private static final String EXTFRAG = "ExtHeader Fragmentation";
    private static final String EXTESP = "ExtHeader ESP";
    private static final String EXTAH = "ExtHeader AH";
    private static final String EXTDST = "ExtHeader Destination";
    private static final String IPV6DATA = "IPv6 Data";
    private static final String VER = "Ver";
    private static final String TRAFFICCLASS = "TrafficClass";
    private static final String FLWLBL = "FlowLabel";
    private static final String PAYLOADLENGTH = "PayloadLength";
    private static final String NXTHDR = "NextHeader";
    private static final String HOPLIMIT = "HopLimit";
    private static final String SRC = "Src";
    private static final String DST = "Dst";

    IP6Header(BitBuf data) {
        super(data);
        this.version = new Dec(this.rawheader.slice(0, 4));
        this.trafficclass = new Hex(this.rawheader.slice(4, 8));
        this.flowlabel = new Hex(this.rawheader.slice(12, 20));
        this.payloadlength = new Dec(this.rawheader.slice(32, 16));
        this.nextheaderh = new Hex(this.rawheader.slice(48, 8));
        this.nextheader = new Dec(this.rawheader.slice(48, 8));
        this.hoplimit = new Dec(this.rawheader.slice(56, 8));
        this.src = new IP6Address(this.rawheader.slice(64, 128));
        this.dst = new IP6Address(this.rawheader.slice(192, 128));
        this.type = 41;
    }

    public int getHeaderLen() {
        return 320;
    }

    public Header getNextHeader() {
        return Header.createHeader(this.rawheader.slice(48, 8).toByte(), this.rawpayload);
    }

    public String toString(FormatProperties filter) {
        String nextheaders = "";
        if (this.rawheader.getBitSize() < this.getHeaderLen()) {
            return new Data(this.rawheader).toString();
        }
        int protocol = Integer.parseInt(this.nextheader.toString());
        if (filter != null) {
            boolean print = false;
            String IPaddr = filter.getIPAddress();
            String IPaddr2 = filter.getSecondIPAddress();
            if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                Trace.log(3, "IP6Header.toString() Filter Properties:" + IPaddr + " " + IPaddr2);
            }
            if (IPaddr == null && IPaddr2 == null) {
                print = true;
            } else if (IPaddr == null) {
                if (this.src.toString().equals(IPaddr2) || this.dst.toString().equals(IPaddr2)) {
                    print = true;
                }
            } else if (IPaddr2 == null) {
                if (this.src.toString().equals(IPaddr) || this.dst.toString().equals(IPaddr)) {
                    print = true;
                }
            } else if ((this.src.toString().equals(IPaddr) || this.src.toString().equals(IPaddr2)) && (this.dst.toString().equals(IPaddr) || this.dst.toString().equals(IPaddr2))) {
                print = true;
            }
            if (!print) {
                if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                    Trace.log(3, "Not printing record");
                }
                return "";
            }
        }
        if (protocol == 58) {
            nextheaders = ICMPV6;
        }
        if (protocol == 6) {
            nextheaders = TCP;
        }
        if (protocol == 17) {
            nextheaders = UDP;
        }
        if (protocol == 0) {
            nextheaders = EXTHOPHOP;
        }
        if (protocol == 43) {
            nextheaders = EXTROUTE;
        }
        if (protocol == 44) {
            nextheaders = EXTFRAG;
        }
        if (protocol == 50) {
            nextheaders = EXTESP;
        }
        if (protocol == 51) {
            nextheaders = EXTAH;
        }
        if (protocol == 60) {
            nextheaders = EXTDST;
        }
        Object[] args = new Object[]{this.version, this.src, this.dst, this.hoplimit, this.flowlabel, this.trafficclass, this.payloadlength, nextheaders, this.nextheaderh};
        String next1 = this.printnext(filter);
        if (next1 == "") {
            return "";
        }
        return Formatter.jsprintf("\t    IPv6 Data . .:  Ver : {0,2,R} \t\t TrafficClass: {5}  \t\t    FlowLabel: {4}\n\t\t\t    PayloadLength: {6,5,R} \tNextHeader: {8,4,L},{7,10,L} HopLimit: {3,3,R}\n\t\t\t    Src: {1}\n\t\t\t    Dst: {2}\n", args) + this.printHexHeader() + next1;
    }

    public String getVersion() {
        return this.version.toString();
    }

    public String getTrafficClass() {
        return new Dec(this.trafficclass.getData()).toString();
    }

    public String getFlowLabel() {
        return new Dec(this.flowlabel.getData()).toString();
    }

    public String getPayloadLength() {
        return this.payloadlength.toString();
    }

    public String getNextHeaderDec() {
        return this.nextheader.toString();
    }

    public String getHopLimit() {
        return this.hoplimit.toString();
    }

    public String getSrcAddr() {
        return this.src.toString();
    }

    public String getDstAddr() {
        return this.dst.toString();
    }
}

