/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import java.util.Vector;

class IPAddressConversion {
    private String IPaddr;
    private int type = UNDEF;
    public static int UNDEF = -1;
    public static int IPv4 = 0;
    public static int IPv4Hex = 1;
    public static int IPv6 = 2;
    public static int IPvMixed = 3;
    public static int IPvMixedHex = 4;

    public IPAddressConversion(String IPaddr) {
        this.IPaddr = IPaddr;
        this.settype();
    }

    public IPAddressConversion(String IPaddr, int type) {
        this.IPaddr = IPaddr;
        this.type = type;
    }

    public int type() {
        return this.type;
    }

    private String toDec(String hex) {
        return new Integer(Integer.parseInt(hex, 16)).toString();
    }

    public String[] split(String str, String splitstr) {
        Vector<String> temp = new Vector<String>(12);
        int fromIndex = 0;
        int index = 0;
        while ((index = str.indexOf(splitstr, fromIndex)) != -1) {
            temp.add(str.substring(fromIndex, index));
            fromIndex = index + 1;
        }
        temp.add(str.substring(fromIndex));
        String[] ret = new String[temp.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (String)temp.remove(0);
        }
        return ret;
    }

    public String ntop() {
        if (this.type == IPv4 || this.type == IPv4Hex) {
            String[] seg = this.split(this.IPaddr, ".");
            return this.ntopIPv4(seg);
        }
        if (this.type == IPv6) {
            String[] seg = this.split(this.IPaddr, ":");
            seg = this.trim(seg);
            return this.ntopIPv6(seg);
        }
        if (this.type == IPvMixed) {
            String[] seg = this.split(this.IPaddr, ":");
            String[] tmp = this.split(seg[7], ".");
            seg[7] = "";
            seg = this.trim(seg);
            tmp = this.trim(tmp);
            return this.ntopIPv6(seg) + ":" + this.ntopIPv4(tmp);
        }
        return "";
    }

    private String ntopIPv4(String[] seg) {
        StringBuffer ret = new StringBuffer(32);
        for (int i = 0; i < seg.length; ++i) {
            seg[i] = this.type == IPv4Hex || this.type == IPvMixedHex ? this.toDec(seg[i]) : new Integer(Integer.parseInt(seg[i])).toString();
            ret.append(seg[i] + ".");
        }
        return ret.substring(0, ret.length() - 1);
    }

    private String ntopIPv6(String[] seg) {
        int i;
        boolean zero = false;
        boolean compressed = false;
        int start = 0;
        int end = 0;
        StringBuffer ret = new StringBuffer(64);
        for (i = 0; i < seg.length; ++i) {
            if (seg[i].charAt(0) == '0' && !zero) {
                if (i == 0) {
                    ret.append(":");
                }
                zero = true;
                start = i;
            }
            if (!zero || end != 0 || i + 1 >= seg.length || seg[i + 1].charAt(0) == '0') continue;
            end = i;
        }
        for (i = 0; i < seg.length; ++i) {
            if (!zero) {
                ret.append(seg[i] + ":");
                continue;
            }
            if (!compressed) {
                if (seg[i].charAt(0) != '0') {
                    ret.append(seg[i] + ":");
                    continue;
                }
                if (start == end) continue;
                ret.append(":");
                i = end;
                compressed = true;
                continue;
            }
            ret.append(seg[i] + ":");
        }
        return ret.substring(0, ret.length() - 1);
    }

    private String[] trim(String[] seg) {
        StringBuffer ret = new StringBuffer(64);
        for (int i = 0; i < seg.length; ++i) {
            boolean first = true;
            char[] c = seg[i].toCharArray();
            for (int j = 0; j < c.length; ++j) {
                if (c[j] == '0' && first) {
                    if (this.type == IPv4 || this.type == IPv4Hex) {
                        if (j <= 1) continue;
                        ret.append("0");
                        continue;
                    }
                    if (this.type == IPv6) {
                        if (j <= 2) continue;
                        ret.append("0");
                        continue;
                    }
                    if (this.type != IPvMixed && this.type != IPvMixedHex || j <= 2) continue;
                    ret.append("0");
                    continue;
                }
                if (first) {
                    first = false;
                }
                ret.append(c[j]);
            }
            if (this.type == IPv4 || this.type == IPv4Hex) {
                ret.append(".");
                continue;
            }
            if (this.type == IPv6) {
                ret.append(":");
                continue;
            }
            if (this.type != IPvMixed && this.type != IPvMixedHex) continue;
            ret.append(":");
        }
        if (this.type == IPv4 || this.type == IPv4Hex) {
            return this.split(ret.substring(0, ret.length() - 1), ".");
        }
        if (this.type == IPv6) {
            return this.split(ret.substring(0, ret.length() - 1), ":");
        }
        if (this.type == IPvMixed || this.type == IPvMixedHex) {
            return this.split(ret.substring(0, ret.length() - 1), ":");
        }
        return this.split(ret.toString(), ".");
    }

    public String pton() {
        if (this.type == IPv4 || this.type == IPv4Hex) {
            String[] seg = this.split(this.IPaddr, ".");
            return this.ptonIPv4(seg);
        }
        if (this.type == IPv6) {
            String[] seg = this.split(this.IPaddr, ":");
            return this.ptonIPv6(seg);
        }
        if (this.type == IPvMixed || this.type == IPvMixedHex) {
            String[] seg = this.split(this.IPaddr, ":");
            String[] tmp = null;
            for (int i = 0; i < seg.length; ++i) {
                if (seg[i].indexOf(46) == -1) continue;
                tmp = this.split(seg[i], ".");
                seg[i] = "";
                int n = i;
            }
            return this.ptonIPv6(seg) + ":" + this.ptonIPv4(tmp);
        }
        return "Unknown Type of IP Address";
    }

    private String ptonIPv4(String[] seg) {
        StringBuffer ret = new StringBuffer(32);
        for (int i = 0; i < seg.length; ++i) {
            int length = seg[i].length();
            if (length == 3) {
                ret.append(seg[i] + ".");
                continue;
            }
            if (length == 2) {
                ret.append("0".concat(seg[i]) + ".");
                continue;
            }
            if (length != 1) continue;
            ret.append("00".concat(seg[i]) + ".");
        }
        return ret.substring(0, ret.length() - 1);
    }

    private String ptonIPv6(String[] seg) {
        StringBuffer ret = new StringBuffer(64);
        if (seg.length < 8) {
            int i;
            seg = new String[8];
            String[] comp = this.split(this.IPaddr, "::");
            String[] segcomp = this.split(comp[0], ":");
            String[] segcomp2 = this.split(comp[1], ":");
            int size = 0;
            size = comp[0].equals("") ? 9 - segcomp.length - segcomp2.length : 8 - segcomp.length - segcomp2.length;
            int pos = 0;
            for (i = 0; i < segcomp.length; ++i) {
                seg[pos] = segcomp[i];
                if (comp[0].equals("")) continue;
                ++pos;
            }
            for (i = 0; i < size; ++i) {
                seg[pos] = "0";
                ++pos;
            }
            for (i = 0; i < segcomp2.length; ++i) {
                seg[pos] = segcomp2[i];
                ++pos;
            }
        }
        for (int i = 0; i < seg.length; ++i) {
            int length = seg[i].length();
            if (length == 4) {
                ret.append(seg[i] + ":");
                continue;
            }
            if (length == 3) {
                ret.append("0".concat(seg[i]) + ":");
                continue;
            }
            if (length == 2) {
                ret.append("00".concat(seg[i]) + ":");
                continue;
            }
            if (length != 1) continue;
            ret.append("000".concat(seg[i]) + ":");
        }
        return ret.substring(0, ret.length() - 1);
    }

    private void settype() {
        int l = this.IPaddr.length();
        for (int i = 0; i < l; ++i) {
            if (this.IPaddr.charAt(i) == ':') {
                if (this.type != UNDEF) continue;
                this.type = IPv6;
                continue;
            }
            if (this.IPaddr.charAt(i) != '.') continue;
            if (this.type == UNDEF) {
                this.type = IPv4;
                break;
            }
            this.type = IPvMixed;
            break;
        }
    }
}

