/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.util.commtrace.BitBuf;
import com.ibm.as400.util.commtrace.Dec;
import com.ibm.as400.util.commtrace.Field;
import com.ibm.as400.util.commtrace.Flag;
import com.ibm.as400.util.commtrace.FormatProperties;
import com.ibm.as400.util.commtrace.Formatter;
import com.ibm.as400.util.commtrace.Header;
import com.ibm.as400.util.commtrace.Message;
import com.ibm.as400.util.commtrace.NDOption;

public class RouterAdvertisement
extends Message {
    private Field curhoplimit;
    private Field m;
    private Field o;
    private Field routerlifetime;
    private Field reachabletime;
    private Field retranstimer;

    public Header getNextHeader() {
        return NDOption.createNDOption(this.rawpayload);
    }

    RouterAdvertisement(BitBuf data) {
        super(data);
        this.curhoplimit = new Dec(this.rawheader.slice(0, 8));
        this.m = new Flag(this.rawheader.slice(8, 1));
        this.o = new Flag(this.rawheader.slice(9, 1));
        this.routerlifetime = new Dec(this.rawheader.slice(16, 16));
        this.reachabletime = new Dec(this.rawheader.slice(32, 32));
        this.retranstimer = new Dec(this.rawheader.slice(64, 32));
        this.type = 134;
    }

    public int getHeaderLen() {
        return 96;
    }

    public String toString(FormatProperties filter) {
        Object[] args = new Object[]{this.curhoplimit, this.m, this.o, this.routerlifetime, this.reachabletime, this.retranstimer};
        return Formatter.jsprintf("CurHopLimit: {0,3,R}     M: {1}    O: {2}\n\t\tRouterLifeTime: {3,5,R}     ReachableTime: {4,10,R}     RetransTimer: {5,10,R}\n", args) + this.printHexHeader() + this.printnext(filter);
    }

    public String getCurrentHopLimit() {
        return this.curhoplimit.toString();
    }

    public String getMFlag() {
        return this.m.toString();
    }

    public String getOFlag() {
        return this.o.toString();
    }

    public String getRouterLifeTime() {
        return this.routerlifetime.toString();
    }

    public String getReachableTime() {
        return this.reachabletime.toString();
    }

    public String getRetransTimer() {
        return this.retranstimer.toString();
    }
}

