/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.IFSTextFileDocument;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VActionContext;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.WorkingCursorAdapter;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

class IFSEditAction
implements VAction {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String copyText_ = ResourceLoader.getText("MENU_COPY");
    private static final String cutText_ = ResourceLoader.getText("MENU_CUT");
    private static final String editActionText_ = ResourceLoader.getText("ACTION_EDIT");
    private static final String editText_ = ResourceLoader.getText("MENU_EDIT");
    private static final String exitText_ = ResourceLoader.getText("MENU_EXIT");
    private static final String fileText_ = ResourceLoader.getText("MENU_FILE");
    private static final String pasteText_ = ResourceLoader.getText("MENU_PASTE");
    private static final String saveConfirmText_ = ResourceLoader.getText("DLG_CONFIRM_SAVE");
    private static final String saveConfirmTitle_ = ResourceLoader.getText("DLG_CONFIRM_SAVE_TITLE");
    private static final String saveText_ = ResourceLoader.getText("MENU_SAVE");
    private static final String selectAllText_ = ResourceLoader.getText("MENU_SELECT_ALL");
    private static final String viewActionText_ = ResourceLoader.getText("ACTION_VIEW");
    private boolean allowChanges_ = true;
    private boolean enabled_ = true;
    private IFSFile file_ = null;
    private VObject object_ = null;
    private ErrorEventSupport errorEventSupport_ = new ErrorEventSupport(this);
    private VObjectEventSupport objectEventSupport_ = new VObjectEventSupport(this);
    private WorkingEventSupport workingEventSupport_ = new WorkingEventSupport(this);

    public IFSEditAction(VObject object, IFSFile file, boolean allowChanges) {
        this.object_ = object;
        this.file_ = file;
        this.allowChanges_ = allowChanges;
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    public void addVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.addVObjectListener(listener);
    }

    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    void exit(IFSTextFileDocument document, JFrame frame, boolean allowCancel) {
        boolean cancelled = false;
        if (document.isModified()) {
            int optionType = allowCancel ? 1 : 0;
            int response = JOptionPane.showConfirmDialog(frame, saveConfirmText_, saveConfirmTitle_, optionType);
            switch (response) {
                case 0: {
                    this.save(document);
                    break;
                }
                default: {
                    break;
                }
                case 2: {
                    cancelled = true;
                }
            }
        }
        if (!cancelled) {
            frame.setVisible(false);
        }
    }

    public String getText() {
        return this.allowChanges_ ? editActionText_ : viewActionText_;
    }

    public boolean isEnabled() {
        return this.enabled_;
    }

    public void perform(VActionContext context) {
        if (Trace.isTraceOn()) {
            if (this.allowChanges_) {
                Trace.log(3, "Editing file [" + this.file_.getName() + "].");
            } else {
                Trace.log(3, "Viewing file [" + this.file_.getName() + "].");
            }
        }
        IFSTextFileDocument document = new IFSTextFileDocument(this.file_);
        document.load();
        JTextPane textPane = new JTextPane(document);
        textPane.setEditable(this.allowChanges_);
        document.addWorkingListener(new WorkingCursorAdapter(textPane));
        JScrollPane scrollPane = new JScrollPane(textPane);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        JFrame frame = new JFrame(this.file_.getPath());
        frame.getRootPane().setPreferredSize(new Dimension(400, 400));
        JMenuBar menuBar = new JMenuBar();
        final IFSTextFileDocument document2 = document;
        final JFrame frame2 = frame;
        final JTextPane textPane2 = textPane;
        JMenu menu = new JMenu(fileText_);
        JMenuItem menuItem = new JMenuItem(saveText_);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                IFSEditAction.this.save(document2);
            }
        });
        menuItem.setEnabled(this.allowChanges_);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem(exitText_);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                IFSEditAction.this.exit(document2, frame2, true);
            }
        });
        menu.add(menuItem);
        menuBar.add(menu);
        menu = new JMenu(editText_);
        menuItem = new JMenuItem(cutText_);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                textPane2.cut();
            }
        });
        menuItem.setEnabled(this.allowChanges_);
        menu.add(menuItem);
        menuItem = new JMenuItem(copyText_);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                textPane2.copy();
            }
        });
        menuItem.setEnabled(true);
        menu.add(menuItem);
        menuItem = new JMenuItem(pasteText_);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                textPane2.paste();
            }
        });
        menuItem.setEnabled(this.allowChanges_);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem(selectAllText_);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                textPane2.selectAll();
            }
        });
        menuItem.setEnabled(true);
        menu.add(menuItem);
        menuBar.add(menu);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                IFSEditAction.this.exit(document2, frame2, false);
            }
        });
        frame.getRootPane().setJMenuBar(menuBar);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add("Center", scrollPane);
        frame.pack();
        frame.show();
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    public void removeVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.removeVObjectListener(listener);
    }

    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }

    void save(IFSTextFileDocument document) {
        document.save();
        this.object_.load();
        this.objectEventSupport_.fireObjectChanged(this.object_);
    }

    public void setEnabled(boolean enabled) {
        this.enabled_ = enabled;
    }

    public String toString() {
        return this.getText();
    }
}

