/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.vaccess.ErrorEvent;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.FileFilter;
import com.ibm.as400.vaccess.IFSList;
import com.ibm.as400.vaccess.ResourceLoader;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.util.Hashtable;

public class IFSFileDialog
extends Dialog {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private Label label1;
    IFSList directoryList;
    private Label label2;
    IFSList fileList;
    private Label label3;
    TextField fileName;
    private Label label4;
    Choice fileType;
    Button open;
    Button cancel;
    private Label currentDirectory;
    TextField status;
    AS400 sys_;
    int state_;
    Hashtable filters_;
    private Listeners listener_ = new Listeners();
    private static String READY_TEXT = ResourceLoader.getPrintText("READY");
    private static String WORKING_TEXT = ResourceLoader.getText("EVT_NAME_WORKING");
    public static final int ACTIVE = 0;
    public static final int OK = 1;
    public static final int CANCEL = 2;

    public IFSFileDialog(Frame parent, String title, AS400 system) {
        super(parent, title, true);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.insets = new Insets(8, 8, 0, 8);
        this.setLayout(layout);
        this.setBackground(Color.lightGray);
        String text = ResourceLoader.getText("IFS_DIRECTORY");
        this.label1 = new Label(text, 0);
        this.add(this.label1, layout, constraints, 0, 0, 3, 1);
        this.directoryList = new IFSList();
        constraints.ipadx = 40;
        constraints.ipady = 90;
        this.add(this.directoryList, layout, constraints, 0, 1, 3, 5);
        text = ResourceLoader.getText("IFS_FILE");
        this.label2 = new Label(text, 0);
        constraints.ipadx = 0;
        constraints.ipady = 0;
        this.add(this.label2, layout, constraints, 3, 0, 3, 1);
        this.fileList = new IFSList();
        constraints.ipadx = 40;
        constraints.ipady = 90;
        this.add(this.fileList, layout, constraints, 3, 1, 3, 5);
        text = ResourceLoader.getText("IFS_FILE_NAME");
        this.label3 = new Label(text);
        constraints.ipadx = 0;
        constraints.ipady = 0;
        this.add(this.label3, layout, constraints, 0, 7, 1, 1);
        this.fileName = new TextField(21);
        this.add(this.fileName, layout, constraints, 1, 7, 5, 1);
        text = ResourceLoader.getPrintText("TYPE");
        this.label4 = new Label(text);
        this.add(this.label4, layout, constraints, 0, 8, 1, 1);
        this.fileType = new Choice();
        this.add(this.fileType, layout, constraints, 1, 8, 5, 1);
        text = ResourceLoader.getPrintText("OPEN");
        this.open = new Button(text);
        constraints.ipadx = 20;
        this.add(this.open, layout, constraints, 6, 0, 3, 1);
        text = ResourceLoader.getText("DLG_CANCEL");
        this.cancel = new Button(text);
        this.add(this.cancel, layout, constraints, 6, 1, 3, 1);
        this.currentDirectory = new Label("/");
        constraints.ipadx = 0;
        constraints.ipady = 0;
        this.add(this.currentDirectory, layout, constraints, 0, 6, 6, 1);
        this.status = new TextField(44);
        this.add(this.status, layout, constraints, 0, 9, 9, 1);
        this.pack();
        this.status.setEditable(false);
        this.sys_ = system;
        this.directoryList.setSystem(this.sys_);
        this.fileList.setSystem(this.sys_);
        this.directoryList.setSort(true);
        this.fileList.setSort(true);
        this.directoryList.setListType(1);
        this.fileList.setListType(2);
        this.filters_ = new Hashtable();
        text = ResourceLoader.getText("IFS_ALL_FILES_FILTER");
        this.filters_.put(text, "*.*");
        this.fileType.addItem(text);
        this.open.addActionListener(this.listener_);
        this.cancel.addActionListener(this.listener_);
        this.directoryList.addActionListener(this.listener_);
        this.fileList.addActionListener(this.listener_);
        this.fileList.addItemListener(this.listener_);
        this.addWindowListener(this.listener_);
        this.fileType.addItemListener(this.listener_);
        this.label1.addKeyListener(this.listener_);
        this.directoryList.addKeyListener(this.listener_);
        this.label2.addKeyListener(this.listener_);
        this.fileList.addKeyListener(this.listener_);
        this.label3.addKeyListener(this.listener_);
        this.fileName.addKeyListener(this.listener_);
        this.label4.addKeyListener(this.listener_);
        this.fileType.addKeyListener(this.listener_);
        this.open.addKeyListener(this.listener_);
        this.cancel.addKeyListener(this.listener_);
        this.currentDirectory.addKeyListener(this.listener_);
        this.status.addKeyListener(this.listener_);
        this.addKeyListener(this.listener_);
        this.directoryList.addErrorListener(this.listener_);
        this.fileList.addErrorListener(this.listener_);
        this.status.setText(READY_TEXT);
        this.setResizable(false);
        this.state_ = 0;
    }

    protected void add(Component component, GridBagLayout layout, GridBagConstraints constraints, int x, int y, int width, int height) {
        constraints.gridx = x;
        constraints.gridy = y;
        constraints.gridwidth = width;
        constraints.gridheight = height;
        layout.setConstraints(component, constraints);
        this.add(component);
    }

    public String getAbsolutePath() {
        if (this.state_ != 2) {
            return this.getDirectory() + "/" + this.getFileName();
        }
        return "";
    }

    public String getCancelButtonText() {
        return this.cancel.getLabel();
    }

    public String getFileName() {
        if (this.state_ != 2) {
            return this.fileName.getText();
        }
        return "";
    }

    public FileFilter getFileFilter() {
        String desc = this.fileType.getSelectedItem();
        String p = (String)this.filters_.get(desc);
        return new FileFilter(desc, p);
    }

    public String getOkButtonText() {
        return this.open.getLabel();
    }

    public String getDirectory() {
        if (this.state_ != 2) {
            return this.directoryList.getPath();
        }
        return "";
    }

    public AS400 getSystem() {
        return this.sys_;
    }

    public void setCancelButtonText(String buttonText) {
        this.cancel.setLabel(buttonText);
    }

    public void setFileName(String filename) {
        this.fileName.setText(filename);
    }

    public void setFileFilter(FileFilter[] filterList, int defaultFilter) {
        this.fileType.removeAll();
        this.filters_ = new Hashtable();
        for (int i = 0; i < filterList.length; ++i) {
            this.fileType.addItem(filterList[i].getDescription());
            this.filters_.put(filterList[i].getDescription(), filterList[i].getPattern());
        }
        this.fileType.select(defaultFilter);
        this.fileList.setFilter(filterList[defaultFilter].getPattern());
    }

    public void setOkButtonText(String buttonText) {
        this.open.setLabel(buttonText);
    }

    public void setDirectory(String path) {
        this.directoryList.setPath(path);
        this.fileList.setPath(path);
    }

    void selectDirList() {
        String path = this.directoryList.getPath();
        String dir = this.directoryList.getSelectedItem();
        if (dir == null) {
            return;
        }
        this.directoryList.setEnabled(false);
        this.fileList.setEnabled(false);
        if (dir.compareTo(".") == 0) {
            this.status.setText(WORKING_TEXT);
            try {
                this.fileList.populateList();
                this.status.setText(READY_TEXT);
            }
            catch (Exception e) {
                this.status.setText(e.toString());
            }
            this.showCurrentDir(this.fileList.getPath());
        } else if (dir.compareTo("..") == 0) {
            int i = path.lastIndexOf("/");
            String s = i != 0 ? path.substring(0, i) : "/";
            try {
                this.directoryList.setPath(s);
                this.status.setText(WORKING_TEXT);
                this.directoryList.populateList();
                this.fileList.setPath(s);
                this.fileList.populateList();
                this.status.setText(READY_TEXT);
                this.showCurrentDir(s);
            }
            catch (Exception e) {
                this.status.setText(e.toString());
            }
        } else {
            String newPath = path.compareTo("/") != 0 ? path + "/" + dir : path + dir;
            try {
                this.directoryList.setPath(newPath);
                this.fileList.setPath(newPath);
                this.status.setText(WORKING_TEXT);
                this.directoryList.populateList();
                this.fileList.populateList();
                this.status.setText(READY_TEXT);
                this.showCurrentDir(newPath);
            }
            catch (Exception e) {
                this.status.setText(e.toString());
            }
        }
        this.directoryList.setEnabled(true);
        this.fileList.setEnabled(true);
    }

    public void setVisible() {
        IFSList list = null;
        try {
            list = this.directoryList;
            list.populateList();
            list = this.fileList;
            list.populateList();
            list = this.directoryList;
            this.showCurrentDir(list.getPath());
        }
        catch (Exception e) {
            String pathAndFilter = null;
            if (list != null) {
                String text0 = ResourceLoader.getText("PROP_NAME_PATH");
                String text1 = ResourceLoader.getText("PROP_NAME_FILTER");
                pathAndFilter = "(" + text0 + "=" + list.getPath() + ", " + text1 + "=" + list.getFilter() + ") ";
            } else {
                pathAndFilter = "";
            }
            this.status.setText(pathAndFilter + e.toString());
        }
        super.setVisible(true);
    }

    public int showDialog() {
        this.setVisible();
        return this.state_;
    }

    private void showCurrentDir(String path) {
        this.currentDirectory.setText("//" + this.sys_.getSystemName() + path);
    }

    class Listeners
    implements WindowListener,
    ActionListener,
    ItemListener,
    KeyListener,
    ErrorListener,
    Serializable {
        Listeners() {
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == IFSFileDialog.this.cancel) {
                IFSFileDialog.this.fileName.setText("");
                IFSFileDialog.this.state_ = 2;
                IFSFileDialog.this.dispose();
            }
            if (source == IFSFileDialog.this.open) {
                IFSFileDialog.this.state_ = 1;
                IFSFileDialog.this.dispose();
            }
            if (source == IFSFileDialog.this.directoryList) {
                IFSFileDialog.this.selectDirList();
            }
            if (source == IFSFileDialog.this.fileList) {
                String f = IFSFileDialog.this.fileList.getSelectedItem();
                IFSFileDialog.this.fileName.setText(f);
                IFSFileDialog.this.state_ = 1;
                IFSFileDialog.this.dispose();
            }
        }

        public void errorOccurred(ErrorEvent e) {
            System.out.println(e.getException().toString());
            IFSFileDialog.this.status.setText(e.getException().toString());
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == IFSFileDialog.this.fileList) {
                if (e.getStateChange() == 1) {
                    String f = IFSFileDialog.this.fileList.getSelectedItem();
                    IFSFileDialog.this.fileName.setText(f);
                }
            } else if (e.getSource() == IFSFileDialog.this.fileType) {
                String s = IFSFileDialog.this.fileType.getSelectedItem();
                IFSFileDialog.this.fileList.setFilter((String)IFSFileDialog.this.filters_.get(s));
                IFSFileDialog.this.status.setText(WORKING_TEXT);
                try {
                    IFSFileDialog.this.fileList.populateList();
                    IFSFileDialog.this.status.setText(READY_TEXT);
                }
                catch (Exception ex) {
                    IFSFileDialog.this.status.setText(ex.toString());
                }
            }
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            block15: {
                if (e.getKeyCode() == 10) {
                    if (e.getSource() == IFSFileDialog.this.fileName) {
                        String s = IFSFileDialog.this.fileName.getText();
                        int i = s.lastIndexOf("/");
                        if (i == -1) {
                            IFSFileDialog.this.fileList.setFilter(IFSFileDialog.this.fileName.getText());
                            IFSFileDialog.this.status.setText(WORKING_TEXT);
                            try {
                                IFSFileDialog.this.fileList.populateList();
                                IFSFileDialog.this.status.setText(READY_TEXT);
                            }
                            catch (Exception ex) {
                                IFSFileDialog.this.status.setText(ex.toString());
                            }
                        } else {
                            IFSFile f = new IFSFile(IFSFileDialog.this.sys_, s);
                            try {
                                if (f.isDirectory()) {
                                    IFSFileDialog.this.fileList.setPath(s);
                                    IFSFileDialog.this.directoryList.setPath(s);
                                    IFSFileDialog.this.status.setText(WORKING_TEXT);
                                    IFSFileDialog.this.directoryList.populateList();
                                    IFSFileDialog.this.fileList.populateList();
                                    IFSFileDialog.this.status.setText(READY_TEXT);
                                    IFSFileDialog.this.showCurrentDir(s);
                                    break block15;
                                }
                                String newPath = s.substring(0, i);
                                IFSFileDialog.this.directoryList.setPath(newPath);
                                IFSFileDialog.this.fileList.setPath(newPath);
                                String newFilter = s.substring(i + 1);
                                IFSFileDialog.this.fileList.setFilter(newFilter);
                                IFSFileDialog.this.status.setText(WORKING_TEXT);
                                IFSFileDialog.this.directoryList.populateList();
                                IFSFileDialog.this.fileList.populateList();
                                IFSFileDialog.this.status.setText(READY_TEXT);
                                IFSFileDialog.this.showCurrentDir(newPath);
                            }
                            catch (Exception ex) {
                                IFSFileDialog.this.status.setText(ex.toString());
                                ex.printStackTrace();
                            }
                        }
                    } else if (e.getSource() == IFSFileDialog.this.directoryList) {
                        IFSFileDialog.this.selectDirList();
                    } else if (e.getSource() == IFSFileDialog.this.cancel) {
                        IFSFileDialog.this.fileName.setText("");
                        IFSFileDialog.this.state_ = 2;
                        IFSFileDialog.this.dispose();
                    } else {
                        String s = IFSFileDialog.this.fileName.getText();
                        if (s != null && s.length() > 0) {
                            IFSFileDialog.this.state_ = 1;
                            IFSFileDialog.this.dispose();
                        }
                    }
                }
            }
        }

        public void keyTyped(KeyEvent e) {
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
            IFSFileDialog.this.fileName.setText("");
            IFSFileDialog.this.state_ = 2;
            IFSFileDialog.this.dispose();
        }

        public void windowDeactivated(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowOpened(WindowEvent e) {
        }
    }
}

