/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.vaccess.ChangeEventSupport;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VIFSFile;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VUtilities;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.text.DateFormat;
import java.util.TimeZone;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;

class IFSFilePropertiesPane
implements VPropertiesPane {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String attributesText_ = ResourceLoader.getText("IFS_ATTRIBUTES") + ":";
    private static final String byteText_ = ResourceLoader.getText("IFS_BYTE");
    private static final String bytesText_ = ResourceLoader.getText("IFS_BYTES");
    private static final String generalText_ = ResourceLoader.getText("TAB_GENERAL");
    private static final String locationText_ = ResourceLoader.getText("IFS_LOCATION") + ":";
    private static final String modifiedText_ = ResourceLoader.getText("IFS_MODIFIED") + ":";
    private static final String readText_ = ResourceLoader.getText("IFS_READ");
    private static final String sizeText_ = ResourceLoader.getText("IFS_SIZE") + ":";
    private static final String writeText_ = ResourceLoader.getText("IFS_WRITE");
    private static DateFormat dateFormat_ = DateFormat.getDateTimeInstance();
    private VIFSFile object_;
    private ChangeEventSupport changeEventSupport_ = new ChangeEventSupport(this);
    private ErrorEventSupport errorEventSupport_ = new ErrorEventSupport(this);
    private VObjectEventSupport objectEventSupport_ = new VObjectEventSupport(this);
    private WorkingEventSupport workingEventSupport_ = new WorkingEventSupport(this);

    public IFSFilePropertiesPane(VIFSFile object) {
        this.object_ = object;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeEventSupport_.addChangeListener(listener);
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    public void addVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.addVObjectListener(listener);
    }

    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    public void applyChanges() throws Exception {
    }

    public Component getComponent() {
        JPanel generalTab = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        generalTab.setLayout(layout);
        generalTab.setBorder(new EmptyBorder(10, 10, 10, 10));
        int row = 0;
        VUtilities.constrain(new JLabel(this.object_.getText(), this.object_.getIcon(32, false), 2), generalTab, layout, 0, row++, 2, 1);
        VUtilities.constrain(new JSeparator(), generalTab, layout, 0, row++, 2, 1);
        VUtilities.constrain(new JLabel(locationText_), generalTab, layout, 0, row, 1, 1);
        VUtilities.constrain(new JLabel(this.object_.getParentDirectory()), generalTab, layout, 1, row, 1, 1);
        VUtilities.constrain(new JLabel(sizeText_), generalTab, layout, 0, ++row, 1, 1);
        long size = this.object_.getSize();
        VUtilities.constrain(new JLabel(Long.toString(size) + " " + (size == 1L ? byteText_ : bytesText_)), generalTab, layout, 1, row, 1, 1);
        int n = ++row;
        VUtilities.constrain(new JSeparator(), generalTab, layout, 0, n, 2, 1);
        VUtilities.constrain(new JLabel(modifiedText_), generalTab, layout, 0, ++row, 1, 1);
        VUtilities.constrain(new JLabel(dateFormat_.format(this.object_.getModified())), generalTab, layout, 1, row, 1, 1);
        int n2 = ++row;
        VUtilities.constrain(new JSeparator(), generalTab, layout, 0, n2, 2, 1);
        VUtilities.constrain(new JLabel(attributesText_), generalTab, layout, 0, ++row, 1, 1);
        JCheckBox readCheckBox = new JCheckBox(readText_, this.object_.canRead());
        readCheckBox.setEnabled(false);
        VUtilities.constrain(readCheckBox, generalTab, layout, 1, row, 1, 1);
        JCheckBox writeCheckBox = new JCheckBox(writeText_, this.object_.canWrite());
        writeCheckBox.setEnabled(false);
        int n3 = ++row;
        ++row;
        VUtilities.constrain(writeCheckBox, generalTab, layout, 1, n3, 1, 1);
        JTabbedPane pane = new JTabbedPane();
        pane.addTab(generalText_, null, generalTab);
        pane.setSelectedIndex(0);
        return pane;
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeEventSupport_.removeChangeListener(listener);
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    public void removeVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.removeVObjectListener(listener);
    }

    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }

    static {
        dateFormat_.setTimeZone(TimeZone.getDefault());
    }
}

