/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ActionCompletedListener;
import com.ibm.as400.vaccess.ActionCompletedEventSupport;
import com.ibm.as400.vaccess.DBCellRenderer;
import com.ibm.as400.vaccess.ErrorEvent;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.RecordListData;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.SerializationListener;
import com.ibm.as400.vaccess.WorkingCursorAdapter;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class RecordListFormPane
extends JComponent
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    public static final int KEY_EQ = 0;
    public static final int KEY_GT = 1;
    public static final int KEY_GE = 2;
    public static final int KEY_LT = 3;
    public static final int KEY_LE = 4;
    private transient JLabel recordLabel_;
    private transient JLabel recordNumber_;
    transient JButton firstButton_;
    transient JButton lastButton_;
    transient JButton nextButton_;
    transient JButton previousButton_;
    transient JButton refreshButton_;
    private transient JLabel[] labels_ = new JLabel[0];
    private transient JTextField[] values_ = new JTextField[0];
    private transient DBCellRenderer[] formatter_ = new DBCellRenderer[0];
    private JLabel status_;
    private JPanel dataArea_;
    private DBCellRenderer leftCell_ = new DBCellRenderer(2);
    private static final int TYPE_CHAR = 1;
    private static final int TYPE_HEX = 2;
    private transient ActionCompletedEventSupport actionListeners_ = new ActionCompletedEventSupport(this);
    transient ErrorEventSupport errorListeners_ = new ErrorEventSupport(this);
    transient int current_ = -1;
    private RecordListData tableData_ = new RecordListData();
    transient boolean error_;
    private transient WorkingCursorAdapter worker_ = new WorkingCursorAdapter(this);

    public RecordListFormPane() {
        this.addFocusListener(new SerializationListener(this));
        this.tableData_.addErrorListener(new ErrorListener_());
        this.tableData_.addWorkingListener(this.worker_);
        this.init();
    }

    public RecordListFormPane(AS400 system, String fileName) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        this.addFocusListener(new SerializationListener(this));
        this.tableData_.setSystem(system);
        this.tableData_.setFileName(fileName);
        this.tableData_.addErrorListener(new ErrorListener_());
        this.tableData_.addWorkingListener(this.worker_);
        this.init();
    }

    public RecordListFormPane(AS400 system, String fileName, Object[] key, int searchType) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        this.addFocusListener(new SerializationListener(this));
        this.tableData_.setSystem(system);
        this.tableData_.setFileName(fileName);
        this.tableData_.setKeyed(true);
        this.tableData_.setKey(key);
        this.tableData_.setSearchType(searchType);
        this.tableData_.addErrorListener(new ErrorListener_());
        this.tableData_.addWorkingListener(this.worker_);
        this.init();
    }

    public void addActionCompletedListener(ActionCompletedListener listener) {
        this.actionListeners_.addActionCompletedListener(listener);
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorListeners_.addErrorListener(listener);
    }

    public void close() {
        this.tableData_.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayFirst() {
        RecordListFormPane recordListFormPane = this;
        synchronized (recordListFormPane) {
            this.current_ = 0;
            this.refreshScreen();
        }
        this.actionListeners_.fireActionCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayLast() {
        RecordListFormPane recordListFormPane = this;
        synchronized (recordListFormPane) {
            this.error_ = false;
            this.current_ = this.tableData_.getNumberOfRows() - 1;
            if (this.error_) {
                this.current_ = this.tableData_.getLastRecordProcessed();
            }
            this.refreshScreen();
        }
        this.actionListeners_.fireActionCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayNext() {
        RecordListFormPane recordListFormPane = this;
        synchronized (recordListFormPane) {
            this.current_ = this.tableData_.getAllRecordsProcessed() ? (this.current_ + 1 == this.tableData_.getNumberOfRows() ? 0 : ++this.current_) : ++this.current_;
            this.refreshScreen();
        }
        this.actionListeners_.fireActionCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayPrevious() {
        RecordListFormPane recordListFormPane = this;
        synchronized (recordListFormPane) {
            if (this.current_ < 1) {
                this.error_ = false;
                this.current_ = this.tableData_.getNumberOfRows() - 1;
                if (this.error_) {
                    this.current_ = this.tableData_.getLastRecordProcessed();
                }
            } else {
                --this.current_;
            }
            this.refreshScreen();
        }
        this.actionListeners_.fireActionCompleted();
    }

    public synchronized int getCurrentRecord() {
        return this.current_;
    }

    public String getFileName() {
        String result = this.tableData_.getFileName();
        if (result == null) {
            return "";
        }
        return result;
    }

    public Object[] getKey() {
        return this.tableData_.getKey();
    }

    public boolean getKeyed() {
        return this.tableData_.getKeyed();
    }

    public synchronized String getLabelText(int index) {
        return this.labels_[index].getText();
    }

    public int getSearchType() {
        return this.tableData_.getSearchType();
    }

    public AS400 getSystem() {
        return this.tableData_.getSystem();
    }

    public synchronized String getStringValueAt(int index) {
        return this.values_[index].getText();
    }

    public synchronized Object getValueAt(int index) {
        return this.tableData_.getValueAt(this.current_, index);
    }

    private void init() {
        this.recordLabel_ = new JLabel(ResourceLoader.getText("DBFORM_LABEL_RECORD_NUMBER"));
        this.recordNumber_ = new JLabel();
        String text = ResourceLoader.getText("DBFORM_TOOLTIP_FIRST");
        this.firstButton_ = new JButton(ResourceLoader.getIcon("FirstIcon.gif", text));
        this.firstButton_.setToolTipText(text);
        text = ResourceLoader.getText("DBFORM_TOOLTIP_LAST");
        this.lastButton_ = new JButton(ResourceLoader.getIcon("LastIcon.gif", text));
        this.lastButton_.setToolTipText(text);
        text = ResourceLoader.getText("DBFORM_TOOLTIP_NEXT");
        this.nextButton_ = new JButton(ResourceLoader.getIcon("NextIcon.gif", text));
        this.nextButton_.setToolTipText(text);
        text = ResourceLoader.getText("DBFORM_TOOLTIP_PREVIOUS");
        this.previousButton_ = new JButton(ResourceLoader.getIcon("PreviousIcon.gif", text));
        this.previousButton_.setToolTipText(text);
        text = ResourceLoader.getText("DBFORM_TOOLTIP_REFRESH");
        this.refreshButton_ = new JButton(ResourceLoader.getIcon("RefreshIcon.gif", text));
        this.refreshButton_.setToolTipText(text);
        ButtonListener_ l = new ButtonListener_();
        this.firstButton_.addActionListener(l);
        this.lastButton_.addActionListener(l);
        this.nextButton_.addActionListener(l);
        this.previousButton_.addActionListener(l);
        this.refreshButton_.addActionListener(l);
        this.dataArea_ = new JPanel();
        this.dataArea_.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.status_ = new JLabel(ResourceLoader.getText("DBFORM_MSG_NO_DATA"));
        this.setLayout(new BorderLayout());
        JPanel panel1 = new JPanel();
        panel1.setLayout(new FlowLayout(1));
        panel1.add(this.firstButton_);
        panel1.add(this.previousButton_);
        panel1.add(this.nextButton_);
        panel1.add(this.lastButton_);
        panel1.add(this.refreshButton_);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new FlowLayout(1));
        panel2.add(this.status_);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add("North", panel1);
        panel.add("South", panel2);
        this.add("South", panel);
        panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        panel.add(this.recordLabel_);
        panel.add(this.recordNumber_);
        this.add("North", panel);
        this.add("Center", this.dataArea_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        RecordListFormPane recordListFormPane = this;
        synchronized (recordListFormPane) {
            this.dataArea_.removeAll();
            IllegalStateException exception = null;
            this.error_ = false;
            if (this.tableData_.getSystem() == null) {
                exception = new IllegalStateException("system");
                this.error_ = true;
            } else if (this.tableData_.getFileName() == null) {
                exception = new IllegalStateException("fileName");
                this.error_ = true;
            } else {
                this.tableData_.load();
            }
            if (this.error_) {
                this.values_ = new JTextField[0];
                this.labels_ = new JLabel[0];
                this.current_ = -1;
                this.refreshScreen();
                if (exception != null) {
                    throw exception;
                }
                return;
            }
            int num = this.tableData_.getNumberOfColumns();
            this.labels_ = new JLabel[num];
            this.values_ = new JTextField[num];
            DBCellRenderer leftCell = new DBCellRenderer(2);
            this.formatter_ = new DBCellRenderer[num];
            this.dataArea_.setLayout(new GridLayout(num, 1));
            Class<?> byteClass = new byte[0].getClass();
            for (int i = 0; i < num; ++i) {
                JLabel label;
                this.labels_[i] = label = new JLabel(this.tableData_.getColumnLabel(i));
                Object v = null;
                int j = 0;
                while (!this.tableData_.getAllRecordsProcessed() && v == null) {
                    v = this.tableData_.getValueAt(j, i);
                    ++j;
                }
                int type = v != null && v.getClass() == byteClass ? 2 : 1;
                int size = this.tableData_.getColumnDisplaySize(i);
                JTextField value = new JTextField(size);
                value.setEditable(false);
                this.values_[i] = value;
                this.formatter_[i] = leftCell;
                JPanel panel = new JPanel();
                panel.setLayout(new FlowLayout(0));
                panel.add(this.labels_[i]);
                panel.add(this.values_[i]);
                this.dataArea_.add(panel);
            }
            this.current_ = 0;
            this.refreshScreen();
        }
        this.actionListeners_.fireActionCompleted();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.actionListeners_ = new ActionCompletedEventSupport(this);
        this.errorListeners_ = new ErrorEventSupport(this);
        this.worker_ = new WorkingCursorAdapter(this);
        this.labels_ = new JLabel[0];
        this.values_ = new JTextField[0];
        this.formatter_ = new DBCellRenderer[0];
        this.current_ = -1;
        this.init();
    }

    private void refreshScreen() {
        if (this.values_.length == 0) {
            this.current_ = -1;
        } else if (this.tableData_.getAllRecordsProcessed() && this.tableData_.getNumberOfRows() == 0) {
            this.current_ = -1;
        }
        if (this.current_ == -1) {
            this.status_.setText(ResourceLoader.getText("DBFORM_MSG_NO_DATA"));
            int num = this.values_.length;
            for (int i = 0; i < num; ++i) {
                this.values_[i].setText("");
            }
            this.recordNumber_.setText("");
        } else {
            int num = this.values_.length;
            for (int i = 0; i < num; ++i) {
                Object data = this.tableData_.getValueAt(this.current_, i);
                this.values_[i].setText(this.formatter_[i].getText(data));
            }
            this.recordNumber_.setText(String.valueOf(this.current_ + 1));
            this.recordNumber_.setSize(this.recordNumber_.getPreferredSize());
            this.status_.setText("");
        }
        this.validate();
    }

    public void removeActionCompletedListener(ActionCompletedListener listener) {
        this.actionListeners_.removeActionCompletedListener(listener);
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorListeners_.removeErrorListener(listener);
    }

    public void setFileName(String fileName) throws PropertyVetoException {
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        String old = this.getFileName();
        this.fireVetoableChange("fileName", old, fileName);
        this.tableData_.setFileName(fileName);
        this.firePropertyChange("fileName", old, fileName);
    }

    public void setKey(Object[] key) throws PropertyVetoException {
        Object[] old = this.getKey();
        this.fireVetoableChange("key", old, key);
        this.tableData_.setKey(key);
        this.firePropertyChange("key", old, key);
    }

    public void setKeyed(boolean keyed) throws PropertyVetoException {
        Boolean old = new Boolean(this.getKeyed());
        this.fireVetoableChange("keyed", old, new Boolean(keyed));
        this.tableData_.setKeyed(keyed);
        this.firePropertyChange("keyed", old, new Boolean(keyed));
    }

    public void setLabelText(int index, String text) {
        this.labels_[index].setText(text);
    }

    public void setSearchType(int searchType) throws PropertyVetoException {
        int old = this.getSearchType();
        this.fireVetoableChange("searchType", new Integer(old), new Integer(searchType));
        this.tableData_.setSearchType(searchType);
        this.firePropertyChange("searchType", new Integer(old), new Integer(searchType));
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        AS400 old = this.getSystem();
        this.fireVetoableChange("system", old, system);
        this.tableData_.setSystem(system);
        this.firePropertyChange("system", old, system);
    }

    private class ErrorListener_
    implements ErrorListener {
        private ErrorListener_() {
        }

        public void errorOccurred(ErrorEvent event) {
            RecordListFormPane.this.error_ = true;
            RecordListFormPane.this.errorListeners_.fireError(event.getException());
        }
    }

    private class ButtonListener_
    implements ActionListener {
        private ButtonListener_() {
        }

        public void actionPerformed(ActionEvent ev) {
            Object source = ev.getSource();
            if (source == RecordListFormPane.this.firstButton_) {
                RecordListFormPane.this.displayFirst();
            } else if (source == RecordListFormPane.this.lastButton_) {
                RecordListFormPane.this.displayLast();
            } else if (source == RecordListFormPane.this.nextButton_) {
                RecordListFormPane.this.displayNext();
            } else if (source == RecordListFormPane.this.previousButton_) {
                RecordListFormPane.this.displayPrevious();
            } else if (source == RecordListFormPane.this.refreshButton_) {
                RecordListFormPane.this.load();
            }
        }
    }
}

