/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.DBCellRenderer;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ListSelectionEventSupport;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.RecordListTableModel;
import com.ibm.as400.vaccess.SerializationListener;
import com.ibm.as400.vaccess.VObjectHeaderRenderer;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingCursorAdapter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class RecordListTablePane
extends JComponent
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    public static final int KEY_EQ = 0;
    public static final int KEY_GT = 1;
    public static final int KEY_GE = 2;
    public static final int KEY_LT = 3;
    public static final int KEY_LE = 4;
    transient JTable table_;
    transient JScrollPane tablePane_;
    RecordListTableModel model_;
    private Color tableColor_ = null;
    private boolean tableShowHorizontalLines_ = true;
    private boolean tableShowVerticalLines_ = true;
    private transient PropertyChangeSupport changeListeners_ = new PropertyChangeSupport(this);
    private transient VetoableChangeSupport vetoListeners_ = new VetoableChangeSupport(this);
    private transient ErrorEventSupport errorListeners_ = new ErrorEventSupport(this);
    private transient ListSelectionEventSupport selectionListeners_ = new ListSelectionEventSupport(this);
    private transient WorkingCursorAdapter worker_ = new WorkingCursorAdapter(this);
    DBCellRenderer rightCell_ = new DBCellRenderer(4);
    DBCellRenderer leftCell_ = new DBCellRenderer(2);
    private static final int TYPE_CHAR = 1;
    private static final int TYPE_HEX = 2;
    private static final int TYPE_NUMBER = 3;

    public RecordListTablePane() {
        this.model_ = new RecordListTableModel();
        this.initializeTransient();
    }

    public RecordListTablePane(AS400 system, String fileName) {
        this.model_ = new RecordListTableModel(system, fileName);
        this.initializeTransient();
    }

    public RecordListTablePane(AS400 system, String fileName, Object[] key, int searchType) {
        this.model_ = new RecordListTableModel(system, fileName, key, searchType);
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorListeners_.addErrorListener(listener);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.selectionListeners_.addListSelectionListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeListeners_.addPropertyChangeListener(listener);
        super.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoListeners_.addVetoableChangeListener(listener);
        super.addVetoableChangeListener(listener);
    }

    public void close() {
        this.model_.close();
    }

    public TableColumnModel getColumnModel() {
        return this.table_.getColumnModel();
    }

    public String getColumnTitle(int columnIndex) {
        try {
            return (String)this.table_.getColumnModel().getColumn(columnIndex).getHeaderValue();
        }
        catch (Exception e) {
            Trace.log(4, "getColumnTitle() error:" + e);
            return null;
        }
    }

    public int getColumnWidth(int columnIndex) {
        try {
            return this.table_.getColumnModel().getColumn(columnIndex).getPreferredWidth();
        }
        catch (Exception e) {
            Trace.log(4, "getColumnWidth() error:" + e);
            return 0;
        }
    }

    public RecordListTableModel getDataModel() {
        return this.model_;
    }

    public String getFileName() {
        return this.model_.getFileName();
    }

    public Color getGridColor() {
        return this.tableColor_;
    }

    public Object[] getKey() {
        return this.model_.getKey();
    }

    public boolean getKeyed() {
        return this.model_.getKeyed();
    }

    public int getSearchType() {
        return this.model_.getSearchType();
    }

    public ListSelectionModel getSelectionModel() {
        return this.table_.getSelectionModel();
    }

    public boolean getShowHorizontalLines() {
        return this.tableShowHorizontalLines_;
    }

    public boolean getShowVerticalLines() {
        return this.tableShowVerticalLines_;
    }

    public AS400 getSystem() {
        return this.model_.getSystem();
    }

    public String getStringValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.model_.getRowCount()) {
            Trace.log(4, "getStringValueAt() column out of range");
            return null;
        }
        try {
            TableColumnModel cmodel = this.getColumnModel();
            Component cellComp = cmodel.getColumn(columnIndex).getCellRenderer().getTableCellRendererComponent(this.table_, this.getValueAt(rowIndex, columnIndex), false, false, rowIndex, columnIndex);
            if (cellComp instanceof JLabel) {
                return ((JLabel)cellComp).getText();
            }
            return null;
        }
        catch (Exception e) {
            Trace.log(4, "getStringValueAt() error:" + e);
            return null;
        }
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            return this.model_.getValueAt(rowIndex, this.getColumnModel().getColumn(columnIndex).getModelIndex());
        }
        catch (Exception e) {
            Trace.log(4, "getStringValueAt() error:" + e);
            return null;
        }
    }

    private void initializeTransient() {
        this.table_ = new JTable();
        this.table_.setAutoCreateColumnsFromModel(false);
        this.table_.setModel(this.model_);
        this.table_.setAutoResizeMode(0);
        if (this.tableColor_ == null) {
            this.tableColor_ = this.table_.getGridColor();
        }
        this.model_.addPropertyChangeListener(this.changeListeners_);
        this.model_.addVetoableChangeListener(this.vetoListeners_);
        this.model_.addErrorListener(this.errorListeners_);
        this.model_.addWorkingListener(this.worker_);
        this.table_.getSelectionModel().addListSelectionListener(this.selectionListeners_);
        this.setLayout(new BorderLayout());
        this.tablePane_ = new JScrollPane(this.table_);
        this.add("Center", this.tablePane_);
        this.addFocusListener(new SerializationListener(this));
        this.addFocusListener(new SerializationListener(this.model_, this.table_));
    }

    public void load() {
        this.model_.load();
        this.refreshHeadings();
    }

    public void moveColumn(int columnIndex, int newIndex) {
        try {
            this.table_.getColumnModel().moveColumn(columnIndex, newIndex);
        }
        catch (Exception e) {
            Trace.log(4, "moveColumn() error:" + e);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.changeListeners_ = new PropertyChangeSupport(this);
        this.model_.addPropertyChangeListener(this.changeListeners_);
        this.vetoListeners_ = new VetoableChangeSupport(this);
        this.model_.addVetoableChangeListener(this.vetoListeners_);
        this.errorListeners_ = new ErrorEventSupport(this);
        this.model_.addErrorListener(this.errorListeners_);
        this.worker_ = new WorkingCursorAdapter(this);
        this.model_.addWorkingListener(this.worker_);
        this.selectionListeners_ = new ListSelectionEventSupport(this);
        this.initializeTransient();
        this.table_.setGridColor(this.tableColor_);
        this.table_.setShowHorizontalLines(this.tableShowHorizontalLines_);
        this.table_.setShowVerticalLines(this.tableShowVerticalLines_);
    }

    public void refreshHeadings() {
        Runnable refreshHeading = new Runnable(){

            public void run() {
                TableColumnModel model = RecordListTablePane.this.table_.getColumnModel();
                int oldColumnCount = model.getColumnCount();
                TableColumn[] oldColumns = new TableColumn[oldColumnCount];
                Enumeration<TableColumn> e = model.getColumns();
                int i = 0;
                while (e.hasMoreElements()) {
                    oldColumns[i] = e.nextElement();
                    ++i;
                }
                for (i = 0; i < oldColumnCount; ++i) {
                    model.removeColumn(oldColumns[i]);
                }
                int numColumns = RecordListTablePane.this.model_.getColumnCount();
                Class<?> byteClass = new byte[0].getClass();
                int size = 0;
                if (RecordListTablePane.this.table_.getFont() != null) {
                    size = RecordListTablePane.this.table_.getFontMetrics(RecordListTablePane.this.table_.getFont()).charWidth('M');
                }
                for (int i2 = 0; i2 < numColumns; ++i2) {
                    TableColumn col = new TableColumn(i2);
                    col.setIdentifier(RecordListTablePane.this.model_.getColumnID(i2));
                    Class rlaType = RecordListTablePane.this.model_.getColumnClass(i2);
                    int type = rlaType == Integer.class || rlaType == Short.class || rlaType == Float.class || rlaType == BigDecimal.class || rlaType == Double.class ? 3 : (rlaType == byteClass ? 2 : 1);
                    String title = RecordListTablePane.this.model_.getColumnName(i2);
                    if (type == 3) {
                        col.setCellRenderer(RecordListTablePane.this.rightCell_);
                        col.setHeaderRenderer(new VObjectHeaderRenderer(title, 4));
                    } else {
                        col.setCellRenderer(RecordListTablePane.this.leftCell_);
                        col.setHeaderRenderer(new VObjectHeaderRenderer(title, 2));
                    }
                    if (size != 0) {
                        int colTitleSize;
                        int colDataSize = RecordListTablePane.this.model_.getColumnWidth(i2);
                        if (type == 2) {
                            colDataSize *= 2;
                        }
                        int colSize = colDataSize > (colTitleSize = title.length()) ? colDataSize : colTitleSize;
                        col.setPreferredWidth(colSize * size + 10);
                    }
                    RecordListTablePane.this.table_.addColumn(col);
                }
                if (oldColumnCount == 0 && numColumns > 0) {
                    if (RecordListTablePane.this.tablePane_ != null) {
                        RecordListTablePane.this.remove(RecordListTablePane.this.tablePane_);
                    }
                    RecordListTablePane.this.tablePane_ = new JScrollPane(RecordListTablePane.this.table_);
                    RecordListTablePane.this.add("Center", RecordListTablePane.this.tablePane_);
                }
                RecordListTablePane.this.validate();
            }
        };
        try {
            SwingUtilities.invokeAndWait(refreshHeading);
        }
        catch (Error e) {
            Trace.log(1, "invokeAndWait error:" + e);
            refreshHeading.run();
        }
        catch (Exception e) {
            Trace.log(2, "invokeAndWait exception:" + e);
        }
    }

    public void removeColumn(int columnIndex) {
        try {
            this.table_.getColumnModel().removeColumn(this.table_.getColumnModel().getColumn(columnIndex));
        }
        catch (Exception e) {
            Trace.log(4, "removeColumn() error:" + e);
        }
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorListeners_.removeErrorListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.selectionListeners_.removeListSelectionListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeListeners_.removePropertyChangeListener(listener);
        super.removePropertyChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoListeners_.removeVetoableChangeListener(listener);
        super.removeVetoableChangeListener(listener);
    }

    public void setColumnTitle(int columnIndex, String title) {
        try {
            this.table_.getColumnModel().getColumn(columnIndex).setHeaderValue(title);
        }
        catch (Exception e) {
            Trace.log(4, "setColumnTitle() error:" + e);
        }
        this.validate();
    }

    public void setColumnWidth(int columnIndex, int width) {
        try {
            this.table_.getColumnModel().getColumn(columnIndex).setPreferredWidth(width);
        }
        catch (Exception e) {
            Trace.log(4, "setColumnWidth() error:" + e);
        }
    }

    public void setFileName(String fileName) throws PropertyVetoException {
        this.model_.setFileName(fileName);
    }

    public void setGridColor(Color color) {
        this.table_.setGridColor(color);
        this.tableColor_ = color;
    }

    public void setKey(Object[] key) throws PropertyVetoException {
        this.model_.setKey(key);
    }

    public void setKeyed(boolean keyed) throws PropertyVetoException {
        this.model_.setKeyed(keyed);
    }

    public void setSearchType(int searchType) throws PropertyVetoException {
        this.model_.setSearchType(searchType);
    }

    public void setSelectionModel(ListSelectionModel model) {
        this.table_.getSelectionModel().removeListSelectionListener(this.selectionListeners_);
        this.table_.setSelectionModel(model);
        this.table_.getSelectionModel().addListSelectionListener(this.selectionListeners_);
    }

    public void setShowHorizontalLines(boolean show) {
        this.table_.setShowHorizontalLines(show);
        this.tableShowHorizontalLines_ = show;
    }

    public void setShowVerticalLines(boolean show) {
        this.table_.setShowVerticalLines(show);
        this.tableShowVerticalLines_ = show;
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        this.model_.setSystem(system);
    }
}

