/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceList;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ListSelectionEventSupport;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceCellRenderer;
import com.ibm.as400.vaccess.ResourceListModel;
import com.ibm.as400.vaccess.ResourceListPopupMenuAdapter;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.ResourceProperties;
import com.ibm.as400.vaccess.WorkingCursorAdapter;
import java.awt.BorderLayout;
import java.awt.Point;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;

public class ResourceListPane
extends JComponent
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String ACTION_PROPERTIES_ = ResourceLoader.getText("ACTION_PROPERTIES");
    private static final String ACTION_LIST_PROPERTIES_ = ResourceLoader.getText("ACTION_LIST_PROPERTIES");
    private boolean allowActions_ = true;
    private transient JList list_ = null;
    private ResourceListModel model_ = null;
    private ResourceProperties resourceProperties_ = null;
    private transient ErrorEventSupport errorEventSupport_;
    private transient ListSelectionEventSupport listSelectionEventSupport_;
    private transient ResourceListPopupMenuAdapter popupMenuAdapter_;
    private transient PropertyChangeSupport propertyChangeSupport_;

    public ResourceListPane() {
        this.initializeCommon();
        this.resourceProperties_ = new ResourceProperties();
    }

    public ResourceListPane(ResourceList resourceList, ResourceProperties resourceProperties) {
        if (resourceList == null) {
            throw new NullPointerException("resourceList");
        }
        if (resourceProperties == null) {
            throw new NullPointerException("resourceProperties");
        }
        this.initializeCommon();
        this.resourceProperties_ = resourceProperties;
        this.model_.setResourceList(resourceList);
        this.popupMenuAdapter_.setResourceList(resourceList);
        this.popupMenuAdapter_.setResourceProperties(resourceProperties);
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.listSelectionEventSupport_.addListSelectionListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        this.propertyChangeSupport_.addPropertyChangeListener(listener);
    }

    public boolean getAllowActions() {
        return this.allowActions_;
    }

    public ListModel getModel() {
        return this.model_;
    }

    public Resource getResourceAtPoint(Point point) {
        Resource resource = null;
        int row = this.list_.locationToIndex(point);
        if (row != -1) {
            resource = (Resource)this.model_.getElementAt(row);
        }
        return resource;
    }

    public ResourceList getResourceList() {
        return this.model_.getResourceList();
    }

    public ResourceProperties getResourceProperties() {
        return this.resourceProperties_;
    }

    public Resource getSelectedResource() {
        Resource selectedResource = null;
        int selectedIndex = this.list_.getSelectedIndex();
        if (selectedIndex >= 0) {
            selectedResource = (Resource)this.model_.getElementAt(selectedIndex);
        }
        return selectedResource;
    }

    public Resource[] getSelectedResources() {
        int[] selectedIndices = this.list_.getSelectedIndices();
        int selectedCount = selectedIndices.length;
        Resource[] selectedResources = new Resource[selectedCount];
        for (int i = 0; i < selectedCount; ++i) {
            selectedResources[i] = (Resource)this.model_.getElementAt(selectedIndices[i]);
        }
        return selectedResources;
    }

    public ListSelectionModel getSelectionModel() {
        return this.list_.getSelectionModel();
    }

    public int getVisibleRowCount() {
        return this.list_.getVisibleRowCount();
    }

    private void initializeCommon() {
        this.model_ = new ResourceListModel();
        this.initializeTransient();
        this.setLayout(new BorderLayout());
        this.add("Center", new JScrollPane(this.list_));
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.listSelectionEventSupport_ = new ListSelectionEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.list_ = new JList(this.model_);
        this.list_.setCellRenderer(new ResourceCellRenderer(null));
        this.model_.addErrorListener(this.errorEventSupport_);
        this.model_.addPropertyChangeListener(this.propertyChangeSupport_);
        this.list_.getSelectionModel().addListSelectionListener(this.listSelectionEventSupport_);
        this.popupMenuAdapter_ = new ResourceListPopupMenuAdapter(this, this.model_.getResourceList(), this.resourceProperties_, this.errorEventSupport_);
        this.model_.addWorkingListener(new WorkingCursorAdapter(this.list_));
        this.setAllowActions(this.allowActions_);
    }

    public boolean isSelected(Resource resource) {
        if (resource == null) {
            throw new NullPointerException("resource");
        }
        Object[] selectedResources = this.list_.getSelectedValues();
        for (int i = 0; i < selectedResources.length; ++i) {
            if (!selectedResources[i].equals(resource)) continue;
            return true;
        }
        return false;
    }

    public void load() {
        this.list_.clearSelection();
        this.model_.load();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.listSelectionEventSupport_.removeListSelectionListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        this.propertyChangeSupport_.removePropertyChangeListener(listener);
    }

    public void setAllowActions(boolean allowActions) {
        Boolean oldValue = new Boolean(this.allowActions_);
        this.allowActions_ = allowActions;
        if (this.allowActions_) {
            this.list_.addMouseListener(this.popupMenuAdapter_);
        } else {
            this.list_.removeMouseListener(this.popupMenuAdapter_);
        }
        this.propertyChangeSupport_.firePropertyChange("allowActions", oldValue, new Boolean(allowActions));
    }

    public void setResourceList(ResourceList resourceList) {
        if (resourceList == null) {
            throw new NullPointerException("resourceList");
        }
        this.list_.clearSelection();
        this.model_.setResourceList(resourceList);
        this.popupMenuAdapter_.setResourceList(resourceList);
    }

    public void setResourceProperties(ResourceProperties resourceProperties) {
        if (resourceProperties == null) {
            throw new NullPointerException("resourceProperties");
        }
        ResourceProperties oldValue = this.resourceProperties_;
        this.resourceProperties_ = resourceProperties;
        this.popupMenuAdapter_.setResourceProperties(resourceProperties);
        this.propertyChangeSupport_.firePropertyChange("resourceProperties", oldValue, resourceProperties);
    }

    public void setSelectionModel(ListSelectionModel selectionModel) {
        if (selectionModel == null) {
            throw new NullPointerException("selectionModel");
        }
        ListSelectionModel oldSelectionModel = this.list_.getSelectionModel();
        oldSelectionModel.removeListSelectionListener(this.listSelectionEventSupport_);
        this.list_.setSelectionModel(selectionModel);
        selectionModel.addListSelectionListener(this.listSelectionEventSupport_);
    }

    public void setVisibleRowCount(int visibleRowCount) {
        this.list_.setVisibleRowCount(visibleRowCount);
    }
}

