/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.Trace;
import com.ibm.as400.resource.ChangeableResource;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceMetaData;
import com.ibm.as400.vaccess.ChangeEventSupport;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ResourceProperties;
import com.ibm.as400.vaccess.VUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;

class ResourcePropertiesTabbedPane
extends JComponent {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private Hashtable changes_ = new Hashtable();
    private ResourceMetaData[] attributeMetaData_;
    private Presentation presentation_;
    private ResourceProperties properties_;
    private Resource resource_;
    private ChangeEventSupport changeEventSupport_ = new ChangeEventSupport(this);
    private ErrorEventSupport errorEventSupport_ = new ErrorEventSupport(this);

    public ResourcePropertiesTabbedPane(Resource resource, ResourceProperties properties) {
        this.resource_ = resource;
        this.properties_ = properties != null ? properties : new ResourceProperties();
        this.attributeMetaData_ = resource.getAttributeMetaData();
        this.presentation_ = resource.getPresentation();
        JTabbedPane tabbedPane = new JTabbedPane();
        int tabCount = this.properties_.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            tabbedPane.addTab(this.properties_.getLabel(i), this.createTabComponent(i));
        }
        this.setLayout(new BorderLayout());
        this.add("Center", tabbedPane);
    }

    public void addChangeListener(ChangeListener listener) {
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.changeEventSupport_.addChangeListener(listener);
    }

    public void addErrorListener(ErrorListener listener) {
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.errorEventSupport_.addErrorListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyChanges() {
        Hashtable hashtable = this.changes_;
        synchronized (hashtable) {
            try {
                if (this.resource_ instanceof ChangeableResource) {
                    Enumeration attributeIDs = this.changes_.keys();
                    while (attributeIDs.hasMoreElements()) {
                        Object attributeID = attributeIDs.nextElement();
                        Object value = this.changes_.get(attributeID);
                        if (this.resource_.getAttributeMetaData(attributeID).getType() == Integer.class && value instanceof String) {
                            value = new Integer((String)value);
                        }
                        ((ChangeableResource)this.resource_).setAttributeValue(attributeID, value);
                    }
                    ((ChangeableResource)this.resource_).commitAttributeChanges();
                }
            }
            catch (Exception e) {
                if (Trace.isTraceOn()) {
                    Trace.log(2, "Error applying changes", (Throwable)e);
                }
                this.errorEventSupport_.fireError(e);
            }
            this.changes_.clear();
        }
    }

    private Component createAttributeComponent(ResourceMetaData attributeMetaData) throws ResourceException {
        Object attributeID = attributeMetaData.getID();
        Object initialValue = this.resource_.getAttributeValue(attributeID);
        boolean editable = this.properties_.isEditable() && !attributeMetaData.isReadOnly();
        JComponent component = null;
        Class type = attributeMetaData.getType();
        Object[] possibleValues = attributeMetaData.getPossibleValues();
        if (type == Boolean.class) {
            JCheckBox checkBox = new JCheckBox("", (boolean)((Boolean)initialValue));
            checkBox.setEnabled(editable);
            checkBox.addActionListener(new ChangeListener_(attributeID));
            component = checkBox;
        } else if (type.isArray()) {
            Object[] initialValues = (Object[])initialValue;
            JList<Object> list = new JList<Object>(initialValues);
            list.setEnabled(false);
            list.setVisibleRowCount(Math.min(5, initialValues.length));
            component = list;
        } else if (possibleValues != null && possibleValues.length > 0) {
            if (editable) {
                JComboBox<Object> comboBox = new JComboBox<Object>();
                for (int i = 0; i < possibleValues.length; ++i) {
                    comboBox.addItem(possibleValues[i]);
                }
                comboBox.setRenderer(new JComboBoxRenderer(attributeMetaData));
                comboBox.setEditor(new JComboBoxEditor(attributeMetaData));
                comboBox.setEditable(!attributeMetaData.isValueLimited());
                comboBox.setSelectedItem(initialValue);
                ChangeListener_ changeListener = new ChangeListener_(attributeID);
                comboBox.addItemListener(changeListener);
                comboBox.getEditor().getEditorComponent().addKeyListener(changeListener);
                component = comboBox;
            } else {
                component = new JLabel(attributeMetaData.getPossibleValuePresentation(initialValue).getFullName());
            }
        }
        if (component == null) {
            if (editable) {
                JTextField textField = new JTextField(initialValue.toString());
                int initialValueLength = initialValue.toString().length();
                textField.setColumns(Math.max(10, Math.min(30, initialValueLength)));
                textField.addKeyListener(new ChangeListener_(attributeID));
                component = textField;
            } else {
                String text = initialValue.toString();
                if (text.length() > 30) {
                    component = new JTextArea(VUtilities.formatHelp2(text, 40));
                    ((JTextArea)component).setEditable(false);
                    ((Component)component).setBackground(null);
                } else {
                    component = new JLabel(initialValue.toString());
                }
            }
        }
        return component;
    }

    private Component createAttributeBox(Object[] attributeIDs, int firstIndex, int numberOfAttributes) {
        JPanel attributePanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        attributePanel.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(2, 2, 2, 2);
        int row = 0;
        for (int i = firstIndex; i < numberOfAttributes; ++i) {
            ResourceMetaData attributeMetaData = this.resource_.getAttributeMetaData(attributeIDs[i]);
            if (attributeMetaData != null) {
                Presentation presentation2 = attributeMetaData.getPresentation();
                String componentLabel = null;
                componentLabel = presentation2 != null ? presentation2.getFullName() : attributeMetaData.getID().toString();
                JLabel leftComponent = new JLabel(componentLabel + ':');
                attributePanel.add(leftComponent);
                constraints.gridx = 0;
                constraints.gridy = row;
                layout.setConstraints(leftComponent, constraints);
                try {
                    Component rightComponent = this.createAttributeComponent(attributeMetaData);
                    attributePanel.add(rightComponent);
                    constraints.gridx = 1;
                    constraints.gridy = row;
                    layout.setConstraints(rightComponent, constraints);
                }
                catch (ResourceException e) {
                    if (Trace.isTraceOn()) {
                        Trace.log(2, "Error creating attribute component for:" + attributeIDs[i], (Throwable)e);
                    }
                    this.errorEventSupport_.fireError(e);
                }
            } else {
                JLabel leftComponent = new JLabel(attributeIDs[i].toString() + ':');
                attributePanel.add(leftComponent);
                constraints.gridx = 0;
                constraints.gridy = row;
                layout.setConstraints(leftComponent, constraints);
            }
            ++row;
        }
        JPanel spacer = new JPanel();
        attributePanel.add(spacer);
        constraints.gridx = 0;
        constraints.gridy = row;
        constraints.gridwidth = 2;
        constraints.weighty = 1.0;
        layout.setConstraints(spacer, constraints);
        Box attributeBox = new Box(1);
        attributeBox.add(attributePanel);
        attributeBox.add(Box.createVerticalGlue());
        return attributeBox;
    }

    private Component createTabComponent(int tab) {
        Box overallBox = new Box(1);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add("Center", overallBox);
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        if (tab == 0) {
            JLabel label = new JLabel(this.presentation_.getFullName(), new ImageIcon((Image)this.presentation_.getValue("32")), 2);
            Box labelBox = new Box(0);
            labelBox.add(label);
            labelBox.add(Box.createHorizontalGlue());
            overallBox.add(labelBox);
            JSeparator separator = new JSeparator();
            separator.setMaximumSize(new Dimension(separator.getMaximumSize().width, separator.getPreferredSize().height));
            overallBox.add(Box.createRigidArea(new Dimension(0, 6)));
            overallBox.add(separator);
            overallBox.add(Box.createRigidArea(new Dimension(0, 6)));
        }
        Object[] attributeIDs = this.properties_.getProperties(tab);
        overallBox.add(this.createAttributeBox(attributeIDs, 0, attributeIDs.length));
        overallBox.add(Box.createVerticalGlue());
        return panel;
    }

    public void removeChangeListener(ChangeListener listener) {
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.changeEventSupport_.removeChangeListener(listener);
    }

    public void removeErrorListener(ErrorListener listener) {
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.errorEventSupport_.removeErrorListener(listener);
    }

    private class JComboBoxRenderer
    extends DefaultListCellRenderer {
        private ResourceMetaData metaData_;

        public JComboBoxRenderer(ResourceMetaData metaData) {
            this.metaData_ = metaData;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object fullName = value;
            if (value != null) {
                fullName = this.metaData_.getPossibleValuePresentation(value).getFullName();
            }
            return super.getListCellRendererComponent((JList<?>)list, fullName, index, isSelected, cellHasFocus);
        }
    }

    private class JComboBoxEditor
    implements ComboBoxEditor {
        private ResourceMetaData metaData_;
        private JTextField editorComponent_ = new JTextField();

        public JComboBoxEditor(ResourceMetaData metaData) {
            this.metaData_ = metaData;
        }

        public void addActionListener(ActionListener listener) {
            this.editorComponent_.addActionListener(listener);
        }

        public Component getEditorComponent() {
            return this.editorComponent_;
        }

        public Object getItem() {
            Object item = this.editorComponent_.getText();
            Object[] possibleValues = this.metaData_.getPossibleValues();
            if (possibleValues != null) {
                for (int i = 0; i < possibleValues.length; ++i) {
                    if (!this.metaData_.getPossibleValuePresentation(possibleValues[i]).getFullName().equals(item)) continue;
                    item = possibleValues[i];
                }
            }
            return item;
        }

        public void removeActionListener(ActionListener listener) {
            this.editorComponent_.removeActionListener(listener);
        }

        public void selectAll() {
            this.editorComponent_.selectAll();
        }

        public void setItem(Object item) {
            Presentation presentation;
            Object fullName = item;
            if (item != null && (presentation = this.metaData_.getPossibleValuePresentation(item)) != null) {
                fullName = presentation.getFullName();
            }
            this.editorComponent_.setText(fullName == null ? "" : fullName.toString());
        }
    }

    private class ChangeListener_
    extends KeyAdapter
    implements ActionListener,
    ItemListener {
        private Object attributeID_;

        public ChangeListener_(Object attributeID) {
            this.attributeID_ = attributeID;
        }

        public void actionPerformed(ActionEvent event) {
            this.registerChange(new Boolean(((JCheckBox)event.getSource()).isSelected()));
        }

        public void itemStateChanged(ItemEvent event) {
            this.registerChange(event.getItem());
        }

        public void keyReleased(KeyEvent event) {
            this.registerChange(((JTextField)event.getSource()).getText());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerChange(Object value) {
            Hashtable hashtable = ResourcePropertiesTabbedPane.this.changes_;
            synchronized (hashtable) {
                ResourcePropertiesTabbedPane.this.changes_.put(this.attributeID_, value);
            }
            ResourcePropertiesTabbedPane.this.changeEventSupport_.fireStateChanged();
        }
    }
}

