/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.vaccess.DoubleClickList;
import com.ibm.as400.vaccess.LabelledComponent;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.SQLQueryBuilderPane;
import com.ibm.as400.vaccess.SQLQueryClause;
import com.ibm.as400.vaccess.SQLQueryFieldsPane;
import com.ibm.as400.vaccess.ScrollingTextPane;
import java.awt.BorderLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class SQLQuerySelectPane
extends SQLQueryFieldsPane {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    DoubleClickList functionList_;
    SQLQueryClause clause_;
    private static final String FCN_COUNT_ = "COUNT";
    private static final String FCN_SUM_ = "SUM";
    private static final String FCN_AVG_ = "AVG";
    private static final String FCN_MIN_ = "MIN";
    private static final String FCN_MAX_ = "MAX";
    String[] selectFields_ = new String[0];
    String[] selectItems_ = new String[0];
    boolean changes_ = false;
    static final String[] functionChoices = new String[]{"AVG", "COUNT", "MIN", "MAX", "SUM"};
    private boolean init_ = false;
    private transient DocumentListener_ docListener_;
    PropertyChangeSupport selectListeners_ = new PropertyChangeSupport(this);

    public SQLQuerySelectPane(SQLQueryBuilderPane parent) {
        super(parent);
        this.parent_.addFieldListener(new FieldListener2_());
    }

    public void addSelectListener(PropertyChangeListener listener) {
        this.selectListeners_.addPropertyChangeListener(listener);
    }

    private void addToClause(String text) {
        if (this.clause_.getText().equals("*")) {
            this.clause_.setText(text);
        } else {
            this.clause_.appendTextWithComma(text);
        }
    }

    void functionPicked(String item) {
        if (item.equals(FCN_COUNT_)) {
            this.addToClause("COUNT(*)");
        } else {
            Object[] choices = item.equals(FCN_SUM_) || item.equals(FCN_AVG_) ? this.getNumericFieldNames() : this.getFieldNames();
            if (choices.length == 0) {
                JOptionPane.showMessageDialog(this, ResourceLoader.getQueryText("DBQUERY_MESSAGE_NO_FIELDS") + " " + item + "()", item + "() " + ResourceLoader.getQueryText("DBQUERY_TITLE_ERROR"), 0);
                return;
            }
            Object choice = JOptionPane.showInputDialog(this, ResourceLoader.getQueryText("DBQUERY_TEXT_CHOOSE") + " " + item + "()", item, 3, null, choices, choices[0]);
            if (choice != null) {
                this.addToClause(item + "(" + choice + ")");
            }
        }
    }

    public String getClause() {
        if (this.clause_ == null) {
            return "*";
        }
        return this.clause_.getText();
    }

    public void complete() {
        if (this.changes_) {
            if (this.clause_.getText().equals("*")) {
                this.selectFields_ = this.getFieldNames();
                this.selectItems_ = this.selectFields_;
                this.selectListeners_.firePropertyChange(null, null, null);
            } else {
                StringTokenizer clause = new StringTokenizer(this.clause_.getText(), ",");
                Vector<String> fields = new Vector<String>();
                Vector<String> items = new Vector<String>();
                while (clause.hasMoreTokens()) {
                    String token = clause.nextToken().trim();
                    items.addElement(token);
                    if (token.startsWith("COUNT(") || token.startsWith("SUM(") || token.startsWith("AVG(") || token.startsWith("MIN(") || token.startsWith("MAX(")) continue;
                    fields.addElement(token);
                }
                Object[] newFields = new String[fields.size()];
                fields.copyInto(newFields);
                Object[] newItems = new String[items.size()];
                items.copyInto(newItems);
                boolean different = false;
                if (this.selectItems_.length == newItems.length) {
                    for (int i = 0; i < this.selectItems_.length; ++i) {
                        if (this.selectItems_[i].equals(newItems[i])) continue;
                        different = true;
                        break;
                    }
                } else {
                    different = true;
                }
                if (different) {
                    this.selectItems_ = newItems;
                    this.selectFields_ = newFields;
                    this.selectListeners_.firePropertyChange(null, null, null);
                }
            }
            this.changes_ = false;
        }
    }

    public String[] getSelectedFields() {
        this.init();
        this.update();
        return this.selectFields_;
    }

    public String[] getSelectedItems() {
        this.init();
        this.update();
        return this.selectItems_;
    }

    public void init() {
        if (!this.init_) {
            super.init();
            this.selectFields_ = this.getFieldNames();
            this.selectItems_ = this.selectFields_;
        }
    }

    protected void rowPicked(int index) {
        this.addToClause(this.fieldName(index));
    }

    protected void setupPane() {
        super.setupPane();
        this.init_ = true;
        this.functionList_ = new DoubleClickList(functionChoices);
        this.functionList_.setVisibleRowCount(5);
        this.functionList_.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                SQLQuerySelectPane.this.functionPicked((String)event.getItem());
            }
        });
        Box functionsBox = Box.createHorizontalBox();
        functionsBox.add(new LabelledComponent("DBQUERY_LABEL_FUNCTIONS", this.functionList_));
        functionsBox.add(Box.createHorizontalGlue());
        this.clause_ = new SQLQueryClause(5);
        this.clause_.setText("*");
        this.docListener_ = new DocumentListener_();
        this.clause_.getDocument().addDocumentListener(this.docListener_);
        Box overallBox = Box.createVerticalBox();
        overallBox.add(this.fields_);
        overallBox.add(functionsBox);
        overallBox.add(new LabelledComponent("DBQUERY_LABEL_CLAUSE_SELECT", new ScrollingTextPane(this.clause_)));
        this.setLayout(new BorderLayout());
        this.add("Center", overallBox);
    }

    public void update() {
        if (this.fieldsChanged_) {
            this.changes_ = true;
        }
        super.update();
        this.complete();
        this.docListener_.orderEnabled_ = this.selectItems_.length != 0;
    }

    private class FieldListener2_
    implements PropertyChangeListener {
        private FieldListener2_() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (SQLQuerySelectPane.this.clause_ == null || SQLQuerySelectPane.this.clause_.getText().equals("*")) {
                SQLQuerySelectPane.this.selectFields_ = SQLQuerySelectPane.this.getFieldNames();
                SQLQuerySelectPane.this.selectItems_ = SQLQuerySelectPane.this.selectFields_;
                SQLQuerySelectPane.this.selectListeners_.firePropertyChange(null, null, null);
            }
        }
    }

    private class DocumentListener_
    implements DocumentListener {
        boolean orderEnabled_ = true;

        private DocumentListener_() {
        }

        public void insertUpdate(DocumentEvent e) {
            SQLQuerySelectPane.this.changes_ = true;
            if (!this.orderEnabled_ && (SQLQuerySelectPane.this.selectItems_.length == 0 || SQLQuerySelectPane.this.clause_.getText().equals("*"))) {
                SQLQuerySelectPane.this.complete();
                if (SQLQuerySelectPane.this.selectItems_.length != 0) {
                    SQLQueryBuilderPane cfr_ignored_0 = SQLQuerySelectPane.this.parent_;
                    SQLQuerySelectPane.this.parent_.notebook_.setEnabledAt(6, true);
                    this.orderEnabled_ = true;
                }
            }
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void removeUpdate(DocumentEvent e) {
            SQLQuerySelectPane.this.changes_ = true;
            if (this.orderEnabled_ && SQLQuerySelectPane.this.clause_.getText().equals("")) {
                SQLQuerySelectPane.this.complete();
                if (SQLQuerySelectPane.this.selectItems_.length == 0) {
                    SQLQueryBuilderPane cfr_ignored_0 = SQLQuerySelectPane.this.parent_;
                    SQLQuerySelectPane.this.parent_.notebook_.setEnabledAt(6, false);
                    this.orderEnabled_ = false;
                }
            }
        }
    }
}

