/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileFilter;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.IFSDeleteAction;
import com.ibm.as400.vaccess.IFSDirectoryCreateAction;
import com.ibm.as400.vaccess.IFSDirectoryFilter;
import com.ibm.as400.vaccess.IFSDirectoryPropertiesPane;
import com.ibm.as400.vaccess.IFSFileCreateAction;
import com.ibm.as400.vaccess.IFSRenameAction;
import com.ibm.as400.vaccess.PermissionAction;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VEnumeration;
import com.ibm.as400.vaccess.VIFSConstants;
import com.ibm.as400.vaccess.VIFSFile;
import com.ibm.as400.vaccess.VNode;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectCellEditor;
import com.ibm.as400.vaccess.VObjectCellRenderer;
import com.ibm.as400.vaccess.VObjectEvent;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectHeaderRenderer;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VTableColumn;
import com.ibm.as400.vaccess.VUtilities;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeNode;

public class VIFSDirectory
implements VNode,
VIFSConstants,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    public static final int INCLUDE_FILES = 0;
    public static final int INCLUDE_DIRECTORIES = 1;
    public static final int INCLUDE_BOTH = 2;
    private static String attributesColumnHeader_ = ResourceLoader.getText("COLUMN_ATTRIBUTES");
    private static String description_ = ResourceLoader.getText("IFS_DIRECTORY_DESCRIPTION");
    private static Icon closedIcon16_ = ResourceLoader.getIcon("VIFSDirectory16.gif", description_);
    private static Icon closedIcon32_ = ResourceLoader.getIcon("VIFSDirectory32.gif", description_);
    private static String modifiedColumnHeader_ = ResourceLoader.getText("COLUMN_MODIFIED");
    private static String nameColumnHeader_ = ResourceLoader.getText("COLUMN_NAME");
    private static Icon openIcon16_ = ResourceLoader.getIcon("VIFSDirectoryOpen16.gif", description_);
    private static Icon openIcon32_ = ResourceLoader.getIcon("VIFSDirectoryOpen32.gif", description_);
    private static String sizeColumnHeader_ = ResourceLoader.getText("COLUMN_SIZE");
    private IFSDirectoryFilter actualFilter_ = new IFSDirectoryFilter(2, null);
    private IFSFile directory_ = null;
    private VNode parent_ = null;
    private String pattern_ = "*";
    private static TableColumnModel detailsColumnModel_ = null;
    private transient VAction[] actions_;
    private transient boolean actionsInitialized_;
    transient VNode[] children_;
    private transient boolean childrenLoaded_;
    transient boolean deleted_;
    transient Object detailsChildrenLock_ = new Object();
    transient VObject[] detailsChildren_;
    private transient Date modified_;
    private transient VPropertiesPane propertiesPane_;
    transient ErrorEventSupport errorEventSupport_;
    transient VObjectEventSupport objectEventSupport_;
    transient VObjectListener_ objectListener_;
    transient PropertyChangeSupport propertyChangeSupport_;
    transient VetoableChangeSupport vetoableChangeSupport_;
    transient WorkingEventSupport workingEventSupport_;

    public VIFSDirectory() {
        this.directory_ = new IFSFile();
        this.initializeTransient();
    }

    public VIFSDirectory(IFSFile directory) {
        if (directory == null) {
            throw new NullPointerException("directory");
        }
        this.directory_ = directory;
        this.initializeTransient();
    }

    public VIFSDirectory(VNode parent, IFSFile directory) {
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        if (directory == null) {
            throw new NullPointerException("directory");
        }
        this.parent_ = parent;
        this.directory_ = directory;
        this.initializeTransient();
    }

    public VIFSDirectory(AS400 system, String path) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.directory_ = new IFSFile(system, path);
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport_.addVetoableChangeListener(listener);
    }

    public void addVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.addVObjectListener(listener);
    }

    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    public synchronized Enumeration children() {
        return new VEnumeration(this);
    }

    public VAction[] getActions() {
        this.initializeCreationActions();
        return this.actions_;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int index) {
        if (!this.childrenLoaded_) {
            this.loadChildren();
        }
        if (index < 0 || index >= this.children_.length) {
            return null;
        }
        return this.children_[index];
    }

    public int getChildCount() {
        if (!this.childrenLoaded_) {
            this.loadChildren();
        }
        return this.children_.length;
    }

    public VAction getDefaultAction() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VObject getDetailsChildAt(int index) {
        if (!this.childrenLoaded_) {
            this.loadChildren();
        }
        Object object = this.detailsChildrenLock_;
        synchronized (object) {
            if (index < 0 || index >= this.detailsChildren_.length) {
                return null;
            }
            return this.detailsChildren_[index];
        }
    }

    public int getDetailsChildCount() {
        if (!this.childrenLoaded_) {
            this.loadChildren();
        }
        return this.detailsChildren_.length;
    }

    public TableColumnModel getDetailsColumnModel() {
        return detailsColumnModel_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDetailsIndex(VObject detailsChild) {
        if (!this.childrenLoaded_) {
            this.loadChildren();
        }
        Object object = this.detailsChildrenLock_;
        synchronized (object) {
            for (int i = 0; i < this.detailsChildren_.length; ++i) {
                if (this.detailsChildren_[i] != detailsChild) continue;
                return i;
            }
        }
        return -1;
    }

    int getDirectoryCount() {
        return this.getChildCount();
    }

    int getFileCount() {
        return this.getDetailsChildCount() - this.getChildCount();
    }

    public IFSFileFilter getFilter() {
        return this.actualFilter_.getOtherFilter();
    }

    public Icon getIcon(int size, boolean open) {
        if (size == 32) {
            if (open) {
                return openIcon32_;
            }
            return closedIcon32_;
        }
        if (open) {
            return openIcon16_;
        }
        return closedIcon16_;
    }

    public int getInclude() {
        return this.actualFilter_.getInclude();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndex(TreeNode child) {
        if (!this.childrenLoaded_) {
            this.loadChildren();
        }
        VNode[] vNodeArray = this.children_;
        synchronized (this.children_) {
            for (int i = 0; i < this.children_.length; ++i) {
                if (this.children_[i] != child) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return i;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return -1;
        }
    }

    Date getModified() {
        return this.modified_;
    }

    public String getName() {
        return this.directory_.getName();
    }

    public TreeNode getParent() {
        return this.parent_;
    }

    public String getParentDirectory() {
        return this.directory_.getParent();
    }

    public String getPattern() {
        return this.pattern_;
    }

    public String getPath() {
        return this.directory_.getPath();
    }

    public VPropertiesPane getPropertiesPane() {
        return this.propertiesPane_;
    }

    public Object getPropertyValue(Object propertyIdentifier) {
        if (propertyIdentifier == NAME_PROPERTY) {
            return this;
        }
        if (propertyIdentifier == DESCRIPTION_PROPERTY) {
            return description_;
        }
        if (propertyIdentifier == SIZE_PROPERTY) {
            return "";
        }
        if (propertyIdentifier == MODIFIED_PROPERTY) {
            return this.modified_;
        }
        if (propertyIdentifier == ATTRIBUTES_PROPERTY) {
            return "";
        }
        return null;
    }

    public AS400 getSystem() {
        return this.directory_.getSystem();
    }

    public String getText() {
        String text = this.directory_.getName();
        if (text.length() == 0) {
            text = "/";
        }
        return text;
    }

    private void initializeCreationActions() {
        if (this.actionsInitialized_) {
            return;
        }
        String pathPrefix = this.directory_.getPath().toUpperCase();
        if (pathPrefix.startsWith("/QSYS.LIB/") || pathPrefix.startsWith("/QDLS/")) {
            for (int i = 0; i < 2; ++i) {
                this.actions_[i].setEnabled(false);
            }
        }
        this.actionsInitialized_ = true;
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.objectListener_ = new VObjectListener_();
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.directory_.addPropertyChangeListener(this.propertyChangeSupport_);
        this.directory_.addVetoableChangeListener(this.vetoableChangeSupport_);
        this.actions_ = new VAction[5];
        this.actions_[0] = new IFSFileCreateAction(this, this.directory_);
        this.actions_[1] = new IFSDirectoryCreateAction(this, this.directory_);
        this.actions_[2] = new IFSRenameAction(this, this.directory_);
        this.actions_[3] = new IFSDeleteAction(this, this.directory_);
        this.actions_[4] = new PermissionAction(this.directory_);
        this.actionsInitialized_ = false;
        for (int i = 0; i < this.actions_.length; ++i) {
            this.actions_[i].addErrorListener(this.errorEventSupport_);
            this.actions_[i].addVObjectListener(this.objectListener_);
            this.actions_[i].addWorkingListener(this.workingEventSupport_);
        }
        this.propertiesPane_ = new IFSDirectoryPropertiesPane(this);
        this.propertiesPane_.addErrorListener(this.errorEventSupport_);
        this.propertiesPane_.addVObjectListener(this.objectListener_);
        this.propertiesPane_.addWorkingListener(this.workingEventSupport_);
        this.children_ = new VNode[0];
        this.detailsChildren_ = new VObject[0];
        this.modified_ = new Date();
        this.childrenLoaded_ = true;
        this.deleted_ = false;
    }

    public boolean isLeaf() {
        if (this.childrenLoaded_) {
            return this.getChildCount() == 0;
        }
        return false;
    }

    public boolean isSortable() {
        return true;
    }

    public void load() {
        this.workingEventSupport_.fireStartWorking();
        this.initializeCreationActions();
        try {
            this.modified_ = new Date(this.directory_.lastModified());
        }
        catch (Exception e) {
            this.modified_ = new Date(0L);
            this.errorEventSupport_.fireError(e);
        }
        this.childrenLoaded_ = false;
        this.workingEventSupport_.fireStopWorking();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadChildren() {
        block19: {
            this.workingEventSupport_.fireStartWorking();
            try {
                Hashtable<String, VObject> cache = new Hashtable<String, VObject>();
                for (int i = 0; i < this.detailsChildren_.length; ++i) {
                    cache.put(this.detailsChildren_[i].getText(), this.detailsChildren_[i]);
                }
                if (Trace.isTraceOn()) {
                    Trace.log(3, "Loading IFS file list [" + this.directory_.getName() + "].");
                }
                Vector<VObject> directories = null;
                Object object = this.detailsChildrenLock_;
                synchronized (object) {
                    if (this.directory_.getPath().length() > 0) {
                        IFSFile[] files = this.directory_.listFiles(this.actualFilter_, this.pattern_);
                        if (files == null) {
                            Trace.log(1, "File list returned as null");
                            if (this.directory_.exists()) {
                                files = new IFSFile[]{};
                            } else {
                                throw new IOException(ResourceLoader.getText("EXC_FILE_NOT_FOUND"));
                            }
                        }
                        int fileCount = files.length;
                        this.detailsChildren_ = new VObject[fileCount];
                        directories = new Vector<VObject>(fileCount);
                        for (int i = 0; i < fileCount; ++i) {
                            VObject child = null;
                            if (cache.containsKey(files[i].getName())) {
                                child = (VObject)cache.remove(files[i].getName());
                            } else {
                                IFSFile file = files[i];
                                child = file.isDirectory() ? new VIFSDirectory(this, file) : new VIFSFile(file);
                                child.addErrorListener(this.errorEventSupport_);
                                child.addVObjectListener(this.objectEventSupport_);
                                child.addVObjectListener(this.objectListener_);
                                child.addWorkingListener(this.workingEventSupport_);
                            }
                            child.load();
                            this.detailsChildren_[i] = child;
                            if (!(child instanceof VIFSDirectory) || directories.contains(child)) continue;
                            directories.addElement(child);
                        }
                    }
                }
                if (directories != null) {
                    object = this;
                    synchronized (object) {
                        this.children_ = new VNode[directories.size()];
                        directories.copyInto(this.children_);
                    }
                }
                Enumeration list = cache.elements();
                while (list.hasMoreElements()) {
                    VObject child = (VObject)list.nextElement();
                    child.removeErrorListener(this.errorEventSupport_);
                    child.removeVObjectListener(this.objectEventSupport_);
                    child.removeVObjectListener(this.objectListener_);
                    child.removeWorkingListener(this.workingEventSupport_);
                }
                this.childrenLoaded_ = true;
            }
            catch (Exception e) {
                this.children_ = new VNode[0];
                this.detailsChildren_ = new VObject[0];
                this.childrenLoaded_ = true;
                if (this.deleted_) break block19;
                this.errorEventSupport_.fireError(e);
            }
        }
        this.workingEventSupport_.fireStopWorking();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport_.removePropertyChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport_.removeVetoableChangeListener(listener);
    }

    public void removeVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.removeVObjectListener(listener);
    }

    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }

    public void setFilter(IFSFileFilter filter) throws PropertyVetoException {
        if (filter == null) {
            throw new NullPointerException("filter");
        }
        IFSFileFilter oldValue = this.actualFilter_.getOtherFilter();
        IFSFileFilter newValue = filter;
        this.vetoableChangeSupport_.fireVetoableChange("filter", oldValue, newValue);
        if (oldValue != newValue) {
            this.actualFilter_.setOtherFilter(newValue);
        }
        this.propertyChangeSupport_.firePropertyChange("filter", oldValue, newValue);
    }

    public void setInclude(int include) throws PropertyVetoException {
        Integer oldValue = new Integer(this.actualFilter_.getInclude());
        Integer newValue = new Integer(include);
        this.vetoableChangeSupport_.fireVetoableChange("includeFiles", oldValue, newValue);
        if (!oldValue.equals(newValue)) {
            this.actualFilter_.setInclude(include);
        }
        this.propertyChangeSupport_.firePropertyChange("includeFiles", oldValue, newValue);
    }

    public void setPath(String path) throws PropertyVetoException {
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.directory_.setPath(path);
    }

    public void setPattern(String pattern) throws PropertyVetoException {
        if (pattern == null) {
            throw new NullPointerException("pattern");
        }
        String oldValue = this.pattern_;
        String newValue = pattern;
        this.vetoableChangeSupport_.fireVetoableChange("pattern", oldValue, newValue);
        if (!oldValue.equals(newValue)) {
            this.pattern_ = newValue;
        }
        this.propertyChangeSupport_.firePropertyChange("pattern", oldValue, newValue);
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.directory_.setSystem(system);
    }

    public synchronized void sortDetailsChildren(Object[] propertyIdentifiers, boolean[] orders) {
        if (propertyIdentifiers == null) {
            throw new NullPointerException("propertyIdentifiers");
        }
        if (orders == null) {
            throw new NullPointerException("orders");
        }
        VUtilities.sort(this.detailsChildren_, propertyIdentifiers, orders);
    }

    public String toString() {
        return this.directory_.getName();
    }

    static {
        detailsColumnModel_ = new DefaultTableColumnModel();
        int columnIndex = 0;
        VTableColumn nameColumn = new VTableColumn(columnIndex++, NAME_PROPERTY);
        nameColumn.setCellEditor(new VObjectCellEditor());
        nameColumn.setCellRenderer(new VObjectCellRenderer());
        nameColumn.setHeaderRenderer(new VObjectHeaderRenderer());
        nameColumn.setHeaderValue(nameColumnHeader_);
        nameColumn.setPreferredCharWidth(25);
        detailsColumnModel_.addColumn(nameColumn);
        VTableColumn sizeColumn = new VTableColumn(columnIndex++, SIZE_PROPERTY);
        sizeColumn.setCellRenderer(new VObjectCellRenderer(4));
        sizeColumn.setHeaderRenderer(new VObjectHeaderRenderer(4));
        sizeColumn.setHeaderValue(sizeColumnHeader_);
        sizeColumn.setPreferredCharWidth(8);
        detailsColumnModel_.addColumn(sizeColumn);
        VTableColumn modifiedColumn = new VTableColumn(columnIndex++, MODIFIED_PROPERTY);
        modifiedColumn.setCellRenderer(new VObjectCellRenderer());
        modifiedColumn.setHeaderRenderer(new VObjectHeaderRenderer());
        modifiedColumn.setHeaderValue(modifiedColumnHeader_);
        modifiedColumn.setPreferredCharWidth(20);
        detailsColumnModel_.addColumn(modifiedColumn);
        VTableColumn attributesColumn = new VTableColumn(columnIndex++, ATTRIBUTES_PROPERTY);
        attributesColumn.setCellRenderer(new VObjectCellRenderer());
        attributesColumn.setHeaderRenderer(new VObjectHeaderRenderer());
        attributesColumn.setHeaderValue(attributesColumnHeader_);
        attributesColumn.setPreferredCharWidth(10);
        detailsColumnModel_.addColumn(attributesColumn);
    }

    private class VObjectListener_
    implements VObjectListener,
    Serializable {
        private VObjectListener_() {
        }

        public void objectChanged(VObjectEvent event) {
            VIFSDirectory.this.objectEventSupport_.objectChanged(event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void objectCreated(VObjectEvent event) {
            VObject object = event.getObject();
            VNode parent = event.getParent();
            if (parent == VIFSDirectory.this) {
                VNode[] vNodeArray = VIFSDirectory.this.detailsChildrenLock_;
                // MONITORENTER : VIFSDirectory.this.detailsChildrenLock_
                VObject[] oldDetailsChildren = VIFSDirectory.this.detailsChildren_;
                int count = VIFSDirectory.this.detailsChildren_.length;
                VIFSDirectory.this.detailsChildren_ = new VObject[count + 1];
                System.arraycopy(oldDetailsChildren, 0, VIFSDirectory.this.detailsChildren_, 0, count);
                VIFSDirectory.this.detailsChildren_[count] = object;
                // MONITOREXIT : vNodeArray
                if (object instanceof VIFSDirectory) {
                    vNodeArray = VIFSDirectory.this.children_;
                    // MONITORENTER : VIFSDirectory.this.children_
                    VNode[] oldChildren = VIFSDirectory.this.children_;
                    int countX = VIFSDirectory.this.children_.length;
                    VIFSDirectory.this.children_ = new VNode[countX + 1];
                    System.arraycopy(oldChildren, 0, VIFSDirectory.this.children_, 0, countX);
                    VIFSDirectory.this.children_[countX] = (VIFSDirectory)object;
                    // MONITOREXIT : vNodeArray
                }
            }
            object.addErrorListener(VIFSDirectory.this.errorEventSupport_);
            object.addVObjectListener(VIFSDirectory.this.objectListener_);
            object.addVObjectListener(VIFSDirectory.this.objectEventSupport_);
            object.addWorkingListener(VIFSDirectory.this.workingEventSupport_);
            VIFSDirectory.this.objectEventSupport_.objectCreated(event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void objectDeleted(VObjectEvent event) {
            int count;
            VNode[] vNodeArray;
            VObject object = event.getObject();
            if (object == VIFSDirectory.this) {
                VIFSDirectory.this.deleted_ = true;
                VIFSDirectory.this.objectEventSupport_.objectDeleted(event);
                return;
            }
            int index = VIFSDirectory.this.getDetailsIndex(object);
            if (index >= 0) {
                vNodeArray = VIFSDirectory.this.detailsChildrenLock_;
                // MONITORENTER : VIFSDirectory.this.detailsChildrenLock_
                VObject[] oldDetailsChildren = VIFSDirectory.this.detailsChildren_;
                count = VIFSDirectory.this.detailsChildren_.length;
                VIFSDirectory.this.detailsChildren_ = new VObject[count - 1];
                System.arraycopy(oldDetailsChildren, 0, VIFSDirectory.this.detailsChildren_, 0, index);
                System.arraycopy(oldDetailsChildren, index + 1, VIFSDirectory.this.detailsChildren_, index, count - index - 1);
                // MONITOREXIT : vNodeArray
            }
            if (object instanceof VIFSDirectory && (index = VIFSDirectory.this.getIndex((VIFSDirectory)object)) >= 0) {
                vNodeArray = VIFSDirectory.this.children_;
                // MONITORENTER : VIFSDirectory.this.children_
                VNode[] oldChildren = VIFSDirectory.this.children_;
                count = VIFSDirectory.this.children_.length;
                VIFSDirectory.this.children_ = new VNode[count - 1];
                System.arraycopy(oldChildren, 0, VIFSDirectory.this.children_, 0, index);
                System.arraycopy(oldChildren, index + 1, VIFSDirectory.this.children_, 0, count - index - 1);
                // MONITOREXIT : vNodeArray
            }
            object.removeErrorListener(VIFSDirectory.this.errorEventSupport_);
            object.removeVObjectListener(VIFSDirectory.this.objectEventSupport_);
            object.removeVObjectListener(VIFSDirectory.this.objectListener_);
            object.removeWorkingListener(VIFSDirectory.this.workingEventSupport_);
        }
    }
}

