/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400Message;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VEnumeration;
import com.ibm.as400.vaccess.VMessage;
import com.ibm.as400.vaccess.VNode;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectCellRenderer;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectHeaderRenderer;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VTableColumn;
import com.ibm.as400.vaccess.VUtilities;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeNode;

public class VMessageList
implements VNode,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static String description_ = ResourceLoader.getText("MESSAGE_LIST_DESCRIPTION");
    private static Icon icon16_ = ResourceLoader.getIcon("VMessageList16.gif", description_);
    private static Icon icon32_ = ResourceLoader.getIcon("VMessageList32.gif", description_);
    private static String nameColumnHeader_ = ResourceLoader.getText("MESSAGE_ID");
    private static String textColumnHeader_ = ResourceLoader.getText("MESSAGE_TEXT");
    private static String typeColumnHeader_ = ResourceLoader.getText("MESSAGE_TYPE");
    private static String severityColumnHeader_ = ResourceLoader.getText("MESSAGE_SEVERITY");
    private AS400Message[] messageList_ = new AS400Message[0];
    private VNode parent_ = null;
    private static TableColumnModel detailsColumnModel_ = null;
    private transient VObject[] detailsChildren_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient VObjectEventSupport objectEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    private transient WorkingEventSupport workingEventSupport_;

    public VMessageList() {
        this.initializeTransient();
    }

    public VMessageList(AS400Message[] messageList) {
        if (messageList == null) {
            throw new NullPointerException("messageList");
        }
        this.messageList_ = messageList;
        this.initializeTransient();
    }

    public VMessageList(VNode parent, AS400Message[] messageList) {
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        if (messageList == null) {
            throw new NullPointerException("messageList");
        }
        this.parent_ = parent;
        this.messageList_ = messageList;
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport_.addVetoableChangeListener(listener);
    }

    public void addVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.addVObjectListener(listener);
    }

    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    public Enumeration children() {
        return new VEnumeration(this);
    }

    public VAction[] getActions() {
        return null;
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public TreeNode getChildAt(int index) {
        return null;
    }

    public int getChildCount() {
        return 0;
    }

    public VAction getDefaultAction() {
        return null;
    }

    public synchronized VObject getDetailsChildAt(int index) {
        if (index < 0 || index >= this.detailsChildren_.length) {
            return null;
        }
        return this.detailsChildren_[index];
    }

    public synchronized int getDetailsChildCount() {
        return this.detailsChildren_.length;
    }

    public synchronized int getDetailsIndex(VObject detailsChild) {
        for (int i = 0; i < this.detailsChildren_.length; ++i) {
            if (this.detailsChildren_[i] != detailsChild) continue;
            return i;
        }
        return -1;
    }

    public TableColumnModel getDetailsColumnModel() {
        return detailsColumnModel_;
    }

    public Icon getIcon(int size, boolean open) {
        if (size == 32) {
            return icon32_;
        }
        return icon16_;
    }

    public synchronized int getIndex(TreeNode child) {
        return -1;
    }

    public AS400Message[] getMessageList() {
        return this.messageList_;
    }

    public TreeNode getParent() {
        return this.parent_;
    }

    public VPropertiesPane getPropertiesPane() {
        return null;
    }

    public Object getPropertyValue(Object propertyIdentifier) {
        if (propertyIdentifier == NAME_PROPERTY) {
            return this;
        }
        if (propertyIdentifier == DESCRIPTION_PROPERTY) {
            return description_;
        }
        return null;
    }

    public String getText() {
        return description_;
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.detailsChildren_ = new VObject[0];
    }

    public boolean isLeaf() {
        return true;
    }

    public boolean isSortable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        this.workingEventSupport_.fireStartWorking();
        VMessageList vMessageList = this;
        synchronized (vMessageList) {
            int i;
            for (i = 0; i < this.detailsChildren_.length; ++i) {
                this.detailsChildren_[i].removeErrorListener(this.errorEventSupport_);
                this.detailsChildren_[i].removeVObjectListener(this.objectEventSupport_);
                this.detailsChildren_[i].removeWorkingListener(this.workingEventSupport_);
            }
            this.detailsChildren_ = new VObject[this.messageList_.length];
            for (i = 0; i < this.messageList_.length; ++i) {
                this.detailsChildren_[i] = new VMessage(this.messageList_[i]);
                this.detailsChildren_[i].addErrorListener(this.errorEventSupport_);
                this.detailsChildren_[i].addVObjectListener(this.objectEventSupport_);
                this.detailsChildren_[i].addWorkingListener(this.workingEventSupport_);
            }
        }
        this.workingEventSupport_.fireStopWorking();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport_.removePropertyChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport_.removeVetoableChangeListener(listener);
    }

    public void removeVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.removeVObjectListener(listener);
    }

    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }

    public void setMessageList(AS400Message[] messageList) throws PropertyVetoException {
        if (messageList == null) {
            throw new NullPointerException("messageList");
        }
        AS400Message[] oldValue = this.messageList_;
        AS400Message[] newValue = messageList;
        this.vetoableChangeSupport_.fireVetoableChange("messageList", oldValue, newValue);
        if (oldValue != newValue) {
            this.messageList_ = messageList;
        }
        this.propertyChangeSupport_.firePropertyChange("messageList", oldValue, newValue);
    }

    public synchronized void sortDetailsChildren(Object[] propertyIdentifiers, boolean[] orders) {
        if (propertyIdentifiers == null) {
            throw new NullPointerException("propertyIdentifiers");
        }
        if (orders == null) {
            throw new NullPointerException("orders");
        }
        VUtilities.sort(this.detailsChildren_, propertyIdentifiers, orders);
    }

    public String toString() {
        return description_;
    }

    static {
        detailsColumnModel_ = new DefaultTableColumnModel();
        int columnIndex = 0;
        VTableColumn nameColumn = new VTableColumn(columnIndex++, VMessage.NAME_PROPERTY);
        nameColumn.setCellRenderer(new VObjectCellRenderer());
        nameColumn.setHeaderRenderer(new VObjectHeaderRenderer());
        nameColumn.setHeaderValue(nameColumnHeader_);
        nameColumn.setPreferredCharWidth(10);
        detailsColumnModel_.addColumn(nameColumn);
        VTableColumn textColumn = new VTableColumn(columnIndex++, VMessage.TEXT_PROPERTY);
        textColumn.setCellRenderer(new VObjectCellRenderer());
        textColumn.setHeaderRenderer(new VObjectHeaderRenderer());
        textColumn.setHeaderValue(textColumnHeader_);
        textColumn.setPreferredCharWidth(80);
        detailsColumnModel_.addColumn(textColumn);
        VTableColumn severityColumn = new VTableColumn(columnIndex++, VMessage.SEVERITY_PROPERTY);
        severityColumn.setCellRenderer(new VObjectCellRenderer(4));
        severityColumn.setHeaderRenderer(new VObjectHeaderRenderer(4));
        severityColumn.setHeaderValue(severityColumnHeader_);
        severityColumn.setPreferredCharWidth(8);
        detailsColumnModel_.addColumn(severityColumn);
        VTableColumn typeColumn = new VTableColumn(columnIndex++, VMessage.TYPE_PROPERTY);
        typeColumn.setCellRenderer(new VObjectCellRenderer());
        typeColumn.setHeaderRenderer(new VObjectHeaderRenderer());
        typeColumn.setHeaderValue(typeColumnHeader_);
        typeColumn.setPreferredCharWidth(20);
        detailsColumnModel_.addColumn(typeColumn);
    }
}

