/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Supplier;
import edu.uci.ics.jung.algorithms.layout.BalloonLayout;
import edu.uci.ics.jung.algorithms.layout.TreeLayout;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.graph.DelegateForest;
import edu.uci.ics.jung.graph.DelegateTree;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.Forest;
import edu.uci.ics.jung.graph.Tree;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalLensGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.layout.LayoutTransition;
import edu.uci.ics.jung.visualization.transform.LensSupport;
import edu.uci.ics.jung.visualization.transform.LensTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformerDecorator;
import edu.uci.ics.jung.visualization.transform.shape.HyperbolicShapeTransformer;
import edu.uci.ics.jung.visualization.transform.shape.ViewLensSupport;
import edu.uci.ics.jung.visualization.util.Animator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;

public class BalloonLayoutDemo
extends JApplet {
    Forest<String, Integer> graph;
    Supplier<DirectedGraph<String, Integer>> graphFactory = new Supplier<DirectedGraph<String, Integer>>(){

        public DirectedGraph<String, Integer> get() {
            return new DirectedSparseMultigraph();
        }
    };
    Supplier<Tree<String, Integer>> treeFactory = new Supplier<Tree<String, Integer>>(){

        public Tree<String, Integer> get() {
            return new DelegateTree(BalloonLayoutDemo.this.graphFactory);
        }
    };
    Supplier<Integer> edgeFactory = new Supplier<Integer>(){
        int i = 0;

        public Integer get() {
            return this.i++;
        }
    };
    Supplier<String> vertexFactory = new Supplier<String>(){
        int i = 0;

        public String get() {
            return "V" + this.i++;
        }
    };
    VisualizationViewer<String, Integer> vv;
    VisualizationServer.Paintable rings;
    String root;
    TreeLayout<String, Integer> layout;
    BalloonLayout<String, Integer> radialLayout;
    LensSupport hyperbolicViewSupport;

    public BalloonLayoutDemo() {
        this.graph = new DelegateForest();
        this.createTree();
        this.layout = new TreeLayout(this.graph);
        this.radialLayout = new BalloonLayout(this.graph);
        this.radialLayout.setSize(new Dimension(900, 900));
        this.vv = new VisualizationViewer(this.layout, new Dimension(600, 600));
        this.vv.setBackground(Color.white);
        this.vv.getRenderContext().setEdgeShapeTransformer((Function)EdgeShape.quadCurve(this.graph));
        this.vv.getRenderContext().setVertexLabelTransformer((Function)new ToStringLabeller());
        this.vv.setVertexToolTipTransformer((Function)new ToStringLabeller());
        this.vv.getRenderContext().setArrowFillPaintTransformer(Functions.constant((Object)Color.lightGray));
        this.rings = new Rings(this.radialLayout);
        Container content = this.getContentPane();
        GraphZoomScrollPane panel = new GraphZoomScrollPane(this.vv);
        content.add((Component)panel);
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)graphMouse);
        this.vv.addKeyListener(graphMouse.getModeKeyListener());
        this.hyperbolicViewSupport = new ViewLensSupport(this.vv, (LensTransformer)new HyperbolicShapeTransformer(this.vv, this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW)), (ModalGraphMouse)new ModalLensGraphMouse());
        graphMouse.addItemListener(this.hyperbolicViewSupport.getGraphMouse().getModeListener());
        JComboBox modeBox = graphMouse.getModeComboBox();
        modeBox.addItemListener(graphMouse.getModeListener());
        graphMouse.setMode(ModalGraphMouse.Mode.TRANSFORMING);
        CrossoverScalingControl scaler = new CrossoverScalingControl();
        this.vv.scaleToLayout((ScalingControl)scaler);
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(BalloonLayoutDemo.this.vv, 1.1f, BalloonLayoutDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(BalloonLayoutDemo.this.vv, 0.9090909f, BalloonLayoutDemo.this.vv.getCenter());
            }
        });
        JToggleButton radial = new JToggleButton("Balloon");
        radial.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    LayoutTransition lt = new LayoutTransition(BalloonLayoutDemo.this.vv, BalloonLayoutDemo.this.layout, BalloonLayoutDemo.this.radialLayout);
                    Animator animator = new Animator((IterativeContext)lt);
                    animator.start();
                    BalloonLayoutDemo.this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT).setToIdentity();
                    BalloonLayoutDemo.this.vv.addPreRenderPaintable(BalloonLayoutDemo.this.rings);
                } else {
                    LayoutTransition lt = new LayoutTransition(BalloonLayoutDemo.this.vv, BalloonLayoutDemo.this.radialLayout, BalloonLayoutDemo.this.layout);
                    Animator animator = new Animator((IterativeContext)lt);
                    animator.start();
                    BalloonLayoutDemo.this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT).setToIdentity();
                    BalloonLayoutDemo.this.vv.removePreRenderPaintable(BalloonLayoutDemo.this.rings);
                }
                BalloonLayoutDemo.this.vv.repaint();
            }
        });
        JRadioButton hyperView = new JRadioButton("Hyperbolic View");
        hyperView.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                BalloonLayoutDemo.this.hyperbolicViewSupport.activate(e.getStateChange() == 1);
            }
        });
        JPanel scaleGrid = new JPanel(new GridLayout(1, 0));
        scaleGrid.setBorder(BorderFactory.createTitledBorder("Zoom"));
        JPanel controls = new JPanel();
        scaleGrid.add(plus);
        scaleGrid.add(minus);
        controls.add(radial);
        controls.add(scaleGrid);
        controls.add(modeBox);
        controls.add(hyperView);
        content.add((Component)controls, "South");
    }

    private void createTree() {
        this.graph.addVertex((Object)"A0");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"A0", (Object)"B0");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"A0", (Object)"B1");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"A0", (Object)"B2");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"B0", (Object)"C0");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"B0", (Object)"C1");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"B0", (Object)"C2");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"B0", (Object)"C3");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"C2", (Object)"H0");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"C2", (Object)"H1");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"B1", (Object)"D0");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"B1", (Object)"D1");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"B1", (Object)"D2");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"B2", (Object)"E0");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"B2", (Object)"E1");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"B2", (Object)"E2");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"D0", (Object)"F0");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"D0", (Object)"F1");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"D0", (Object)"F2");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"D1", (Object)"G0");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"D1", (Object)"G1");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"D1", (Object)"G2");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"D1", (Object)"G3");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"D1", (Object)"G4");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"D1", (Object)"G5");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"D1", (Object)"G6");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"D1", (Object)"G7");
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        Container content = frame.getContentPane();
        frame.setDefaultCloseOperation(3);
        content.add(new BalloonLayoutDemo());
        frame.pack();
        frame.setVisible(true);
    }

    class Rings
    implements VisualizationServer.Paintable {
        BalloonLayout<String, Integer> layout;

        public Rings(BalloonLayout<String, Integer> layout) {
            this.layout = layout;
        }

        public void paint(Graphics g) {
            g.setColor(Color.gray);
            Graphics2D g2d = (Graphics2D)g;
            Ellipse2D.Double ellipse = new Ellipse2D.Double();
            for (String v : this.layout.getGraph().getVertices()) {
                Double radius = (Double)this.layout.getRadii().get(v);
                if (radius == null) continue;
                Point2D p = this.layout.apply((Object)v);
                ((RectangularShape)ellipse).setFrame(-radius.doubleValue(), -radius.doubleValue(), 2.0 * radius, 2.0 * radius);
                AffineTransform at = AffineTransform.getTranslateInstance(p.getX(), p.getY());
                Shape shape = at.createTransformedShape(ellipse);
                MutableTransformer viewTransformer = BalloonLayoutDemo.this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW);
                shape = viewTransformer instanceof MutableTransformerDecorator ? BalloonLayoutDemo.this.vv.getRenderContext().getMultiLayerTransformer().transform(shape) : BalloonLayoutDemo.this.vv.getRenderContext().getMultiLayerTransformer().transform(Layer.LAYOUT, shape);
                g2d.draw(shape);
            }
        }

        public boolean useTransform() {
            return true;
        }
    }
}

