/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.LayeredIcon;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.decorators.EllipseVertexShapeTransformer;
import edu.uci.ics.jung.visualization.decorators.PickableEdgePaintTransformer;
import edu.uci.ics.jung.visualization.decorators.PickableVertexPaintTransformer;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.decorators.VertexIconShapeTransformer;
import edu.uci.ics.jung.visualization.picking.PickedInfo;
import edu.uci.ics.jung.visualization.picking.PickedState;
import edu.uci.ics.jung.visualization.renderers.Checkmark;
import edu.uci.ics.jung.visualization.renderers.DefaultEdgeLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.DefaultVertexLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.EdgeLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.VertexLabelRenderer;
import edu.uci.ics.jung.visualization.transform.LayoutLensSupport;
import edu.uci.ics.jung.visualization.transform.LensSupport;
import edu.uci.ics.jung.visualization.transform.shape.MagnifyImageLensSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class DemoLensVertexImageShaperDemo
extends JApplet {
    private static final long serialVersionUID = 5432239991020505763L;
    DirectedSparseGraph<Number, Number> graph;
    VisualizationViewer<Number, Number> vv;
    String[] iconNames = new String[]{"sample2"};
    LensSupport viewSupport;
    LensSupport modelSupport;
    LensSupport magnifyLayoutSupport;
    LensSupport magnifyViewSupport;

    public DemoLensVertexImageShaperDemo() {
        this.graph = new DirectedSparseGraph();
        Number[] vertices = this.createVertices(1);
        HashMap<Number, String> map = new HashMap<Number, String>();
        for (int i = 0; i < vertices.length; ++i) {
            map.put(vertices[i], this.iconNames[i % this.iconNames.length]);
        }
        HashMap<Number, LayeredIcon> iconMap = new HashMap<Number, LayeredIcon>();
        for (int i = 0; i < vertices.length; ++i) {
            String name = "/images/topic" + this.iconNames[i] + ".gif";
            try {
                LayeredIcon icon = new LayeredIcon(new ImageIcon(DemoLensVertexImageShaperDemo.class.getResource(name)).getImage());
                iconMap.put(vertices[i], icon);
                continue;
            }
            catch (Exception ex) {
                System.err.println("You need slashdoticons.jar in your classpath to see the image " + name);
            }
        }
        this.createEdges(vertices);
        FRLayout layout = new FRLayout(this.graph);
        layout.setMaxIterations(100);
        this.vv = new VisualizationViewer((Layout)layout, new Dimension(600, 600));
        PickableVertexPaintTransformer vpf = new PickableVertexPaintTransformer((PickedInfo)this.vv.getPickedVertexState(), (Paint)Color.white, (Paint)Color.yellow);
        this.vv.getRenderContext().setVertexFillPaintTransformer((Function)vpf);
        this.vv.getRenderContext().setEdgeDrawPaintTransformer((Function)new PickableEdgePaintTransformer((PickedInfo)this.vv.getPickedEdgeState(), (Paint)Color.black, (Paint)Color.cyan));
        this.vv.setBackground(Color.white);
        VertexStringerImpl vertexStringerImpl = new VertexStringerImpl(map);
        this.vv.getRenderContext().setVertexLabelTransformer(vertexStringerImpl);
        this.vv.getRenderContext().setVertexLabelRenderer((VertexLabelRenderer)new DefaultVertexLabelRenderer(Color.cyan));
        this.vv.getRenderContext().setEdgeLabelRenderer((EdgeLabelRenderer)new DefaultEdgeLabelRenderer(Color.cyan));
        VertexIconShapeTransformer vertexImageShapeFunction = new VertexIconShapeTransformer((Function)new EllipseVertexShapeTransformer());
        vertexImageShapeFunction.setIconMap(iconMap);
        Function vertexIconFunction = Functions.forMap(iconMap);
        this.vv.getRenderContext().setVertexShapeTransformer((Function)vertexImageShapeFunction);
        this.vv.getRenderContext().setVertexIconTransformer(vertexIconFunction);
        PickedState ps = this.vv.getPickedVertexState();
        ps.addItemListener((ItemListener)new PickWithIconListener((Function<Number, Icon>)vertexIconFunction));
        this.vv.addPostRenderPaintable(new VisualizationServer.Paintable(){
            int x;
            int y;
            Font font;
            FontMetrics metrics;
            int swidth;
            int sheight;
            String str = "Thank You, slashdot.org, for the images!";

            public void paint(Graphics g) {
                Dimension d = DemoLensVertexImageShaperDemo.this.vv.getSize();
                if (this.font == null) {
                    this.font = new Font(g.getFont().getName(), 1, 20);
                    this.metrics = g.getFontMetrics(this.font);
                    this.swidth = this.metrics.stringWidth(this.str);
                    this.sheight = this.metrics.getMaxAscent() + this.metrics.getMaxDescent();
                    this.x = (d.width - this.swidth) / 2;
                    this.y = (int)((double)d.height - (double)this.sheight * 1.5);
                }
                g.setFont(this.font);
                Color oldColor = g.getColor();
                g.setColor(Color.lightGray);
                g.drawString(this.str, this.x, this.y);
                g.setColor(oldColor);
            }

            public boolean useTransform() {
                return false;
            }
        });
        this.vv.setVertexToolTipTransformer((Function)new ToStringLabeller());
        Container content = this.getContentPane();
        GraphZoomScrollPane panel = new GraphZoomScrollPane(this.vv);
        content.add((Component)panel);
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)graphMouse);
        CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(DemoLensVertexImageShaperDemo.this.vv, 1.1f, DemoLensVertexImageShaperDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(DemoLensVertexImageShaperDemo.this.vv, 0.9090909f, DemoLensVertexImageShaperDemo.this.vv.getCenter());
            }
        });
        JComboBox modeBox = graphMouse.getModeComboBox();
        JPanel modePanel = new JPanel();
        modePanel.setBorder(BorderFactory.createTitledBorder("Mouse Mode"));
        modePanel.add(modeBox);
        JPanel scaleGrid = new JPanel(new GridLayout(1, 0));
        scaleGrid.setBorder(BorderFactory.createTitledBorder("Zoom"));
        JPanel controls = new JPanel();
        scaleGrid.add(plus);
        scaleGrid.add(minus);
        controls.add(scaleGrid);
        controls.add(modePanel);
        content.add((Component)controls, "South");
        this.viewSupport = new MagnifyImageLensSupport(this.vv);
        this.modelSupport = new LayoutLensSupport(this.vv);
        graphMouse.addItemListener(this.modelSupport.getGraphMouse().getModeListener());
        graphMouse.addItemListener(this.viewSupport.getGraphMouse().getModeListener());
        ButtonGroup radio = new ButtonGroup();
        JRadioButton none = new JRadioButton("None");
        none.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (DemoLensVertexImageShaperDemo.this.viewSupport != null) {
                    DemoLensVertexImageShaperDemo.this.viewSupport.deactivate();
                }
                if (DemoLensVertexImageShaperDemo.this.modelSupport != null) {
                    DemoLensVertexImageShaperDemo.this.modelSupport.deactivate();
                }
            }
        });
        none.setSelected(true);
        JRadioButton hyperView = new JRadioButton("View");
        hyperView.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DemoLensVertexImageShaperDemo.this.viewSupport.activate(e.getStateChange() == 1);
            }
        });
        JRadioButton hyperModel = new JRadioButton("Layout");
        hyperModel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DemoLensVertexImageShaperDemo.this.modelSupport.activate(e.getStateChange() == 1);
            }
        });
        radio.add(none);
        radio.add(hyperView);
        radio.add(hyperModel);
        JMenuBar menubar = new JMenuBar();
        JMenu modeMenu = graphMouse.getModeMenu();
        menubar.add(modeMenu);
        JPanel lensPanel = new JPanel(new GridLayout(2, 0));
        lensPanel.setBorder(BorderFactory.createTitledBorder("Lens"));
        lensPanel.add(none);
        lensPanel.add(hyperView);
        lensPanel.add(hyperModel);
        controls.add(lensPanel);
    }

    private Number[] createVertices(int count) {
        Number[] v = new Number[count];
        for (int i = 0; i < count; ++i) {
            v[i] = new Integer(i);
            this.graph.addVertex((Object)v[i]);
        }
        return v;
    }

    void createEdges(Number[] v) {
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        Container content = frame.getContentPane();
        frame.setDefaultCloseOperation(3);
        content.add(new DemoLensVertexImageShaperDemo());
        frame.pack();
        frame.setVisible(true);
    }

    public static class PickWithIconListener
    implements ItemListener {
        Function<Number, Icon> imager;
        Icon checked;

        public PickWithIconListener(Function<Number, Icon> imager) {
            this.imager = imager;
            this.checked = new Checkmark(Color.red);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Icon icon = (Icon)this.imager.apply((Object)((Number)e.getItem()));
            if (icon != null && icon instanceof LayeredIcon) {
                if (e.getStateChange() == 1) {
                    ((LayeredIcon)icon).add(this.checked);
                } else {
                    ((LayeredIcon)icon).remove(this.checked);
                }
            }
        }
    }

    class VertexStringerImpl<V>
    implements Function<V, String> {
        Map<V, String> map = new HashMap<V, String>();
        boolean enabled = true;

        public VertexStringerImpl(Map<V, String> map) {
            this.map = map;
        }

        public String apply(V v) {
            if (this.isEnabled()) {
                return this.map.get(v);
            }
            return "";
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

