/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Supplier;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.PolarPoint;
import edu.uci.ics.jung.algorithms.layout.RadialTreeLayout;
import edu.uci.ics.jung.algorithms.layout.TreeLayout;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.graph.DelegateForest;
import edu.uci.ics.jung.graph.DelegateTree;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.Forest;
import edu.uci.ics.jung.graph.Tree;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.layout.LayoutTransition;
import edu.uci.ics.jung.visualization.util.Animator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class L2RTreeLayoutDemo
extends JApplet {
    Forest<String, Integer> graph;
    Supplier<DirectedGraph<String, Integer>> graphFactory = new Supplier<DirectedGraph<String, Integer>>(){

        public DirectedGraph<String, Integer> get() {
            return new DirectedSparseMultigraph();
        }
    };
    Supplier<Tree<String, Integer>> treeFactory = new Supplier<Tree<String, Integer>>(){

        public Tree<String, Integer> get() {
            return new DelegateTree(L2RTreeLayoutDemo.this.graphFactory);
        }
    };
    Supplier<Integer> edgeFactory = new Supplier<Integer>(){
        int i = 0;

        public Integer get() {
            return this.i++;
        }
    };
    Supplier<String> vertexFactory = new Supplier<String>(){
        int i = 0;

        public String get() {
            return "V" + this.i++;
        }
    };
    VisualizationViewer<String, Integer> vv;
    VisualizationServer.Paintable rings;
    String root;
    TreeLayout<String, Integer> treeLayout;
    RadialTreeLayout<String, Integer> radialLayout;

    public L2RTreeLayoutDemo() {
        this.graph = new DelegateForest();
        this.createTree();
        this.treeLayout = new TreeLayout(this.graph);
        this.radialLayout = new RadialTreeLayout(this.graph);
        this.radialLayout.setSize(new Dimension(600, 600));
        this.vv = new VisualizationViewer(this.treeLayout, new Dimension(600, 600));
        this.vv.setBackground(Color.white);
        this.vv.getRenderContext().setEdgeShapeTransformer((Function)EdgeShape.quadCurve(this.graph));
        this.vv.getRenderContext().setVertexLabelTransformer((Function)new ToStringLabeller());
        this.vv.setVertexToolTipTransformer((Function)new ToStringLabeller());
        this.vv.getRenderContext().setArrowFillPaintTransformer(Functions.constant((Object)Color.lightGray));
        this.rings = new Rings();
        this.setLtoR(this.vv);
        Container content = this.getContentPane();
        GraphZoomScrollPane panel = new GraphZoomScrollPane(this.vv);
        content.add((Component)panel);
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)graphMouse);
        JComboBox modeBox = graphMouse.getModeComboBox();
        modeBox.addItemListener(graphMouse.getModeListener());
        graphMouse.setMode(ModalGraphMouse.Mode.TRANSFORMING);
        CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(L2RTreeLayoutDemo.this.vv, 1.1f, L2RTreeLayoutDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(L2RTreeLayoutDemo.this.vv, 0.9090909f, L2RTreeLayoutDemo.this.vv.getCenter());
            }
        });
        JToggleButton radial = new JToggleButton("Radial");
        radial.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    LayoutTransition lt = new LayoutTransition(L2RTreeLayoutDemo.this.vv, L2RTreeLayoutDemo.this.treeLayout, L2RTreeLayoutDemo.this.radialLayout);
                    Animator animator = new Animator((IterativeContext)lt);
                    animator.start();
                    L2RTreeLayoutDemo.this.vv.getRenderContext().getMultiLayerTransformer().setToIdentity();
                    L2RTreeLayoutDemo.this.vv.addPreRenderPaintable(L2RTreeLayoutDemo.this.rings);
                } else {
                    LayoutTransition lt = new LayoutTransition(L2RTreeLayoutDemo.this.vv, L2RTreeLayoutDemo.this.radialLayout, L2RTreeLayoutDemo.this.treeLayout);
                    Animator animator = new Animator((IterativeContext)lt);
                    animator.start();
                    L2RTreeLayoutDemo.this.vv.getRenderContext().getMultiLayerTransformer().setToIdentity();
                    L2RTreeLayoutDemo.this.setLtoR((VisualizationViewer<String, Integer>)L2RTreeLayoutDemo.this.vv);
                    L2RTreeLayoutDemo.this.vv.removePreRenderPaintable(L2RTreeLayoutDemo.this.rings);
                }
                L2RTreeLayoutDemo.this.vv.repaint();
            }
        });
        JPanel scaleGrid = new JPanel(new GridLayout(1, 0));
        scaleGrid.setBorder(BorderFactory.createTitledBorder("Zoom"));
        JPanel controls = new JPanel();
        scaleGrid.add(plus);
        scaleGrid.add(minus);
        controls.add(radial);
        controls.add(scaleGrid);
        controls.add(modeBox);
        content.add((Component)controls, "South");
    }

    private void setLtoR(VisualizationViewer<String, Integer> vv) {
        Layout layout = vv.getModel().getGraphLayout();
        Dimension d = layout.getSize();
        Point2D.Double center = new Point2D.Double(d.width / 2, d.height / 2);
        vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT).rotate(-1.5707963267948966, (Point2D)center);
    }

    private void createTree() {
        this.graph.addVertex((Object)"V0");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"V0", (Object)"V1");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"V0", (Object)"V2");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"V1", (Object)"V4");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"V2", (Object)"V3");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"V2", (Object)"V5");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"V4", (Object)"V6");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"V4", (Object)"V7");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"V3", (Object)"V8");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"V6", (Object)"V9");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"V4", (Object)"V10");
        this.graph.addVertex((Object)"A0");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"A0", (Object)"A1");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"A0", (Object)"A2");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"A0", (Object)"A3");
        this.graph.addVertex((Object)"B0");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"B0", (Object)"B1");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"B0", (Object)"B2");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"B1", (Object)"B4");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"B2", (Object)"B3");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"B2", (Object)"B5");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"B4", (Object)"B6");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"B4", (Object)"B7");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"B3", (Object)"B8");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"B6", (Object)"B9");
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        Container content = frame.getContentPane();
        frame.setDefaultCloseOperation(3);
        content.add(new L2RTreeLayoutDemo());
        frame.pack();
        frame.setVisible(true);
    }

    class Rings
    implements VisualizationServer.Paintable {
        Collection<Double> depths = this.getDepths();

        private Collection<Double> getDepths() {
            HashSet<Double> depths = new HashSet<Double>();
            Map polarLocations = L2RTreeLayoutDemo.this.radialLayout.getPolarLocations();
            for (String v : L2RTreeLayoutDemo.this.graph.getVertices()) {
                PolarPoint pp = (PolarPoint)polarLocations.get(v);
                depths.add(pp.getRadius());
            }
            return depths;
        }

        public void paint(Graphics g) {
            g.setColor(Color.lightGray);
            Graphics2D g2d = (Graphics2D)g;
            Point2D center = L2RTreeLayoutDemo.this.radialLayout.getCenter();
            Ellipse2D.Double ellipse = new Ellipse2D.Double();
            for (double d : this.depths) {
                ellipse.setFrameFromDiagonal(center.getX() - d, center.getY() - d, center.getX() + d, center.getY() + d);
                Shape shape = L2RTreeLayoutDemo.this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT).transform((Shape)ellipse);
                g2d.draw(shape);
            }
        }

        public boolean useTransform() {
            return true;
        }
    }
}

