/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mgp.unclasses;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DependencyGraph {
    private final Map<String, Boolean> referencedClasses = new HashMap<String, Boolean>();

    public DependencyGraph(Collection<String> classNames) {
        for (String className : classNames) {
            this.referencedClasses.put(className, Boolean.FALSE);
        }
    }

    public void reference(String className) {
        if (this.referencedClasses.containsKey(className)) {
            this.referencedClasses.put(className, Boolean.TRUE);
        }
    }

    public Collection<String> getUnreferenced() {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, Boolean> entry : this.referencedClasses.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            result.add(entry.getKey());
        }
        return result;
    }
}

