/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mgp.unclasses;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.mgp.unclasses.DependencyGraph;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.shared.dependency.analyzer.asm.DependencyClassFileVisitor;
import org.codehaus.plexus.util.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnclassesMojo
extends AbstractMojo {
    private static final int FILE_SUFFIX_LENGTH = ".class".length();
    private static final String[] CLASS_FILE_PATTERNS = new String[]{"**/*.class"};
    private File classesDirectory;

    public void execute() throws MojoFailureException {
        String[] paths = this.findClassFiles();
        Map<String, String> fileClasses = this.getFileClassNames(paths);
        Collection<String> unreferenced = this.getUnreferencedClassNames(fileClasses);
        if (!unreferenced.isEmpty()) {
            this.logUnreferenced(unreferenced);
        }
    }

    Collection<String> getUnreferencedClassNames(Map<String, String> fileClassNames) throws MojoFailureException {
        DependencyGraph graph = new DependencyGraph(fileClassNames.values());
        for (Map.Entry<String, String> entry : fileClassNames.entrySet()) {
            String classFile = entry.getKey();
            String className = entry.getValue();
            for (String dependency : this.getDependencies(classFile, className)) {
                if (className.equals(dependency)) continue;
                graph.reference(dependency);
            }
        }
        Collection<String> unreferenced = graph.getUnreferenced();
        return unreferenced;
    }

    private String[] findClassFiles() {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.classesDirectory);
        scanner.setIncludes(CLASS_FILE_PATTERNS);
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<String> getDependencies(String classFile, String className) throws MojoFailureException {
        DependencyClassFileVisitor visitor = new DependencyClassFileVisitor();
        try {
            FileInputStream in = new FileInputStream(new File(this.classesDirectory, classFile));
            try {
                visitor.visitClass(className, (InputStream)in);
            }
            finally {
                ((InputStream)in).close();
            }
        }
        catch (IOException e) {
            throw new MojoFailureException((Object)e, "Execution failed", "Failed to read project class files");
        }
        return visitor.getDependencies();
    }

    private void logUnreferenced(Collection<String> unreferenced) {
        this.getLog().error((CharSequence)"Unreferenced project classes:");
        for (String className : unreferenced) {
            this.getLog().error((CharSequence)(" " + className));
        }
    }

    private Map<String, String> getFileClassNames(String[] paths) {
        HashMap<String, String> result = new HashMap<String, String>(paths.length);
        for (String path : paths) {
            String className = this.getClassName(path);
            result.put(path, className);
        }
        return result;
    }

    private String getClassName(String classFilePath) {
        String className = classFilePath.substring(0, classFilePath.length() - FILE_SUFFIX_LENGTH);
        return className.replace(File.separatorChar, '.');
    }
}

