/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.factory;

import java.util.Collections;
import java.util.List;
import net.shibboleth.ext.spring.factory.ResourceListBean;
import net.shibboleth.ext.spring.util.ApplicationContextBuilder;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CombiningListFactoryBeanTest {
    @Test
    public void test() {
        ClassPathResource r = new ClassPathResource("net/shibboleth/ext/spring/factory/lists.xml");
        GenericApplicationContext ctx = new ApplicationContextBuilder().setName("appCtx").setServiceConfigurations(Collections.singletonList(r)).build();
        List list = (List)ctx.getBean("combined");
        Assert.assertEquals((int)list.size(), (int)4);
        Assert.assertTrue((boolean)list.contains("a"));
        Assert.assertTrue((boolean)list.contains("b"));
        Assert.assertTrue((boolean)list.contains("parent"));
        Assert.assertTrue((boolean)list.contains("child"));
    }

    @Test
    public void resourceTest() {
        ClassPathResource r = new ClassPathResource("net/shibboleth/ext/spring/factory/resourceLists.xml");
        GenericApplicationContext ctx = new ApplicationContextBuilder().setName("appCtx").setServiceConfigurations(Collections.singletonList(r)).build();
        ResourceListBean bean = (ResourceListBean)ctx.getBean(ResourceListBean.class);
        Assert.assertEquals((int)bean.getResources().size(), (int)2);
    }
}

