/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.util;

import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.shibboleth.ext.spring.util.IdentifiedComponentManager;
import net.shibboleth.ext.spring.util.SchemaTypeAwareXMLBeanDefinitionReader;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class IdentifiedComponentManagerTest {
    @Test
    public void testCombining() {
        ApplicationContext context = this.getContext("net/shibboleth/ext/spring/util/combined.xml");
        MockComponentManager manager = (MockComponentManager)((Object)context.getBean(MockComponentManager.class));
        Assert.assertNotNull((Object)((Object)manager));
        Assert.assertEquals((int)manager.getComponents().size(), (int)3);
        Iterator i = manager.getComponents().iterator();
        Assert.assertEquals((String)((MockComponent)((Object)i.next())).getId(), (String)"One");
        Assert.assertEquals((String)((MockComponent)((Object)i.next())).getId(), (String)"Two");
        Assert.assertEquals((String)((MockComponent)((Object)i.next())).getId(), (String)"Three");
        i = manager.getComponents().iterator();
        Assert.assertEquals((String)((MockComponent)((Object)i.next())).getData(), (String)"Foo1");
        Assert.assertEquals((String)((MockComponent)((Object)i.next())).getData(), (String)"Foo2");
        Assert.assertEquals((String)((MockComponent)((Object)i.next())).getData(), (String)"Foo3");
    }

    @Test
    public void testOverlap() {
        ApplicationContext context = this.getContext("net/shibboleth/ext/spring/util/overlap.xml");
        MockComponentManager manager = (MockComponentManager)((Object)context.getBean(MockComponentManager.class));
        Assert.assertNotNull((Object)((Object)manager));
        Assert.assertEquals((int)manager.getComponents().size(), (int)3);
        Iterator i = manager.getComponents().iterator();
        Assert.assertEquals((String)((MockComponent)((Object)i.next())).getId(), (String)"One");
        Assert.assertEquals((String)((MockComponent)((Object)i.next())).getId(), (String)"Three");
        Assert.assertEquals((String)((MockComponent)((Object)i.next())).getId(), (String)"Two");
        i = manager.getComponents().iterator();
        Assert.assertEquals((String)((MockComponent)((Object)i.next())).getData(), (String)"Foo1");
        Assert.assertEquals((String)((MockComponent)((Object)i.next())).getData(), (String)"Foo3");
        Assert.assertEquals((String)((MockComponent)((Object)i.next())).getData(), (String)"Foo2");
    }

    @Test
    public void testStaticOnly() {
        ApplicationContext context = this.getContext("net/shibboleth/ext/spring/util/staticOnly.xml");
        MockComponentManager manager = (MockComponentManager)((Object)context.getBean(MockComponentManager.class));
        Assert.assertNotNull((Object)((Object)manager));
        Assert.assertEquals((int)manager.getComponents().size(), (int)3);
        Iterator i = manager.getComponents().iterator();
        Assert.assertEquals((String)((MockComponent)((Object)i.next())).getId(), (String)"One");
        Assert.assertEquals((String)((MockComponent)((Object)i.next())).getId(), (String)"Two");
        Assert.assertEquals((String)((MockComponent)((Object)i.next())).getId(), (String)"Three");
        i = manager.getComponents().iterator();
        Assert.assertEquals((String)((MockComponent)((Object)i.next())).getData(), (String)"Foo1");
        Assert.assertEquals((String)((MockComponent)((Object)i.next())).getData(), (String)"Foo2");
        Assert.assertEquals((String)((MockComponent)((Object)i.next())).getData(), (String)"Foo3");
    }

    @Test
    public void testFreeOnly() {
        ApplicationContext context = this.getContext("net/shibboleth/ext/spring/util/freeOnly.xml");
        MockComponentManager manager = (MockComponentManager)((Object)context.getBean(MockComponentManager.class));
        Assert.assertNotNull((Object)((Object)manager));
        Assert.assertEquals((int)manager.getComponents().size(), (int)1);
        Iterator i = manager.getComponents().iterator();
        Assert.assertEquals((String)((MockComponent)((Object)i.next())).getId(), (String)"Three");
        i = manager.getComponents().iterator();
        Assert.assertEquals((String)((MockComponent)((Object)i.next())).getData(), (String)"Foo3");
    }

    private ApplicationContext getContext(String config) {
        GenericApplicationContext context = new GenericApplicationContext();
        SchemaTypeAwareXMLBeanDefinitionReader beanDefinitionReader = new SchemaTypeAwareXMLBeanDefinitionReader((BeanDefinitionRegistry)context);
        beanDefinitionReader.setValidationMode(3);
        beanDefinitionReader.loadBeanDefinitions(config);
        context.refresh();
        return context;
    }

    public static class MockComponentManager
    extends IdentifiedComponentManager<MockComponent> {
        @Autowired
        public MockComponentManager(@Nonnull @NonnullElements Collection<MockComponent> freeObjects) {
            super(freeObjects);
        }
    }

    public static class MockComponent
    extends AbstractIdentifiableInitializableComponent {
        private final String data;

        public MockComponent(String s) {
            this.data = s;
        }

        public String getData() {
            return this.data;
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof MockComponent) {
                return this.getId().equals(((MockComponent)((Object)obj)).getId());
            }
            return false;
        }
    }
}

