/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.error;

import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.codec.HTMLEncoder;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.SimpleMappingExceptionResolver;

public class ExtendedMappingExceptionResolver
extends SimpleMappingExceptionResolver {
    @Nonnull
    private static final String MODEL_ATTR_REQUEST = "request";
    @Nonnull
    private static final String MODEL_ATTR_RESPONSE = "response";
    @Nonnull
    private static final String MODEL_ATTR_SPRINGCONTEXT = "springContext";
    @Nonnull
    private static final String MODEL_ATTR_ENCODER = "encoder";
    @Nullable
    private Function<HttpServletRequest, Map<String, Object>> viewModelExtenderFunction;

    public ExtendedMappingExceptionResolver() {
    }

    public ExtendedMappingExceptionResolver(@Nullable Function<HttpServletRequest, Map<String, Object>> extender) {
        this.viewModelExtenderFunction = extender;
    }

    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        ModelAndView view = super.doResolveException(request, response, handler, ex);
        if (view != null) {
            view.addObject(MODEL_ATTR_RESPONSE, (Object)response);
        }
        return view;
    }

    protected ModelAndView getModelAndView(String viewName, Exception ex, HttpServletRequest request) {
        Map<String, Object> exts;
        LoggerFactory.getLogger(ex.getClass()).error("", (Throwable)ex);
        ModelAndView view = super.getModelAndView(viewName, ex, request);
        view.addObject(MODEL_ATTR_REQUEST, (Object)request);
        view.addObject(MODEL_ATTR_ENCODER, HTMLEncoder.class);
        WebApplicationContext context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)request.getServletContext());
        if (context != null) {
            view.addObject(MODEL_ATTR_SPRINGCONTEXT, (Object)context);
        }
        if (this.viewModelExtenderFunction != null && (exts = this.viewModelExtenderFunction.apply(request)) != null) {
            view.addAllObjects(exts);
        }
        return view;
    }
}

