/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.admin.impl;

import com.google.common.base.StandardSystemProperty;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.shibboleth.idp.Version;
import net.shibboleth.idp.module.IdPModule;
import net.shibboleth.idp.plugin.IdPPlugin;
import net.shibboleth.profile.module.ModuleContext;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public final class LogImplementationDetails {
    public LogImplementationDetails(@Nullable @NotEmpty String idpHomeLocation) {
        List plugins;
        Logger logger = LoggerFactory.getLogger(LogImplementationDetails.class);
        logger.info("Shibboleth IdP Version {}", (Object)Version.getVersion());
        logger.info("Java version='{}' vendor='{}'", (Object)StandardSystemProperty.JAVA_VERSION.value(), (Object)StandardSystemProperty.JAVA_VENDOR.value());
        if (logger.isDebugEnabled()) {
            for (StandardSystemProperty standardSystemProperty : StandardSystemProperty.values()) {
                logger.debug("{}", (Object)standardSystemProperty);
            }
        }
        if ((plugins = ServiceLoader.load(IdPPlugin.class).stream().map(e -> (IdPPlugin)e.get()).collect(Collectors.toList())).isEmpty()) {
            logger.info("No Plugins Loaded");
        } else {
            logger.info("Plugins:");
            for (IdPPlugin idpPlugin : plugins) {
                logger.info("\t\t{} : v{}.{}.{}", new Object[]{idpPlugin.getPluginId(), idpPlugin.getMajorVersion(), idpPlugin.getMinorVersion(), idpPlugin.getPatchVersion()});
            }
        }
        if (idpHomeLocation != null) {
            ModuleContext context = new ModuleContext(idpHomeLocation);
            List modules = ServiceLoader.load(IdPModule.class).stream().map(e -> (IdPModule)e.get()).filter(f -> f.isEnabled(context)).collect(Collectors.toList());
            if (modules.isEmpty()) {
                logger.info("No Modules Enabled");
            } else {
                logger.info("Enabled Modules:");
                for (IdPModule module : modules) {
                    logger.info("\t\t{}", (Object)module.getName(context));
                }
            }
        } else {
            logger.warn("Could not enumerate Modules");
        }
    }
}

