/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.admin.impl;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.ConfigurationSetting;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.NullableElements;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.component.IdentifiableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.springframework.core.annotation.AnnotationUtils;

public class OutputConfig
extends AbstractProfileAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(OutputConfig.class);
    @Nullable
    private String allowedOrigin;
    @Nullable
    private String jsonpCallbackName;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @NonnullBeforeExec
    private RelyingPartyContext relyingPartyContext;

    public void setAllowedOrigin(@Nullable String origin) {
        this.checkSetterPreconditions();
        this.allowedOrigin = StringSupport.trimOrNull((String)origin);
    }

    public void setJSONPCallbackName(@Nullable String callbackName) {
        this.checkSetterPreconditions();
        this.jsonpCallbackName = StringSupport.trimOrNull((String)callbackName);
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.checkSetterPreconditions();
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.relyingPartyContext = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (this.relyingPartyContext == null) {
            this.log.warn("{} No RelyingPartyContext available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        if (this.relyingPartyContext.getConfiguration() == null) {
            this.log.warn("{} No RelyingPartyConfiguration available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyConfiguration");
            return false;
        }
        if (this.relyingPartyContext.getProfileConfig() == null) {
            this.log.warn("{} No ProfileConfiguration available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        HttpServletResponse response = this.getHttpServletResponse();
        if (response == null) {
            this.log.warn("{} No HttpServletResponse available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        try {
            HttpServletResponse response = this.getHttpServletResponse();
            assert (response != null);
            response.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
            response.setStatus(200);
            if (this.allowedOrigin != null) {
                response.setHeader("Access-Control-Allow-Origin", this.allowedOrigin);
            }
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new JavaTimeModule());
            mapper.configure(SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS, false);
            mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            mapper.configure(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS, false);
            if (this.jsonpCallbackName != null) {
                response.setContentType("application/javascript");
                mapper.writer().writeValue((OutputStream)response.getOutputStream(), this.getConfig(profileRequestContext));
            } else {
                response.setContentType("application/json");
                mapper.writer().writeValue((OutputStream)response.getOutputStream(), this.getConfig(profileRequestContext));
            }
        }
        catch (IOException e) {
            this.log.error("{} I/O error responding to request", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
        }
    }

    @Nonnull
    @NullableElements
    private Map<String, Object> getConfig(@Nonnull ProfileRequestContext profileRequestContext) {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("RelyingPartyConfiguration", this.getSettings(profileRequestContext, this.relyingPartyContext.ensureConfiguration()));
        settings.put("ProfileConfiguration", this.getSettings(profileRequestContext, this.relyingPartyContext.ensureProfileConfig()));
        return settings;
    }

    @Nonnull
    @NullableElements
    @Unmodifiable
    @NotLive
    private Map<String, Object> getSettings(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull Object target) {
        Method[] methods;
        HashMap<String, Object> settings = new HashMap<String, Object>();
        if (target instanceof IdentifiableComponent) {
            IdentifiableComponent comp = (IdentifiableComponent)target;
            settings.put("id", comp.getId());
        }
        for (Method m : methods = target.getClass().getMethods()) {
            Class<?>[] paramTypes;
            assert (m != null);
            ConfigurationSetting annotation = (ConfigurationSetting)AnnotationUtils.findAnnotation((Method)m, ConfigurationSetting.class);
            if (annotation == null || annotation.name() == null || annotation.name().isEmpty() || (paramTypes = m.getParameterTypes()).length != 1 || !paramTypes[0].isAssignableFrom(ProfileRequestContext.class)) continue;
            try {
                Object ret = m.invoke(target, profileRequestContext);
                if (ret == null) continue;
                if (ret instanceof IdentifiableComponent) {
                    IdentifiableComponent comp = (IdentifiableComponent)ret;
                    settings.put(annotation.name(), comp.getId());
                    continue;
                }
                if (ret instanceof Collection) {
                    Collection c = (Collection)ret;
                    if (c.isEmpty()) continue;
                    settings.put(annotation.name(), ret);
                    continue;
                }
                if (this.isPrimitive(ret)) {
                    settings.put(annotation.name(), ret);
                    continue;
                }
                settings.put(annotation.name(), ret.getClass().getName());
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                this.log.error("{} Error introspecting configuration setting '{}'", new Object[]{this.getLogPrefix(), annotation.name(), e});
            }
        }
        return settings;
    }

    private boolean isPrimitive(@Nullable Object o) {
        return o instanceof Boolean || o instanceof Integer || o instanceof Long || o instanceof Double || o instanceof String || o instanceof Duration || o instanceof Instant;
    }
}

