/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.admin.impl;

import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import javax.annotation.Nonnull;
import net.shibboleth.idp.module.IdPModule;
import net.shibboleth.idp.plugin.IdPPlugin;
import net.shibboleth.profile.module.ModuleContext;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class ReportModuleStatus
extends AbstractIdentifiableInitializableComponent {
    private final Logger log = LoggerFactory.getLogger(ReportModuleStatus.class);
    @Nonnull
    private String idpHome = "";

    public void setIdpHome(@Nonnull @NotEmpty String input) {
        this.idpHome = (String)Constraint.isNotNull((Object)input, (String)"IdpHome not set");
    }

    @Nonnull
    private Set<String> getEnabledModules() {
        HashSet<String> result = new HashSet<String>();
        ModuleContext mc = new ModuleContext(this.idpHome);
        for (IdPModule module : ServiceLoader.load(IdPModule.class)) {
            if (module.isEnabled(mc)) {
                this.log.trace("Found enabled Module {}", (Object)module.getId());
                result.add(module.getId());
                continue;
            }
            this.log.trace("Found disabled Module {}", (Object)module.getId());
        }
        return result;
    }

    private void checkPlugins(@Nonnull Set<String> enabledModules) {
        for (IdPPlugin plugin : ServiceLoader.load(IdPPlugin.class)) {
            this.log.debug("Checking required modules for plugin {}", (Object)plugin.getPluginId());
            for (String module : plugin.getRequiredModules()) {
                if (enabledModules.contains(module)) {
                    this.log.debug("Found required module {}", (Object)module);
                    continue;
                }
                this.log.error("Module {} required by plugin {} not found", (Object)module, (Object)plugin.getPluginId());
            }
        }
    }

    protected void doInitialize() throws ComponentInitializationException {
        this.checkPlugins(this.getEnabledModules());
    }
}

