/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.context;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import org.opensaml.messaging.context.BaseContext;

public class SubjectContext
extends BaseContext {
    @Nullable
    private String impersonatingPrincipalName;
    @Nullable
    private String principalName;
    @Nonnull
    @NonnullElements
    private final Map<String, AuthenticationResult> authenticationResults = new HashMap<String, AuthenticationResult>(2);

    @Nullable
    public String getPrincipalName() {
        return this.principalName;
    }

    @Nonnull
    public SubjectContext setPrincipalName(@Nullable String name) {
        this.principalName = name;
        return this;
    }

    @Nullable
    public String getImpersonatingPrincipalName() {
        return this.impersonatingPrincipalName;
    }

    @Nonnull
    public SubjectContext setImpersonatingPrincipalName(@Nullable String name) {
        this.impersonatingPrincipalName = name;
        return this;
    }

    @Nonnull
    @NonnullElements
    @Live
    public Map<String, AuthenticationResult> getAuthenticationResults() {
        return this.authenticationResults;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<Subject> getSubjects() {
        ArrayList<Subject> composite = new ArrayList<Subject>();
        for (AuthenticationResult e : this.getAuthenticationResults().values()) {
            composite.add(e.getSubject());
        }
        return ImmutableList.copyOf(composite);
    }
}

