/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.AuthenticationErrorContext;
import net.shibboleth.idp.authn.context.AuthenticationWarningContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicate;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicateFactory;
import net.shibboleth.idp.authn.principal.PrincipalSupportingComponent;
import net.shibboleth.idp.profile.context.navigate.RelyingPartyIdLookupFunction;
import net.shibboleth.idp.profile.context.navigate.ResponderIdLookupFunction;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.core.metrics.MetricsSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractValidationAction
extends AbstractAuthenticationAction
implements PrincipalSupportingComponent {
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_METRIC_NAME = "net.shibboleth.idp.authn.validation";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractValidationAction.class);
    @Nonnull
    @NotEmpty
    private String metricName;
    @Nonnull
    private final Subject authenticatedSubject = new Subject();
    private boolean addDefaultPrincipals = true;
    private boolean clearErrorContext = true;
    @Nullable
    private Consumer<ProfileRequestContext> cleanupHook;
    @Nonnull
    @NonnullElements
    private Map<String, Collection<String>> classifiedMessages = Collections.emptyMap();
    @Nullable
    private Predicate<ProfileRequestContext> resultCachingPredicate;
    @Nullable
    private Function<ProfileRequestContext, String> requesterLookupStrategy = new RelyingPartyIdLookupFunction();
    @Nullable
    private Function<ProfileRequestContext, String> responderLookupStrategy = new ResponderIdLookupFunction();

    public AbstractValidationAction() {
        this.setMetricName(DEFAULT_METRIC_NAME);
    }

    @Nonnull
    @NotEmpty
    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.metricName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Metric name cannot be null or empty");
    }

    public boolean addDefaultPrincipals() {
        return this.addDefaultPrincipals;
    }

    public void setAddDefaultPrincipals(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.addDefaultPrincipals = flag;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public Map<String, Collection<String>> getClassifiedErrors() {
        return Collections.unmodifiableMap(this.classifiedMessages);
    }

    public void setClassifiedMessages(@Nullable @NonnullElements Map<String, Collection<String>> messages) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        if (messages != null) {
            this.classifiedMessages = new LinkedHashMap<String, Collection<String>>();
            for (Map.Entry<String, Collection<String>> entry : messages.entrySet()) {
                if (entry.getKey() == null || entry.getKey().isEmpty() || entry.getValue() == null || entry.getValue().isEmpty()) continue;
                this.classifiedMessages.put(entry.getKey(), List.copyOf(entry.getValue()));
            }
        } else {
            this.classifiedMessages = Collections.emptyMap();
        }
    }

    @Nullable
    public Predicate<ProfileRequestContext> getResultCachingPredicate() {
        return this.resultCachingPredicate;
    }

    public void setResultCachingPredicate(@Nullable Predicate<ProfileRequestContext> predicate) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.resultCachingPredicate = predicate;
    }

    @Nullable
    public Consumer<ProfileRequestContext> getCleanupHook() {
        return this.cleanupHook;
    }

    public void setCleanupHook(@Nullable Consumer<ProfileRequestContext> hook) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.cleanupHook = hook;
    }

    @Nullable
    public Function<ProfileRequestContext, String> getRequesterLookupStrategy() {
        return this.requesterLookupStrategy;
    }

    public void setRequesterLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.requesterLookupStrategy = strategy;
    }

    @Nullable
    public Function<ProfileRequestContext, String> getResponderLookupStrategy() {
        return this.responderLookupStrategy;
    }

    public void setResponderLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.responderLookupStrategy = strategy;
    }

    @Override
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public <T extends Principal> Set<T> getSupportedPrincipals(@Nonnull Class<T> c) {
        return this.getSubject().getPrincipals(c);
    }

    public void setSupportedPrincipals(@Nullable @NonnullElements Collection<Principal> principals) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.getSubject().getPrincipals().clear();
        if (principals != null && !principals.isEmpty()) {
            this.getSubject().getPrincipals().addAll(Set.copyOf(principals));
        }
    }

    @Nonnull
    protected Subject getSubject() {
        return this.authenticatedSubject;
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        String fixedEvent;
        RequestedPrincipalContext rpCtx;
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        if (authenticationContext.getAttemptedFlow() == null) {
            this.log.info("{} No attempted flow within authentication context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
            return false;
        }
        if (this.clearErrorContext) {
            authenticationContext.removeSubcontext(AuthenticationErrorContext.class);
        }
        if ((rpCtx = (RequestedPrincipalContext)authenticationContext.getSubcontext(RequestedPrincipalContext.class)) != null && rpCtx.getOperator() != null && !this.getSubject().getPrincipals().isEmpty()) {
            this.log.debug("{} Request contains principal requirements, evaluating for compatibility", (Object)this.getLogPrefix());
            for (Principal p : rpCtx.getRequestedPrincipals()) {
                PrincipalEvalPredicateFactory factory = rpCtx.getPrincipalEvalPredicateFactoryRegistry().lookup(p.getClass(), rpCtx.getOperator());
                if (factory != null) {
                    PrincipalEvalPredicate predicate = factory.getPredicate(p);
                    if (predicate.test(this)) {
                        this.log.debug("{} Compatible with principal type '{}' and operator '{}'", new Object[]{this.getLogPrefix(), p.getClass(), rpCtx.getOperator()});
                        rpCtx.setMatchingPrincipal(predicate.getMatchingPrincipal());
                        return true;
                    }
                    this.log.debug("{} Not compatible with principal type '{}' and operator '{}'", new Object[]{this.getLogPrefix(), p.getClass(), rpCtx.getOperator()});
                    continue;
                }
                this.log.debug("{} No comparison logic registered for principal type '{}' and operator '{}'", new Object[]{this.getLogPrefix(), p.getClass(), rpCtx.getOperator()});
            }
            this.log.info("{} Skipping validator, not compatible with request's principal requirements", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"RequestUnsupported");
            return false;
        }
        if (authenticationContext.getFixedEventLookupStrategy() != null && (fixedEvent = authenticationContext.getFixedEventLookupStrategy().apply(profileRequestContext)) != null) {
            this.log.info("{} Signaling fixed event: {}", (Object)this.getLogPrefix(), (Object)fixedEvent);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)fixedEvent);
            return false;
        }
        return true;
    }

    protected void buildAuthenticationResult(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        BiConsumer<ProfileRequestContext, Subject> decorator;
        if (this.addDefaultPrincipals) {
            this.log.debug("{} Adding custom Principal(s) defined on underlying flow descriptor", (Object)this.getLogPrefix());
            this.getSubject().getPrincipals().addAll(authenticationContext.getAttemptedFlow().getSupportedPrincipals());
        }
        AuthenticationResult result = authenticationContext.getAttemptedFlow().newAuthenticationResult(this.populateSubject(this.getSubject()));
        authenticationContext.setAuthenticationResult(result);
        if (authenticationContext.isResultCacheable() && this.resultCachingPredicate != null) {
            authenticationContext.setResultCacheable(this.resultCachingPredicate.test(profileRequestContext));
            this.log.info("{} Predicate indicates authentication result {} be cacheable in a session", (Object)this.getLogPrefix(), (Object)(authenticationContext.isResultCacheable() ? "will" : "will not"));
        }
        if ((decorator = authenticationContext.getAttemptedFlow().getSubjectDecorator()) != null) {
            decorator.accept(profileRequestContext, result.getSubject());
        }
        SubjectCanonicalizationContext c14n = new SubjectCanonicalizationContext();
        c14n.setSubject(result.getSubject());
        if (this.requesterLookupStrategy != null) {
            c14n.setRequesterId(this.requesterLookupStrategy.apply(profileRequestContext));
        }
        if (this.responderLookupStrategy != null) {
            c14n.setResponderId(this.responderLookupStrategy.apply(profileRequestContext));
        }
        authenticationContext.getParent().addSubcontext((BaseContext)c14n, true);
    }

    @Nonnull
    protected abstract Subject populateSubject(@Nonnull Subject var1);

    @Deprecated(since="4.1.0", forRemoval=true)
    protected void recordSuccess() {
        if (MetricsSupport.getMetricRegistry() != null) {
            MetricsSupport.getMetricRegistry().counter(this.getMetricName() + ".successes").inc();
        }
    }

    @Deprecated(since="4.1.0", forRemoval=true)
    protected void recordFailure() {
        if (MetricsSupport.getMetricRegistry() != null) {
            MetricsSupport.getMetricRegistry().counter(this.getMetricName() + ".failures").inc();
        }
    }

    protected void recordSuccess(@Nonnull ProfileRequestContext profileRequestContext) {
        this.recordSuccess();
        if (this.cleanupHook != null) {
            this.cleanupHook.accept(profileRequestContext);
        }
    }

    protected void recordFailure(@Nonnull ProfileRequestContext profileRequestContext) {
        this.recordFailure();
    }

    protected void handleError(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nonnull Exception e, @Nonnull @NotEmpty String eventId) {
        ((AuthenticationErrorContext)authenticationContext.getSubcontext(AuthenticationErrorContext.class, true)).getExceptions().add(e);
        this.handleError(profileRequestContext, authenticationContext, e.getMessage(), eventId);
    }

    protected void handleError(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nullable String message, @Nonnull @NotEmpty String eventId) {
        boolean eventSet = false;
        if (!Strings.isNullOrEmpty((String)message)) {
            MessageChecker checker = new MessageChecker(message);
            for (Map.Entry<String, Collection<String>> entry : this.classifiedMessages.entrySet()) {
                if (!Iterables.any((Iterable)entry.getValue(), checker::test)) continue;
                ((AuthenticationErrorContext)authenticationContext.getSubcontext(AuthenticationErrorContext.class, true)).getClassifiedErrors().add(entry.getKey());
                if (eventSet) continue;
                eventSet = true;
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)entry.getKey());
            }
        }
        if (!eventSet) {
            ((AuthenticationErrorContext)authenticationContext.getSubcontext(AuthenticationErrorContext.class, true)).getClassifiedErrors().add(eventId);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)eventId);
        }
    }

    protected void handleWarning(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nullable String message, @Nonnull @NotEmpty String eventId) {
        boolean eventSet = false;
        if (!Strings.isNullOrEmpty((String)message)) {
            MessageChecker checker = new MessageChecker(message);
            for (Map.Entry<String, Collection<String>> entry : this.classifiedMessages.entrySet()) {
                if (!Iterables.any((Iterable)entry.getValue(), checker::test)) continue;
                ((AuthenticationWarningContext)authenticationContext.getSubcontext(AuthenticationWarningContext.class, true)).getClassifiedWarnings().add(entry.getKey());
                if (eventSet) continue;
                eventSet = true;
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)entry.getKey());
            }
        }
        if (!eventSet) {
            ((AuthenticationWarningContext)authenticationContext.getSubcontext(AuthenticationWarningContext.class, true)).getClassifiedWarnings().add(eventId);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)eventId);
        }
    }

    private class MessageChecker
    implements Predicate<String> {
        @Nonnull
        @NotEmpty
        private final String s;

        public MessageChecker(String msg) {
            Constraint.isFalse((boolean)Strings.isNullOrEmpty((String)msg), (String)"Message cannot be null or empty");
            this.s = msg;
        }

        @Override
        public boolean test(String input) {
            return this.s.contains(input);
        }
    }
}

