/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn;

import com.google.common.base.MoreObjects;
import com.google.common.base.Predicates;
import java.io.IOException;
import java.security.Principal;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.principal.PrincipalServiceManager;
import net.shibboleth.idp.authn.principal.PrincipalSupportingComponent;
import net.shibboleth.idp.profile.FlowDescriptor;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.PredicateSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.StorageSerializer;
import org.springframework.core.Ordered;

public class AuthenticationFlowDescriptor
extends AbstractIdentifiableInitializableComponent
implements FlowDescriptor,
PrincipalSupportingComponent,
Predicate<ProfileRequestContext>,
StorageSerializer<AuthenticationResult>,
Ordered {
    @Nonnull
    @NotEmpty
    public static final String FLOW_ID_PREFIX = "authn/";
    @Nonnull
    public static final Duration STORAGE_EXPIRATION_OFFSET = Duration.ofMinutes(10L);
    private int order = Integer.MAX_VALUE;
    private boolean supportsNonBrowser = true;
    private boolean supportsPassive;
    private boolean supportsForced;
    private boolean proxyRestrictionsEnforced = true;
    private boolean proxyScopingEnforced;
    private boolean discoveryRequired;
    @Nonnull
    private Predicate<ProfileRequestContext> reuseCondition = new ProxyCountPredicate();
    @Nullable
    private BiPredicate<ProfileRequestContext, AuthenticationResult> revocationCondition;
    @Nullable
    private Duration lifetime;
    @Nonnull
    private Duration inactivityTimeout;
    @Nonnull
    private Set<String> stringBasedPrincipals;
    @Nonnull
    private Subject supportedPrincipals = new Subject();
    @Nonnull
    private Predicate<ProfileRequestContext> activationCondition = Predicates.alwaysTrue();
    @Nullable
    private StorageSerializer<AuthenticationResult> resultSerializer;
    @Nullable
    @NonnullElements
    private Map<Principal, Integer> principalWeightMap;
    @Nullable
    private PrincipalServiceManager principalServiceManager;
    @Nullable
    private BiConsumer<ProfileRequestContext, Subject> subjectDecorator;

    public AuthenticationFlowDescriptor() {
        this.inactivityTimeout = Duration.ofMinutes(30L);
        this.principalWeightMap = Collections.emptyMap();
        this.stringBasedPrincipals = Collections.emptySet();
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int priority) {
        this.order = priority;
    }

    public boolean isNonBrowserSupported() {
        return this.supportsNonBrowser;
    }

    public void setNonBrowserSupported(boolean isSupported) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.supportsNonBrowser = isSupported;
    }

    public boolean isPassiveAuthenticationSupported() {
        return this.supportsPassive;
    }

    public void setPassiveAuthenticationSupported(boolean isSupported) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.supportsPassive = isSupported;
    }

    public boolean isForcedAuthenticationSupported() {
        return this.supportsForced;
    }

    public void setForcedAuthenticationSupported(boolean isSupported) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.supportsForced = isSupported;
    }

    public boolean isProxyRestrictionsEnforced() {
        return this.proxyRestrictionsEnforced;
    }

    public void setProxyRestrictionsEnforced(boolean flag) {
        this.proxyRestrictionsEnforced = flag;
    }

    public boolean isProxyScopingEnforced() {
        return this.proxyScopingEnforced;
    }

    public void setProxyScopingEnforced(boolean flag) {
        this.proxyScopingEnforced = flag;
    }

    public boolean isDiscoveryRequired() {
        return this.discoveryRequired;
    }

    public void setDiscoveryRequired(boolean flag) {
        this.discoveryRequired = flag;
    }

    @Nonnull
    public Predicate<ProfileRequestContext> getReuseCondition() {
        return this.reuseCondition;
    }

    public void setReuseCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.reuseCondition = PredicateSupport.and((Predicate)new ProxyCountPredicate(), (Predicate)((Predicate)Constraint.isNotNull(condition, (String)"Predicate cannot be null")));
    }

    @Nonnull
    public BiPredicate<ProfileRequestContext, AuthenticationResult> getRevocationCondition() {
        return this.revocationCondition;
    }

    public void setRevocationCondition(@Nullable BiPredicate<ProfileRequestContext, AuthenticationResult> condition) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.revocationCondition = condition;
    }

    @Nullable
    public BiConsumer<ProfileRequestContext, Subject> getSubjectDecorator() {
        return this.subjectDecorator;
    }

    public void setSubjectDecorator(@Nullable BiConsumer<ProfileRequestContext, Subject> decorator) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.subjectDecorator = decorator;
    }

    @Nullable
    public Duration getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(@Nullable Duration flowLifetime) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isFalse((flowLifetime != null && (flowLifetime.isNegative() || flowLifetime.isZero()) ? 1 : 0) != 0, (String)"Lifetime must be null or greater than 0");
        this.lifetime = flowLifetime;
    }

    @Nonnull
    public Duration getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    public void setInactivityTimeout(@Nonnull Duration timeout) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull((Object)timeout, (String)"Inactivity timeout cannot be null");
        Constraint.isFalse((timeout.isNegative() || timeout.isZero() ? 1 : 0) != 0, (String)"Inactivity timeout must be greater than 0");
        this.inactivityTimeout = timeout;
    }

    public boolean isResultActive(@Nonnull AuthenticationResult result) {
        Constraint.isNotNull((Object)result, (String)"AuthenticationResult cannot be null");
        Constraint.isTrue((boolean)result.getAuthenticationFlowId().equals(this.getId()), (String)"AuthenticationResult was not produced by this flow");
        Instant now = Instant.now();
        if (this.getLifetime() != null && now.isAfter(result.getAuthenticationInstant().plus(this.getLifetime()))) {
            return false;
        }
        return !now.isAfter(result.getLastActivityInstant().plus(this.getInactivityTimeout()));
    }

    @Override
    @Nonnull
    @NonnullElements
    @Unmodifiable
    public <T extends Principal> Set<T> getSupportedPrincipals(@Nonnull Class<T> c) {
        return this.supportedPrincipals.getPrincipals(c);
    }

    @Nonnull
    @NonnullElements
    public Collection<Principal> getSupportedPrincipals() {
        return this.supportedPrincipals.getPrincipals();
    }

    public void setSupportedPrincipals(@Nonnull @NonnullElements Collection<Principal> principals) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(principals, (String)"Principal collection cannot be null.");
        this.supportedPrincipals.getPrincipals().clear();
        this.supportedPrincipals.getPrincipals().addAll(Set.copyOf(principals));
    }

    public void setSupportedPrincipalsByString(@Nonnull @NonnullElements Collection<String> principals) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.stringBasedPrincipals = Set.copyOf(StringSupport.normalizeStringCollection(principals));
    }

    public void setActivationCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.activationCondition = (Predicate)Constraint.isNotNull(condition, (String)"Activation condition predicate cannot be null");
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext input) {
        return this.activationCondition.test(input);
    }

    public void setResultSerializer(@Nonnull StorageSerializer<AuthenticationResult> serializer) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.resultSerializer = (StorageSerializer)Constraint.isNotNull(serializer, (String)"StorageSerializer cannot be null");
    }

    public void setPrincipalWeightMap(@Nullable @NonnullElements Map<Principal, Integer> map) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.principalWeightMap = map != null ? map : Collections.emptyMap();
    }

    public void setPrincipalServiceManager(@Nullable PrincipalServiceManager manager) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.principalServiceManager = manager;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.resultSerializer == null) {
            throw new ComponentInitializationException("AuthenticationResult serializer cannot be null");
        }
        if (!this.stringBasedPrincipals.isEmpty()) {
            if (this.principalServiceManager == null) {
                throw new ComponentInitializationException("PrincipalServiceManager cannot be null");
            }
            this.supportedPrincipals.getPrincipals().clear();
            this.stringBasedPrincipals.forEach(v -> {
                Principal p = this.principalServiceManager.principalFromString((String)v);
                if (p != null) {
                    this.supportedPrincipals.getPrincipals().add(p);
                }
            });
        }
    }

    @Nonnull
    public AuthenticationResult newAuthenticationResult(@Nonnull Subject subject) {
        AuthenticationResult result = new AuthenticationResult(this.getId(), subject);
        if (this.proxyRestrictionsEnforced) {
            result.setReuseCondition((Predicate<ProfileRequestContext>)PredicateSupport.and(this.reuseCondition, (Predicate)result.new AuthenticationResult.ProxyRestrictionReusePredicate()));
        } else {
            result.setReuseCondition(this.reuseCondition);
        }
        result.setRevocationCondition(this.revocationCondition);
        return result;
    }

    @Nonnull
    @NotEmpty
    public String serialize(@Nonnull AuthenticationResult instance) throws IOException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        return this.resultSerializer.serialize((Object)instance);
    }

    @Nonnull
    public AuthenticationResult deserialize(long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nonnull Long expiration) throws IOException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        AuthenticationResult result = (AuthenticationResult)this.resultSerializer.deserialize(version, context, key, value, expiration != null ? Long.valueOf(expiration - this.inactivityTimeout.toMillis() - STORAGE_EXPIRATION_OFFSET.toMillis()) : null);
        if (this.proxyRestrictionsEnforced) {
            result.setReuseCondition((Predicate<ProfileRequestContext>)PredicateSupport.and(this.reuseCondition, (Predicate)result.new AuthenticationResult.ProxyRestrictionReusePredicate()));
        } else {
            result.setReuseCondition(this.reuseCondition);
        }
        result.setRevocationCondition(this.revocationCondition);
        return result;
    }

    @Nullable
    public <T extends Principal> T getHighestWeighted(@Nonnull @NonnullElements Collection<T> principals) {
        if (principals.isEmpty()) {
            return null;
        }
        if (this.principalWeightMap.isEmpty() || principals.size() == 1) {
            return (T)((Principal)principals.iterator().next());
        }
        Object[] principalArray = principals.toArray();
        Arrays.sort(principalArray, new WeightedComparator());
        return (T)((Principal)principalArray[principalArray.length - 1]);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof AuthenticationFlowDescriptor) {
            return this.getId().equals(((AuthenticationFlowDescriptor)obj).getId());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("flowId", (Object)this.getId()).add("supportsPassive", this.supportsPassive).add("supportsForcedAuthentication", this.supportsForced).add("lifetime", (Object)this.lifetime).add("inactivityTimeout", (Object)this.inactivityTimeout).toString();
    }

    private class ProxyCountPredicate
    implements Predicate<ProfileRequestContext> {
        private ProxyCountPredicate() {
        }

        @Override
        public boolean test(@Nullable ProfileRequestContext input) {
            AuthenticationContext authnCtx;
            return !AuthenticationFlowDescriptor.this.proxyScopingEnforced || (authnCtx = (AuthenticationContext)input.getSubcontext(AuthenticationContext.class)) == null || authnCtx.getProxyCount() == null || authnCtx.getProxyCount() != 0;
        }
    }

    private class WeightedComparator<T>
    implements Comparator<T> {
        private WeightedComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            int weight2;
            int weight1 = AuthenticationFlowDescriptor.this.principalWeightMap.containsKey(o1) ? AuthenticationFlowDescriptor.this.principalWeightMap.get(o1) : 0;
            int n = weight2 = AuthenticationFlowDescriptor.this.principalWeightMap.containsKey(o2) ? AuthenticationFlowDescriptor.this.principalWeightMap.get(o2) : 0;
            if (weight1 < weight2) {
                return -1;
            }
            if (weight1 > weight2) {
                return 1;
            }
            return 0;
        }
    }
}

