/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn;

import com.google.common.base.MoreObjects;
import com.google.common.base.Predicates;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.FlowDescriptor;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

public class SubjectCanonicalizationFlowDescriptor
extends AbstractIdentifiableInitializableComponent
implements FlowDescriptor,
Predicate<ProfileRequestContext> {
    @Nonnull
    private Predicate<ProfileRequestContext> activationCondition = Predicates.alwaysTrue();

    public void setActivationCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.activationCondition = (Predicate)Constraint.isNotNull(condition, (String)"Activation condition predicate cannot be null");
    }

    @Override
    public boolean test(ProfileRequestContext input) {
        return this.activationCondition.test(input);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof SubjectCanonicalizationFlowDescriptor) {
            return this.getId().equals(((SubjectCanonicalizationFlowDescriptor)obj).getId());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("flowId", (Object)this.getId()).toString();
    }
}

