/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.context;

import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;

public final class CertificateContext
extends BaseContext {
    @Nullable
    private Certificate certificate;
    @Nonnull
    @NonnullElements
    private Collection<Certificate> intermediates = new ArrayList<Certificate>();

    @Nullable
    public Certificate getCertificate() {
        return this.certificate;
    }

    @Nonnull
    public CertificateContext setCertificate(@Nullable Certificate cert) {
        this.certificate = cert;
        return this;
    }

    @Nonnull
    @NonnullElements
    @Live
    public Collection<Certificate> getIntermediates() {
        return this.intermediates;
    }

    @Nonnull
    public CertificateContext setIntermediates(@Nonnull @NonnullElements Collection<Certificate> certs) {
        Constraint.isNotNull(certs, (String)"Intermediate certificate collection cannot be null");
        this.intermediates.clear();
        this.intermediates.addAll(List.copyOf(certs));
        return this;
    }
}

