/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.duo;

import java.security.Principal;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.duo.DuoIntegration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public class BasicDuoIntegration
extends AbstractInitializableComponent
implements DuoIntegration {
    @NonnullAfterInit
    @NotEmpty
    private String apiHost;
    @Nullable
    @NotEmpty
    private String applicationKey;
    @NonnullAfterInit
    @NotEmpty
    private String integrationKey;
    @NonnullAfterInit
    @NotEmpty
    private String secretKey;
    @Nonnull
    private final Subject supportedPrincipals = new Subject();

    @Override
    @Nonnull
    @NotEmpty
    public String getAPIHost() {
        return this.apiHost;
    }

    public void setAPIHost(@Nonnull @NotEmpty String host) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.apiHost = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)host), (String)"API host cannot be null or empty");
    }

    @Override
    @Nullable
    @NotEmpty
    public String getApplicationKey() {
        return this.applicationKey;
    }

    public void setApplicationKey(@Nullable @NotEmpty String key) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.applicationKey = StringSupport.trimOrNull((String)key);
    }

    @Override
    @Nonnull
    @NotEmpty
    public String getIntegrationKey() {
        return this.integrationKey;
    }

    public void setIntegrationKey(@Nonnull @NotEmpty String key) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.integrationKey = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)key), (String)"Integration key cannot be null or empty");
    }

    @Override
    @Nonnull
    @NotEmpty
    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(@Nonnull @NotEmpty String key) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.secretKey = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)key), (String)"Secret key cannot be null or empty");
    }

    @Override
    @Nonnull
    @NonnullElements
    @Unmodifiable
    public <T extends Principal> Set<T> getSupportedPrincipals(@Nonnull Class<T> c) {
        return this.supportedPrincipals.getPrincipals(c);
    }

    public <T extends Principal> void setSupportedPrincipals(@Nullable @NonnullElements Collection<T> principals) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.supportedPrincipals.getPrincipals().clear();
        if (principals != null && !principals.isEmpty()) {
            this.supportedPrincipals.getPrincipals().addAll(Set.copyOf(principals));
        }
    }

    protected void doInitialize() throws ComponentInitializationException {
        if (this.apiHost == null || this.integrationKey == null || this.secretKey == null) {
            throw new ComponentInitializationException("API host and integration keys must be set");
        }
    }
}

