/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal;

import com.google.common.base.MoreObjects;
import java.security.Principal;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;

public class AuthenticationResultPrincipal
implements Principal {
    @Nonnull
    private AuthenticationResult authnResult;

    public AuthenticationResultPrincipal(@Nonnull @ParameterName(name="result") AuthenticationResult result) {
        this.authnResult = (AuthenticationResult)Constraint.isNotNull((Object)result, (String)"AuthenticationResult cannot be null");
    }

    @Override
    @Nonnull
    @NotEmpty
    public String getName() {
        return this.authnResult.getAuthenticationFlowId();
    }

    @Nonnull
    public AuthenticationResult getAuthenticationResult() {
        return this.authnResult;
    }

    @Override
    public int hashCode() {
        return this.authnResult.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof AuthenticationResultPrincipal) {
            return this.authnResult.equals(((AuthenticationResultPrincipal)other).getAuthenticationResult());
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("authnResult", (Object)this.authnResult).toString();
    }
}

