/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal;

import java.security.Principal;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicateFactory;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicateFactoryRegistration;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public final class PrincipalEvalPredicateFactoryRegistry {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PrincipalEvalPredicateFactoryRegistry.class);
    @Nonnull
    @NonnullElements
    private Map<Pair<Class<? extends Principal>, String>, PrincipalEvalPredicateFactory> registry;

    public PrincipalEvalPredicateFactoryRegistry() {
        this.registry = new ConcurrentHashMap<Pair<Class<? extends Principal>, String>, PrincipalEvalPredicateFactory>();
    }

    @Autowired
    public PrincipalEvalPredicateFactoryRegistry(@Nullable @ParameterName(name="registrations") @NonnullElements Collection<PrincipalEvalPredicateFactoryRegistration> registrations) {
        this.registry = new ConcurrentHashMap<Pair<Class<? extends Principal>, String>, PrincipalEvalPredicateFactory>();
        if (registrations != null) {
            this.log.debug("Auto-wiring {} registration(s)", (Object)registrations.size());
            registrations.forEach(r -> this.registry.put(r.getTypeAndOperator(), r.getPredicateFactory()));
        }
    }

    @Deprecated(since="4.1.0", forRemoval=true)
    public PrincipalEvalPredicateFactoryRegistry(@Nonnull @ParameterName(name="fromMap") @NonnullElements Map<Pair<Class<? extends Principal>, String>, PrincipalEvalPredicateFactory> fromMap) {
        this.registry = new ConcurrentHashMap<Pair<Class<? extends Principal>, String>, PrincipalEvalPredicateFactory>((Map)Constraint.isNotNull(fromMap, (String)"Source map cannot be null"));
    }

    public void setRegistrations(@Nullable @NonnullElements Map<Pair<Class<? extends Principal>, String>, PrincipalEvalPredicateFactory> fromMap) {
        if (fromMap != null) {
            fromMap.entrySet().forEach(entry -> {
                if (this.registry.containsKey(entry.getKey())) {
                    this.log.info("Replacing auto-wired entry for principal type '{}' and operator '{}'", (Object)((Class)((Pair)entry.getKey()).getFirst()).getName(), ((Pair)entry.getKey()).getSecond());
                }
                this.registry.put((Pair<Class<? extends Principal>, String>)((Pair)entry.getKey()), (PrincipalEvalPredicateFactory)entry.getValue());
            });
        }
    }

    @Nullable
    public PrincipalEvalPredicateFactory lookup(@Nonnull Class<? extends Principal> principalType, @Nonnull @NotEmpty String operator) {
        Constraint.isNotNull(principalType, (String)"Principal subtype cannot be null");
        String trimmed = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)operator), (String)"Operator cannot be null or empty");
        Pair key = new Pair(principalType, (Object)trimmed);
        PrincipalEvalPredicateFactory factory = this.registry.get(key);
        if (factory != null) {
            this.log.debug("Registry located predicate factory of type '{}' for principal type '{}' and operator '{}'", new Object[]{factory.getClass().getName(), principalType, trimmed});
            return factory;
        }
        this.log.debug("Registry failed to locate predicate factory for principal type '{}' and operator '{}'", principalType, (Object)trimmed);
        return null;
    }

    public void register(@Nonnull Class<? extends Principal> principalType, @Nonnull @NotEmpty String operator, @Nonnull PrincipalEvalPredicateFactory factory) {
        Constraint.isNotNull(principalType, (String)"Principal subtype cannot be null");
        String trimmed = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)operator), (String)"Operator cannot be null or empty");
        Constraint.isNotNull((Object)factory, (String)"PrincipalEvalPredicateFactory cannot be null");
        this.log.debug("Registering predicate factory of type '{}' for principal type '{}' and operator '{}'", new Object[]{factory.getClass().getName(), principalType, operator});
        this.registry.put((Pair<Class<? extends Principal>, String>)new Pair(principalType, (Object)trimmed), factory);
    }

    public void deregister(@Nonnull Class<? extends Principal> principalType, @Nonnull @NotEmpty String operator) {
        Constraint.isNotNull(principalType, (String)"Principal subtype cannot be null");
        String trimmed = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)operator), (String)"Operator cannot be null or empty");
        this.log.debug("Deregistering predicate factory for principal type '{}' and operator '{}'", principalType, (Object)operator);
        this.registry.remove(new Pair(principalType, (Object)trimmed));
    }
}

