/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.SubjectCanonicalizationException;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public abstract class AbstractSubjectCanonicalizationAction
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractSubjectCanonicalizationAction.class);
    @Nonnull
    private Function<ProfileRequestContext, SubjectCanonicalizationContext> scCtxLookupStrategy = new ChildContextLookup(SubjectCanonicalizationContext.class, false);
    @NonnullBeforeExec
    private SubjectCanonicalizationContext scContext;
    @Nonnull
    private List<Pair<Pattern, String>> transforms = CollectionSupport.emptyList();
    private boolean uppercase = false;
    private boolean lowercase = false;
    private boolean trim = false;

    @Nonnull
    private SubjectCanonicalizationContext getSubjectCanonicalizationContext() {
        assert (this.isPreExecuteCalled());
        return this.scContext;
    }

    public void setLookupStrategy(@Nonnull Function<ProfileRequestContext, SubjectCanonicalizationContext> strategy) {
        this.checkSetterPreconditions();
        this.scCtxLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Strategy cannot be null");
    }

    public void setTransforms(@Nullable Collection<Pair<String, String>> newTransforms) {
        this.checkSetterPreconditions();
        if (newTransforms != null) {
            this.transforms = new ArrayList<Pair<Pattern, String>>();
            for (Pair<String, String> p : newTransforms) {
                Pattern pattern = Pattern.compile(StringSupport.trimOrNull((String)((String)p.getFirst())));
                this.transforms.add((Pair<Pattern, String>)new Pair((Object)pattern, (Object)((String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)((String)p.getSecond())), (String)"Replacement expression cannot be null"))));
            }
        } else {
            this.transforms = CollectionSupport.emptyList();
        }
    }

    public void setUppercase(boolean flag) {
        this.checkSetterPreconditions();
        this.uppercase = flag;
    }

    public void setLowercase(boolean flag) {
        this.checkSetterPreconditions();
        this.lowercase = flag;
    }

    public void setTrim(boolean flag) {
        this.checkSetterPreconditions();
        this.trim = flag;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (super.doPreExecute(profileRequestContext)) {
            this.scContext = this.scCtxLookupStrategy.apply(profileRequestContext);
            SubjectCanonicalizationContext sc = this.scContext;
            if (sc == null) {
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubjectCanonicalizationContext");
                return false;
            }
            return this.doPreExecute(profileRequestContext, sc);
        }
        return false;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext) {
        if (c14nContext.getSubject() == null) {
            c14nContext.setException(new SubjectCanonicalizationException("No Subject found in context"));
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubject");
            return false;
        }
        return true;
    }

    protected final void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.doExecute(profileRequestContext, this.getSubjectCanonicalizationContext());
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext) {
    }

    @Nonnull
    @NotEmpty
    protected String applyTransforms(@Nonnull @NotEmpty String input) {
        String s = input;
        if (this.trim) {
            this.log.debug("{} trimming whitespace of input string '{}'", (Object)this.getLogPrefix(), (Object)s);
            s = s.trim();
        }
        if (this.lowercase) {
            this.log.debug("{} converting input string '{}' to lowercase", (Object)this.getLogPrefix(), (Object)s);
            s = s.toLowerCase();
        } else if (this.uppercase) {
            this.log.debug("{} converting input string '{}' to uppercase", (Object)this.getLogPrefix(), (Object)s);
            s = s.toUpperCase();
        }
        for (Pair<Pattern, String> p : this.transforms) {
            Pattern pattern = (Pattern)p.getFirst();
            if (pattern == null) continue;
            Matcher m = pattern.matcher(s);
            this.log.debug("{} applying replacement expression '{}' against input '{}'", new Object[]{this.getLogPrefix(), pattern.pattern(), s});
            s = m.replaceAll((String)p.getSecond());
            this.log.debug("{} result of replacement is '{}'", (Object)this.getLogPrefix(), (Object)s);
        }
        assert (s != null);
        return s;
    }
}

