/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.AuthenticationErrorContext;
import net.shibboleth.idp.authn.context.AuthenticationWarningContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicate;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicateFactory;
import net.shibboleth.idp.authn.principal.PrincipalSupportingComponent;
import net.shibboleth.profile.context.navigate.IssuerLookupFunction;
import net.shibboleth.profile.context.navigate.RelyingPartyIdLookupFunction;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.core.metrics.MetricsSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public abstract class AbstractValidationAction
extends AbstractAuthenticationAction
implements PrincipalSupportingComponent {
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_METRIC_NAME = "net.shibboleth.idp.authn.validation";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractValidationAction.class);
    @Nonnull
    @NotEmpty
    private String metricName = "net.shibboleth.idp.authn.validation";
    @Nonnull
    private final Subject authenticatedSubject = new Subject();
    private boolean addDefaultPrincipals = true;
    private boolean clearErrorContext = true;
    @Nullable
    private Consumer<ProfileRequestContext> cleanupHook;
    @Nonnull
    private Map<String, Collection<String>> classifiedMessages = CollectionSupport.emptyMap();
    @Nullable
    private Predicate<ProfileRequestContext> resultCachingPredicate;
    @Nullable
    private Function<ProfileRequestContext, String> requesterLookupStrategy = new RelyingPartyIdLookupFunction();
    @Nullable
    private Function<ProfileRequestContext, String> responderLookupStrategy = new IssuerLookupFunction();

    @Nonnull
    @NotEmpty
    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(@Nonnull @NotEmpty String name) {
        this.checkSetterPreconditions();
        this.metricName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Metric name cannot be null or empty");
    }

    public boolean addDefaultPrincipals() {
        return this.addDefaultPrincipals;
    }

    public void setAddDefaultPrincipals(boolean flag) {
        this.checkSetterPreconditions();
        this.addDefaultPrincipals = flag;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Map<String, Collection<String>> getClassifiedErrors() {
        Map<String, Collection<String>> result = Collections.unmodifiableMap(this.classifiedMessages);
        assert (result != null);
        return result;
    }

    public void setClassifiedMessages(@Nullable Map<String, Collection<String>> messages) {
        this.checkSetterPreconditions();
        if (messages != null) {
            this.classifiedMessages = new LinkedHashMap<String, Collection<String>>();
            for (Map.Entry<String, Collection<String>> entry : messages.entrySet()) {
                if (entry.getKey() == null || entry.getKey().isEmpty() || entry.getValue() == null || entry.getValue().isEmpty()) continue;
                this.classifiedMessages.put(entry.getKey(), CollectionSupport.copyToList(entry.getValue()));
            }
        } else {
            this.classifiedMessages = CollectionSupport.emptyMap();
        }
    }

    @Nullable
    public Predicate<ProfileRequestContext> getResultCachingPredicate() {
        return this.resultCachingPredicate;
    }

    public void setResultCachingPredicate(@Nullable Predicate<ProfileRequestContext> predicate) {
        this.checkSetterPreconditions();
        this.resultCachingPredicate = predicate;
    }

    @Nullable
    public Consumer<ProfileRequestContext> getCleanupHook() {
        return this.cleanupHook;
    }

    public void setCleanupHook(@Nullable Consumer<ProfileRequestContext> hook) {
        this.checkSetterPreconditions();
        this.cleanupHook = hook;
    }

    @Nullable
    public Function<ProfileRequestContext, String> getRequesterLookupStrategy() {
        return this.requesterLookupStrategy;
    }

    public void setRequesterLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.requesterLookupStrategy = strategy;
    }

    @Nullable
    public Function<ProfileRequestContext, String> getResponderLookupStrategy() {
        return this.responderLookupStrategy;
    }

    public void setResponderLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.responderLookupStrategy = strategy;
    }

    @Override
    @Nonnull
    @Unmodifiable
    @NotLive
    public <T extends Principal> Set<T> getSupportedPrincipals(@Nonnull Class<T> c) {
        Set<T> result = this.getSubject().getPrincipals(c);
        assert (result != null);
        return result;
    }

    public void setSupportedPrincipals(@Nullable Collection<Principal> principals) {
        this.checkSetterPreconditions();
        this.getSubject().getPrincipals().clear();
        if (principals != null && !principals.isEmpty()) {
            this.getSubject().getPrincipals().addAll(Set.copyOf(principals));
        }
    }

    @Nonnull
    protected Subject getSubject() {
        return this.authenticatedSubject;
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        String fixedEvent;
        String operator;
        RequestedPrincipalContext rpCtx;
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        if (authenticationContext.getAttemptedFlow() == null) {
            this.log.info("{} No attempted flow within authentication context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
            return false;
        }
        if (this.clearErrorContext) {
            authenticationContext.removeSubcontext(AuthenticationErrorContext.class);
        }
        if ((rpCtx = (RequestedPrincipalContext)authenticationContext.getSubcontext(RequestedPrincipalContext.class)) != null && !this.getSubject().getPrincipals().isEmpty() && (operator = rpCtx.getOperator()) != null) {
            this.log.debug("{} Request contains principal requirements, evaluating for compatibility", (Object)this.getLogPrefix());
            for (Principal p : rpCtx.getRequestedPrincipals()) {
                PrincipalEvalPredicateFactory factory = rpCtx.getPrincipalEvalPredicateFactoryRegistry().lookup(p.getClass(), operator);
                if (factory != null) {
                    PrincipalEvalPredicate predicate = factory.getPredicate(p);
                    if (predicate.test(this)) {
                        this.log.debug("{} Compatible with principal type '{}' and operator '{}'", new Object[]{this.getLogPrefix(), p.getClass(), operator});
                        rpCtx.setMatchingPrincipal(predicate.getMatchingPrincipal());
                        return true;
                    }
                    this.log.debug("{} Not compatible with principal type '{}' and operator '{}'", new Object[]{this.getLogPrefix(), p.getClass(), operator});
                    continue;
                }
                this.log.debug("{} No comparison logic registered for principal type '{}' and operator '{}'", new Object[]{this.getLogPrefix(), p.getClass(), operator});
            }
            this.log.info("{} Skipping validator, not compatible with request's principal requirements", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"RequestUnsupported");
            return false;
        }
        Function<ProfileRequestContext, String> strategy = authenticationContext.getFixedEventLookupStrategy();
        if (strategy != null && (fixedEvent = strategy.apply(profileRequestContext)) != null) {
            this.log.info("{} Signaling fixed event: {}", (Object)this.getLogPrefix(), (Object)fixedEvent);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)fixedEvent);
            return false;
        }
        return true;
    }

    protected void buildAuthenticationResult(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        BiConsumer<ProfileRequestContext, Subject> decorator;
        AuthenticationFlowDescriptor attemptedFlow = authenticationContext.getAttemptedFlow();
        assert (attemptedFlow != null);
        if (this.addDefaultPrincipals) {
            this.log.debug("{} Adding custom Principal(s) defined on underlying flow descriptor", (Object)this.getLogPrefix());
            this.getSubject().getPrincipals().addAll(attemptedFlow.getSupportedPrincipals());
        }
        AuthenticationResult result = attemptedFlow.newAuthenticationResult(this.populateSubject(this.getSubject()));
        authenticationContext.setAuthenticationResult(result);
        if (authenticationContext.isResultCacheable() && this.resultCachingPredicate != null) {
            authenticationContext.setResultCacheable(this.resultCachingPredicate.test(profileRequestContext));
            this.log.info("{} Predicate indicates authentication result {} be cacheable in a session", (Object)this.getLogPrefix(), (Object)(authenticationContext.isResultCacheable() ? "will" : "will not"));
        }
        if ((decorator = attemptedFlow.getSubjectDecorator()) != null) {
            decorator.accept(profileRequestContext, result.getSubject());
        }
        SubjectCanonicalizationContext c14n = new SubjectCanonicalizationContext();
        c14n.setSubject(result.getSubject());
        if (this.requesterLookupStrategy != null) {
            c14n.setRequesterId(this.requesterLookupStrategy.apply(profileRequestContext));
        }
        if (this.responderLookupStrategy != null) {
            c14n.setResponderId(this.responderLookupStrategy.apply(profileRequestContext));
        }
        ((BaseContext)Constraint.isNotNull((Object)authenticationContext.getParent(), (String)"Parent context cannot be null")).addSubcontext((BaseContext)c14n, true);
    }

    @Nonnull
    protected abstract Subject populateSubject(@Nonnull Subject var1);

    protected void recordSuccess(@Nonnull ProfileRequestContext profileRequestContext) {
        MetricRegistry registry = MetricsSupport.getMetricRegistry();
        if (registry != null) {
            registry.counter(this.getMetricName() + ".successes").inc();
        }
        if (this.cleanupHook != null) {
            this.cleanupHook.accept(profileRequestContext);
        }
    }

    protected void recordFailure(@Nonnull ProfileRequestContext profileRequestContext) {
        MetricRegistry registry = MetricsSupport.getMetricRegistry();
        if (registry != null) {
            registry.counter(this.getMetricName() + ".failures").inc();
        }
    }

    protected void handleError(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nonnull Exception e, @Nonnull @NotEmpty String eventId) {
        ((AuthenticationErrorContext)authenticationContext.ensureSubcontext(AuthenticationErrorContext.class)).getExceptions().add(e);
        this.handleError(profileRequestContext, authenticationContext, e.getMessage(), eventId);
    }

    protected void handleError(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nullable String message, @Nonnull @NotEmpty String eventId) {
        boolean eventSet = false;
        if (!Strings.isNullOrEmpty((String)message)) {
            assert (message != null);
            MessageChecker checker = new MessageChecker(message);
            for (Map.Entry<String, Collection<String>> entry : this.classifiedMessages.entrySet()) {
                if (!Iterables.any((Iterable)entry.getValue(), checker::test)) continue;
                String key = entry.getKey();
                assert (key != null);
                ((AuthenticationErrorContext)authenticationContext.ensureSubcontext(AuthenticationErrorContext.class)).addClassifiedError(key);
                if (eventSet) continue;
                eventSet = true;
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)key);
            }
        }
        if (!eventSet) {
            ((AuthenticationErrorContext)authenticationContext.ensureSubcontext(AuthenticationErrorContext.class)).addClassifiedError(eventId);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)eventId);
        }
    }

    protected void handleWarning(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nullable String message, @Nonnull @NotEmpty String eventId) {
        boolean eventSet = false;
        if (!Strings.isNullOrEmpty((String)message)) {
            assert (message != null);
            MessageChecker checker = new MessageChecker(message);
            for (Map.Entry<String, Collection<String>> entry : this.classifiedMessages.entrySet()) {
                if (!Iterables.any((Iterable)entry.getValue(), checker::test)) continue;
                String key = entry.getKey();
                assert (key != null);
                ((AuthenticationWarningContext)authenticationContext.ensureSubcontext(AuthenticationWarningContext.class)).addClassifiedWarning(key);
                if (eventSet) continue;
                eventSet = true;
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)key);
            }
        }
        if (!eventSet) {
            ((AuthenticationWarningContext)authenticationContext.ensureSubcontext(AuthenticationWarningContext.class)).addClassifiedWarning(eventId);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)eventId);
        }
    }

    private class MessageChecker
    implements Predicate<String> {
        @Nonnull
        @NotEmpty
        private final String s;

        public MessageChecker(String msg) {
            Constraint.isFalse((boolean)Strings.isNullOrEmpty((String)msg), (String)"Message cannot be null or empty");
            this.s = msg;
        }

        @Override
        public boolean test(String input) {
            return this.s.contains(input);
        }
    }
}

