/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.config;

import com.google.common.base.MoreObjects;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.time.Period;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.TemplateSearchDnResolver;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.velocity.app.VelocityEngine;
import org.ldaptive.ActivePassiveConnectionStrategy;
import org.ldaptive.BindConnectionInitializer;
import org.ldaptive.BindRequest;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.ConnectionInitializer;
import org.ldaptive.ConnectionStrategy;
import org.ldaptive.ConnectionValidator;
import org.ldaptive.Credential;
import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.FilterTemplate;
import org.ldaptive.PooledConnectionFactory;
import org.ldaptive.RandomConnectionStrategy;
import org.ldaptive.Request;
import org.ldaptive.RoundRobinConnectionStrategy;
import org.ldaptive.SearchConnectionValidator;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchScope;
import org.ldaptive.SimpleBindRequest;
import org.ldaptive.auth.AuthenticationHandler;
import org.ldaptive.auth.AuthenticationRequestHandler;
import org.ldaptive.auth.AuthenticationResponseHandler;
import org.ldaptive.auth.Authenticator;
import org.ldaptive.auth.DnResolver;
import org.ldaptive.auth.EntryResolver;
import org.ldaptive.auth.FormatDnResolver;
import org.ldaptive.auth.SearchEntryResolver;
import org.ldaptive.auth.SimpleBindAuthenticationHandler;
import org.ldaptive.auth.ext.ActiveDirectoryAuthenticationResponseHandler;
import org.ldaptive.auth.ext.EDirectoryAuthenticationResponseHandler;
import org.ldaptive.auth.ext.FreeIPAAuthenticationResponseHandler;
import org.ldaptive.auth.ext.PasswordExpirationAuthenticationResponseHandler;
import org.ldaptive.auth.ext.PasswordPolicyAuthenticationRequestHandler;
import org.ldaptive.auth.ext.PasswordPolicyAuthenticationResponseHandler;
import org.ldaptive.pool.BindConnectionPassivator;
import org.ldaptive.pool.ConnectionPassivator;
import org.ldaptive.pool.IdlePruneStrategy;
import org.ldaptive.pool.PruneStrategy;
import org.ldaptive.ssl.AllowAnyHostnameVerifier;
import org.ldaptive.ssl.CertificateHostnameVerifier;
import org.ldaptive.ssl.CredentialConfig;
import org.ldaptive.ssl.SslConfig;
import org.slf4j.Logger;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class LDAPAuthenticationFactoryBean
extends AbstractFactoryBean<Authenticator> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(LDAPAuthenticationFactoryBean.class);
    private AuthenticatorType authenticatorType;
    private TrustType trustType;
    private ConnectionStrategyType connectionStrategyType;
    private String ldapUrl;
    private boolean useStartTLS;
    private Duration startTLSTimeout;
    private boolean disableHostnameVerification;
    private Duration connectTimeout;
    private Duration responseTimeout;
    private boolean autoReconnect;
    private Duration reconnectTimeout;
    private CredentialConfig trustCertificatesCredentialConfig;
    private CredentialConfig truststoreCredentialConfig;
    private boolean disablePooling;
    private Duration blockWaitTime;
    private int minPoolSize;
    private int maxPoolSize;
    private boolean validateOnCheckout;
    private boolean validatePeriodically;
    private Duration validatePeriod;
    private String validateDn;
    private String validateFilter;
    private PassivatorType bindPoolPassivatorType;
    private Duration prunePeriod;
    private Duration idleTime;
    private String dnFormat;
    private String baseDn;
    private String userFilter;
    private boolean subtreeSearch;
    private boolean resolveEntryOnFailure;
    private boolean resolveEntryWithBindDn;
    private VelocityEngine velocityEngine;
    private String bindDn;
    private String bindDnCredential;
    private boolean usePasswordPolicy;
    private boolean usePasswordExpiration;
    private boolean isActiveDirectory;
    private boolean isFreeIPA;
    private boolean isEDirectory;
    private Period accountStateExpirationPeriod;
    private Period accountStateWarningPeriod;
    private int accountStateLoginFailures;

    public void setAuthenticatorType(@Nonnull @NotEmpty String type) {
        this.authenticatorType = AuthenticatorType.fromLabel(type);
        if (this.authenticatorType == null) {
            throw new IllegalArgumentException("authenticatorType property did not have a valid value");
        }
    }

    public void setTrustType(@Nonnull @NotEmpty String type) {
        this.trustType = TrustType.fromLabel(type);
        if (this.trustType == null) {
            throw new IllegalArgumentException("trustType property did not have a valid value");
        }
    }

    public void setConnectionStrategyType(@Nonnull @NotEmpty String type) {
        this.connectionStrategyType = ConnectionStrategyType.fromLabel(type);
        if (this.connectionStrategyType == null) {
            throw new IllegalArgumentException("connectionStrategyType property did not have a valid value");
        }
    }

    public void setLdapUrl(@Nullable @NotEmpty String url) {
        this.ldapUrl = url;
    }

    public void setUseStartTLS(boolean b) {
        this.useStartTLS = b;
    }

    public void setStartTLSTimeout(@Nullable Duration timeout) {
        this.startTLSTimeout = timeout;
    }

    public void setDisableHostnameVerification(boolean b) {
        this.disableHostnameVerification = b;
    }

    public void setConnectTimeout(@Nullable Duration timeout) {
        this.connectTimeout = timeout;
    }

    public void setResponseTimeout(@Nullable Duration timeout) {
        this.responseTimeout = timeout;
    }

    public void setAutoReconnect(boolean b) {
        this.autoReconnect = b;
    }

    public void setReconnectTimeout(@Nullable Duration timeout) {
        this.reconnectTimeout = timeout;
    }

    public void setTrustCertificatesCredentialConfig(CredentialConfig config) {
        this.trustCertificatesCredentialConfig = config;
    }

    public void setTruststoreCredentialConfig(CredentialConfig config) {
        this.truststoreCredentialConfig = config;
    }

    public void setDisablePooling(boolean b) {
        this.disablePooling = b;
    }

    public void setBlockWaitTime(@Nullable Duration time) {
        this.blockWaitTime = time;
    }

    public void setMinPoolSize(int size) {
        this.minPoolSize = size;
    }

    public void setMaxPoolSize(int size) {
        this.maxPoolSize = size;
    }

    public void setValidateOnCheckout(boolean b) {
        this.validateOnCheckout = b;
    }

    public void setValidatePeriodically(boolean b) {
        this.validatePeriodically = b;
    }

    public void setValidatePeriod(@Nullable Duration period) {
        this.validatePeriod = period;
    }

    public void setValidateDn(String dn) {
        this.validateDn = dn;
    }

    public void setValidateFilter(String filter) {
        this.validateFilter = filter;
    }

    public void setBindPoolPassivatorType(@Nonnull @NotEmpty String type) {
        this.bindPoolPassivatorType = PassivatorType.fromLabel(type);
        if (this.bindPoolPassivatorType == null) {
            throw new IllegalArgumentException("bindPoolPassivatorType property did not have a valid value");
        }
    }

    public void setPrunePeriod(@Nullable Duration period) {
        this.prunePeriod = period;
    }

    public void setIdleTime(@Nullable Duration time) {
        this.idleTime = time;
    }

    public void setDnFormat(String format) {
        this.dnFormat = format;
    }

    public void setBaseDn(String dn) {
        this.baseDn = dn;
    }

    public void setUserFilter(String filter) {
        this.userFilter = filter;
    }

    @Nonnull
    private String getUserFilter() {
        return (String)Constraint.isNotNull((Object)this.userFilter, (String)"p:userFilter must be specified");
    }

    public void setSubtreeSearch(boolean b) {
        this.subtreeSearch = b;
    }

    public void setResolveEntryOnFailure(boolean b) {
        this.resolveEntryOnFailure = b;
    }

    public void setResolveEntryWithBindDn(boolean b) {
        this.resolveEntryWithBindDn = b;
    }

    public void setVelocityEngine(VelocityEngine engine) {
        this.velocityEngine = engine;
    }

    @Nonnull
    private VelocityEngine getVelocityEngine() {
        return (VelocityEngine)Constraint.isNotNull((Object)this.velocityEngine, (String)"p:velocityEngine must be specified");
    }

    public void setBindDn(String dn) {
        this.bindDn = dn;
    }

    public void setBindDnCredential(String credential) {
        this.bindDnCredential = credential;
    }

    public void setUsePasswordPolicy(boolean b) {
        this.usePasswordPolicy = b;
    }

    public void setUsePasswordExpiration(boolean b) {
        this.usePasswordExpiration = b;
    }

    public void setActiveDirectory(boolean b) {
        this.isActiveDirectory = b;
    }

    public void setFreeIPA(boolean b) {
        this.isFreeIPA = b;
    }

    public void setEDirectory(boolean b) {
        this.isEDirectory = b;
    }

    public void setAccountStateExpirationPeriod(@Nullable Period period) {
        this.accountStateExpirationPeriod = period;
    }

    public void setAccountStateWarningPeriod(@Nullable Period period) {
        this.accountStateWarningPeriod = period;
    }

    public void setAccountStateLoginFailures(int loginFailures) {
        this.accountStateLoginFailures = loginFailures;
    }

    protected SslConfig createSslConfig() {
        SslConfig config = new SslConfig();
        switch (this.trustType) {
            case CERTIFICATE: {
                config.setCredentialConfig(this.trustCertificatesCredentialConfig);
                break;
            }
            case KEYSTORE: {
                config.setCredentialConfig(this.truststoreCredentialConfig);
                break;
            }
            case DISABLED: {
                config.setCredentialConfig(() -> {
                    throw new GeneralSecurityException("SSL/startTLS is disabled");
                });
                break;
            }
        }
        if (this.disableHostnameVerification) {
            this.log.warn("LDAP Authenticator configured to bypass TLS hostname checking!");
            config.setHostnameVerifier((CertificateHostnameVerifier)new AllowAnyHostnameVerifier());
        }
        return config;
    }

    protected ConnectionConfig createConnectionConfig() {
        return this.createConnectionConfig(null);
    }

    protected ConnectionConfig createConnectionConfig(@Nullable ConnectionInitializer initializer) {
        ConnectionConfig config = new ConnectionConfig();
        config.setLdapUrl(this.ldapUrl);
        config.setUseStartTLS(this.useStartTLS);
        config.setStartTLSTimeout(this.startTLSTimeout);
        config.setConnectTimeout(this.connectTimeout);
        config.setResponseTimeout(this.responseTimeout);
        config.setAutoReconnect(this.autoReconnect);
        config.setReconnectTimeout(this.reconnectTimeout);
        switch (this.connectionStrategyType) {
            case ROUND_ROBIN: {
                config.setConnectionStrategy((ConnectionStrategy)new RoundRobinConnectionStrategy());
                break;
            }
            case RANDOM: {
                config.setConnectionStrategy((ConnectionStrategy)new RandomConnectionStrategy());
                break;
            }
            default: {
                config.setConnectionStrategy((ConnectionStrategy)new ActivePassiveConnectionStrategy());
            }
        }
        config.setSslConfig(this.createSslConfig());
        if (initializer != null) {
            config.setConnectionInitializers(new ConnectionInitializer[]{initializer});
        }
        return config;
    }

    protected PooledConnectionFactory createPooledConnectionFactory(String name, ConnectionConfig config) {
        return this.createPooledConnectionFactory(name, config, (SearchConnectionValidator)((SearchConnectionValidator.Builder)SearchConnectionValidator.builder().period(this.validatePeriod)).build());
    }

    protected PooledConnectionFactory createPooledConnectionFactory(String name, ConnectionConfig config, SearchConnectionValidator validator) {
        return this.createPooledConnectionFactory(name, config, validator, null);
    }

    protected PooledConnectionFactory createPooledConnectionFactory(String name, ConnectionConfig config, SearchConnectionValidator validator, ConnectionPassivator passivator) {
        PooledConnectionFactory factory = new PooledConnectionFactory();
        factory.setConnectionConfig(config);
        factory.setMinPoolSize(this.minPoolSize);
        factory.setMaxPoolSize(this.maxPoolSize);
        factory.setValidateOnCheckOut(this.validateOnCheckout);
        factory.setValidatePeriodically(this.validatePeriodically);
        factory.setName(name);
        factory.setBlockWaitTime(this.blockWaitTime);
        factory.setPruneStrategy((PruneStrategy)new IdlePruneStrategy(this.prunePeriod, this.idleTime));
        factory.setValidator((ConnectionValidator)validator);
        if (passivator != null) {
            factory.setPassivator(passivator);
        }
        factory.setFailFastInitialize(false);
        factory.initialize();
        return factory;
    }

    @Nonnull
    protected SearchConnectionValidator createSearchConnectionValidator(@Nullable String baseDn, @Nullable String filter) {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setReturnAttributes(new String[]{"1.1"});
        searchRequest.setSearchScope(SearchScope.OBJECT);
        searchRequest.setSizeLimit(1);
        if (baseDn != null) {
            searchRequest.setBaseDn(baseDn);
        } else {
            searchRequest.setBaseDn("");
        }
        FilterTemplate searchFilter = new FilterTemplate();
        if (filter != null) {
            searchFilter.setFilter(filter);
        } else {
            searchFilter.setFilter("(objectClass=*)");
        }
        searchRequest.setFilter(searchFilter);
        return (SearchConnectionValidator)((SearchConnectionValidator.Builder)((SearchConnectionValidator.Builder)SearchConnectionValidator.builder().request((Request)searchRequest)).period(this.validatePeriod)).build();
    }

    @Nullable
    protected ConnectionPassivator createConnectionPassivator(@Nonnull PassivatorType type) {
        switch (type) {
            case BIND: {
                return new BindConnectionPassivator((BindRequest)new SimpleBindRequest(this.bindDn, new Credential(this.bindDnCredential)));
            }
            case ANONYMOUS_BIND: {
                return new BindConnectionPassivator();
            }
        }
        return null;
    }

    @Nonnull
    protected Authenticator createInstance() throws Exception {
        Authenticator authenticator = new Authenticator();
        if (this.disablePooling) {
            authenticator.setAuthenticationHandler((AuthenticationHandler)new SimpleBindAuthenticationHandler((ConnectionFactory)new DefaultConnectionFactory(this.createConnectionConfig())));
        } else {
            authenticator.setAuthenticationHandler((AuthenticationHandler)new SimpleBindAuthenticationHandler((ConnectionFactory)this.createPooledConnectionFactory("bind-pool", this.createConnectionConfig(), this.createSearchConnectionValidator(this.validateDn, this.validateFilter), this.createConnectionPassivator(this.bindPoolPassivatorType))));
        }
        switch (this.authenticatorType) {
            case BIND_SEARCH: {
                if (this.disablePooling) {
                    bindSearchDnResolver = new TemplateSearchDnResolver(this.getVelocityEngine(), this.getUserFilter());
                    bindSearchDnResolver.setBaseDn(this.baseDn);
                    bindSearchDnResolver.setSubtreeSearch(this.subtreeSearch);
                    bindSearchDnResolver.setConnectionFactory((ConnectionFactory)new DefaultConnectionFactory(this.createConnectionConfig((ConnectionInitializer)new BindConnectionInitializer(this.bindDn, new Credential(this.bindDnCredential)))));
                    authenticator.setDnResolver((DnResolver)bindSearchDnResolver);
                } else {
                    bindSearchDnResolver = new TemplateSearchDnResolver(this.getVelocityEngine(), this.getUserFilter());
                    bindSearchDnResolver.setBaseDn(this.baseDn);
                    bindSearchDnResolver.setSubtreeSearch(this.subtreeSearch);
                    bindSearchDnResolver.setConnectionFactory((ConnectionFactory)this.createPooledConnectionFactory("dn-search-pool", this.createConnectionConfig((ConnectionInitializer)new BindConnectionInitializer(this.bindDn, new Credential(this.bindDnCredential))), this.createSearchConnectionValidator(this.validateDn, this.validateFilter)));
                    authenticator.setDnResolver((DnResolver)bindSearchDnResolver);
                }
                authenticator.setResolveEntryOnFailure(this.resolveEntryOnFailure);
                break;
            }
            case DIRECT: {
                authenticator.setDnResolver((DnResolver)new FormatDnResolver(this.dnFormat));
                authenticator.setResolveEntryOnFailure(this.resolveEntryOnFailure);
                break;
            }
            case AD: {
                authenticator.setDnResolver((DnResolver)new FormatDnResolver(this.dnFormat));
                authenticator.setResolveEntryOnFailure(this.resolveEntryOnFailure);
                authenticator.setResponseHandlers(new AuthenticationResponseHandler[]{new ActiveDirectoryAuthenticationResponseHandler()});
                break;
            }
            case ANON_SEARCH: {
                if (this.disablePooling) {
                    anonSearchDnResolver = new TemplateSearchDnResolver(this.getVelocityEngine(), this.getUserFilter());
                    anonSearchDnResolver.setBaseDn(this.baseDn);
                    anonSearchDnResolver.setSubtreeSearch(this.subtreeSearch);
                    anonSearchDnResolver.setConnectionFactory((ConnectionFactory)new DefaultConnectionFactory(this.createConnectionConfig()));
                    authenticator.setDnResolver((DnResolver)anonSearchDnResolver);
                } else {
                    anonSearchDnResolver = new TemplateSearchDnResolver(this.getVelocityEngine(), this.getUserFilter());
                    anonSearchDnResolver.setBaseDn(this.baseDn);
                    anonSearchDnResolver.setSubtreeSearch(this.subtreeSearch);
                    anonSearchDnResolver.setConnectionFactory((ConnectionFactory)this.createPooledConnectionFactory("dn-search-pool", this.createConnectionConfig(), this.createSearchConnectionValidator(this.validateDn, this.validateFilter)));
                    authenticator.setDnResolver((DnResolver)anonSearchDnResolver);
                }
                authenticator.setResolveEntryOnFailure(this.resolveEntryOnFailure);
                break;
            }
        }
        if (this.resolveEntryWithBindDn) {
            if (this.disablePooling) {
                searchEntryResolver = new SearchEntryResolver();
                searchEntryResolver.setConnectionFactory((ConnectionFactory)new DefaultConnectionFactory(this.createConnectionConfig((ConnectionInitializer)new BindConnectionInitializer(this.bindDn, new Credential(this.bindDnCredential)))));
                authenticator.setEntryResolver((EntryResolver)searchEntryResolver);
            } else {
                searchEntryResolver = new SearchEntryResolver();
                searchEntryResolver.setConnectionFactory((ConnectionFactory)this.createPooledConnectionFactory("entry-search-pool", this.createConnectionConfig((ConnectionInitializer)new BindConnectionInitializer(this.bindDn, new Credential(this.bindDnCredential))), this.createSearchConnectionValidator(this.validateDn, this.validateFilter)));
                authenticator.setEntryResolver((EntryResolver)searchEntryResolver);
            }
        }
        if (this.usePasswordPolicy) {
            authenticator.setRequestHandlers(new AuthenticationRequestHandler[]{new PasswordPolicyAuthenticationRequestHandler()});
            authenticator.setResponseHandlers(new AuthenticationResponseHandler[]{new PasswordPolicyAuthenticationResponseHandler()});
        } else if (this.usePasswordExpiration) {
            authenticator.setResponseHandlers(new AuthenticationResponseHandler[]{new PasswordExpirationAuthenticationResponseHandler()});
        } else if (this.isActiveDirectory) {
            authenticator.setResponseHandlers(new AuthenticationResponseHandler[]{new ActiveDirectoryAuthenticationResponseHandler(this.accountStateExpirationPeriod, this.accountStateWarningPeriod)});
        } else if (this.isEDirectory) {
            authenticator.setResponseHandlers(new AuthenticationResponseHandler[]{new EDirectoryAuthenticationResponseHandler(this.accountStateWarningPeriod)});
        } else if (this.isFreeIPA) {
            authenticator.setResponseHandlers(new AuthenticationResponseHandler[]{new FreeIPAAuthenticationResponseHandler(this.accountStateExpirationPeriod, this.accountStateWarningPeriod, this.accountStateLoginFailures)});
        }
        this.log.debug("Created {} from {}", (Object)authenticator, (Object)this);
        return authenticator;
    }

    protected void destroyInstance(@Nullable Authenticator instance) {
        if (instance != null) {
            instance.close();
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("authenticatorType", (Object)this.authenticatorType).add("trustType", (Object)this.trustType).add("connectionStrategyType", (Object)this.connectionStrategyType).add("ldapUrl", (Object)this.ldapUrl).add("useStartTLS", this.useStartTLS).add("startTLSTimeout", (Object)this.startTLSTimeout).add("disableHostnameVerification", this.disableHostnameVerification).add("connectTimeout", (Object)this.connectTimeout).add("responseTimeout", (Object)this.responseTimeout).add("trustCertificatesCredentialConfig", (Object)this.trustCertificatesCredentialConfig).add("truststoreCredentialConfig", (Object)this.truststoreCredentialConfig).add("disablePooling", this.disablePooling).add("blockWaitTime", (Object)this.blockWaitTime).add("minPoolSize", this.minPoolSize).add("maxPoolSize", this.maxPoolSize).add("validateOnCheckout", this.validateOnCheckout).add("validatePeriodically", this.validatePeriodically).add("validatePeriod", (Object)this.validatePeriod).add("validateDn", (Object)this.validateDn).add("validateFilter", (Object)this.validateFilter).add("bindPoolPassivatorType", (Object)this.bindPoolPassivatorType).add("prunePeriod", (Object)this.prunePeriod).add("idleTime", (Object)this.idleTime).add("dnFormat", (Object)this.dnFormat).add("baseDn", (Object)this.baseDn).add("userFilter", (Object)this.userFilter).add("subtreeSearch", this.subtreeSearch).add("resolveEntryOnFailure", this.resolveEntryOnFailure).add("resolveEntryWithBindDn", this.resolveEntryWithBindDn).add("velocityEngine", (Object)this.velocityEngine).add("bindDn", (Object)this.bindDn).add("bindDnCredential", (Object)(this.bindDnCredential != null ? "suppressed" : null)).add("usePasswordPolicy", this.usePasswordPolicy).add("usePasswordExpiration", this.usePasswordExpiration).add("isActiveDirectory", this.isActiveDirectory).add("isFreeIPA", this.isFreeIPA).add("isEDirectory", this.isEDirectory).add("accountStateExpirationPeriod", (Object)this.accountStateExpirationPeriod).add("accountStateWarningPeriod", (Object)this.accountStateWarningPeriod).add("accountStateLoginFailures", this.accountStateLoginFailures).toString();
    }

    public Class<?> getObjectType() {
        return Authenticator.class;
    }

    public static enum AuthenticatorType {
        ANON_SEARCH("anonSearchAuthenticator"),
        BIND_SEARCH("bindSearchAuthenticator"),
        DIRECT("directAuthenticator"),
        AD("adAuthenticator");

        @Nonnull
        @NotEmpty
        private final String label;

        private AuthenticatorType(String s) {
            this.label = s;
        }

        @Nonnull
        @NotEmpty
        public String label() {
            return this.label;
        }

        @Nullable
        public static AuthenticatorType fromLabel(@Nonnull @NotEmpty String s) {
            for (AuthenticatorType at : AuthenticatorType.values()) {
                if (!at.label().equals(s)) continue;
                return at;
            }
            return null;
        }
    }

    public static enum TrustType {
        JVM("jvmTrust"),
        CERTIFICATE("certificateTrust"),
        KEYSTORE("keyStoreTrust"),
        DISABLED("disabled");

        @Nonnull
        @NotEmpty
        private final String label;

        private TrustType(String s) {
            this.label = s;
        }

        @Nonnull
        @NotEmpty
        public String label() {
            return this.label;
        }

        @Nullable
        public static TrustType fromLabel(@Nonnull @NotEmpty String s) {
            for (TrustType tt : TrustType.values()) {
                if (!tt.label().equals(s)) continue;
                return tt;
            }
            return null;
        }
    }

    public static enum ConnectionStrategyType {
        ACTIVE_PASSIVE("ACTIVE_PASSIVE"),
        ROUND_ROBIN("ROUND_ROBIN"),
        RANDOM("RANDOM");

        @Nonnull
        @NotEmpty
        private final String label;

        private ConnectionStrategyType(String s) {
            this.label = s;
        }

        @Nonnull
        @NotEmpty
        public String label() {
            return this.label;
        }

        @Nullable
        public static ConnectionStrategyType fromLabel(@Nonnull @NotEmpty String s) {
            for (ConnectionStrategyType cst : ConnectionStrategyType.values()) {
                if (!cst.label().equals(s)) continue;
                return cst;
            }
            return null;
        }
    }

    public static enum PassivatorType {
        NONE("none"),
        BIND("bind"),
        ANONYMOUS_BIND("anonymousBind");

        @Nonnull
        @NotEmpty
        private final String label;

        private PassivatorType(String s) {
            this.label = s;
        }

        @Nonnull
        @NotEmpty
        public String label() {
            return this.label;
        }

        @Nullable
        public static PassivatorType fromLabel(@Nonnull @NotEmpty String s) {
            for (PassivatorType pt : PassivatorType.values()) {
                if (!pt.label().equals(s)) continue;
                return pt;
            }
            return null;
        }
    }
}

