/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.context;

import java.util.Collection;
import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import org.opensaml.messaging.context.BaseContext;

public final class AuthenticationWarningContext
extends BaseContext {
    @Nonnull
    private Collection<String> classifiedWarnings = new LinkedHashSet<String>();

    @Nonnull
    @Live
    public Collection<String> getClassifiedWarnings() {
        return this.classifiedWarnings;
    }

    public boolean isClassifiedWarning(@Nonnull @NotEmpty String warning) {
        return this.classifiedWarnings.contains(warning);
    }

    @Nonnull
    public AuthenticationWarningContext addClassifiedWarning(@Nonnull @NotEmpty String warning) {
        this.classifiedWarnings.remove(warning);
        this.classifiedWarnings.add(warning);
        return this;
    }

    @Nullable
    public String getLastClassifiedWarning() {
        return this.classifiedWarnings.stream().reduce((first, second) -> second).orElse(null);
    }
}

