/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.context;

import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.principal.PrincipalSupportingComponent;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;

public final class PreferredPrincipalContext
extends BaseContext {
    @Nonnull
    private List<Principal> preferredPrincipals = CollectionSupport.emptyList();

    @Nonnull
    @Unmodifiable
    @NotLive
    public List<Principal> getPreferredPrincipals() {
        return this.preferredPrincipals;
    }

    @Nonnull
    public PreferredPrincipalContext setPreferredPrincipals(@Nonnull List<Principal> principals) {
        this.preferredPrincipals = CollectionSupport.copyToList((Collection)((Collection)Constraint.isNotNull(principals, (String)"Principal list cannot be null")));
        return this;
    }

    public boolean isAcceptable(@Nonnull PrincipalSupportingComponent component) {
        return !Collections.disjoint(this.preferredPrincipals, component.getSupportedPrincipals(Principal.class));
    }

    public boolean isAcceptable(@Nonnull Collection<Principal> principals) {
        return !Collections.disjoint(this.preferredPrincipals, principals);
    }

    public <T extends Principal> boolean isAcceptable(@Nonnull T principal) {
        return this.preferredPrincipals.contains(principal);
    }
}

