/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.context;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.SubjectCanonicalizationFlowDescriptor;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;

public final class SubjectCanonicalizationContext
extends BaseContext {
    @Nullable
    private Subject subject;
    @Nullable
    private String principalName;
    @Nullable
    private String requesterId;
    @Nullable
    private String responderId;
    @Nonnull
    private final Map<String, SubjectCanonicalizationFlowDescriptor> potentialFlows = new LinkedHashMap<String, SubjectCanonicalizationFlowDescriptor>();
    @Nonnull
    private final Map<String, SubjectCanonicalizationFlowDescriptor> intermediateFlows = new HashMap<String, SubjectCanonicalizationFlowDescriptor>();
    @Nullable
    private SubjectCanonicalizationFlowDescriptor attemptedFlow;
    @Nullable
    private Exception canonicalizationError;

    @Nullable
    public Subject getSubject() {
        return this.subject;
    }

    @Nonnull
    public SubjectCanonicalizationContext setSubject(@Nullable Subject newSubject) {
        this.subject = newSubject;
        return this;
    }

    @Nullable
    public String getPrincipalName() {
        return this.principalName;
    }

    @Nonnull
    public SubjectCanonicalizationContext setPrincipalName(@Nullable String name) {
        this.principalName = StringSupport.trimOrNull((String)name);
        return this;
    }

    @Nullable
    public Exception getException() {
        return this.canonicalizationError;
    }

    @Nonnull
    public SubjectCanonicalizationContext setException(@Nullable Exception e) {
        this.canonicalizationError = e;
        return this;
    }

    @Nullable
    public String getRequesterId() {
        return this.requesterId;
    }

    @Nonnull
    public SubjectCanonicalizationContext setRequesterId(@Nullable String id) {
        this.requesterId = id;
        return this;
    }

    @Nullable
    public String getResponderId() {
        return this.responderId;
    }

    @Nonnull
    public SubjectCanonicalizationContext setResponderId(@Nullable String id) {
        this.responderId = id;
        return this;
    }

    @Nonnull
    @Live
    public Map<String, SubjectCanonicalizationFlowDescriptor> getPotentialFlows() {
        return this.potentialFlows;
    }

    @Nonnull
    @Live
    public Map<String, SubjectCanonicalizationFlowDescriptor> getIntermediateFlows() {
        return this.intermediateFlows;
    }

    @Nullable
    public SubjectCanonicalizationFlowDescriptor getAttemptedFlow() {
        return this.attemptedFlow;
    }

    @Nonnull
    public SubjectCanonicalizationContext setAttemptedFlow(@Nullable SubjectCanonicalizationFlowDescriptor flow) {
        this.attemptedFlow = flow;
        return this;
    }
}

