/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.context.navigate;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.AuthenticationErrorContext;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.context.support.MessageSourceAccessor;

public class PasswordErrorMessageLookupFunction
extends ApplicationObjectSupport
implements ContextDataLookupFunction<ProfileRequestContext, String> {
    private String genericMessageID;

    public void setGenericMessageID(@Nullable String id) {
        this.genericMessageID = StringSupport.trimOrNull((String)id);
    }

    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        AuthenticationErrorContext errorCtx;
        MessageSourceAccessor messageSource = this.getMessageSourceAccessor();
        if (messageSource == null) {
            return null;
        }
        AuthenticationContext authCtx = input != null ? (AuthenticationContext)input.getSubcontext(AuthenticationContext.class) : null;
        AuthenticationErrorContext authenticationErrorContext = errorCtx = authCtx != null ? (AuthenticationErrorContext)authCtx.getSubcontext(AuthenticationErrorContext.class) : null;
        if (errorCtx == null) {
            return null;
        }
        Collection<String> classifiedErrors = errorCtx.getClassifiedErrors();
        if (!classifiedErrors.isEmpty() && !classifiedErrors.contains("AuthenticationException")) {
            return this.getClassifiedMessage(messageSource, classifiedErrors.iterator().next());
        }
        if (!errorCtx.getExceptions().isEmpty()) {
            return this.getExceptionMessage(messageSource, errorCtx.getExceptions().get(0));
        }
        return null;
    }

    @Nullable
    private String getClassifiedMessage(@Nonnull MessageSourceAccessor messageSource, @Nonnull String classifiedError) {
        String eventKey;
        if (!"ReselectFlow".equals(classifiedError) && (eventKey = messageSource.getMessage(classifiedError, this.genericMessageID != null ? this.genericMessageID : "authn")) != null) {
            return messageSource.getMessage(eventKey + ".message", "Login Failure: " + classifiedError);
        }
        return null;
    }

    @Nullable
    private String getExceptionMessage(@Nonnull MessageSourceAccessor messageSource, @Nonnull Exception e) {
        if (this.genericMessageID != null) {
            return messageSource.getMessage(this.genericMessageID, "Login was not successful.");
        }
        if (e.getMessage() != null) {
            return "Login Failure: " + e.getMessage();
        }
        return e.toString();
    }
}

