/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal;

import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonGeneratorFactory;
import java.io.Reader;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.authn.principal.PrincipalSerializer;
import net.shibboleth.shared.component.AbstractInitializableComponent;

@ThreadSafe
public abstract class AbstractPrincipalSerializer<Type>
extends AbstractInitializableComponent
implements PrincipalSerializer<Type> {
    @Nonnull
    private final JsonGeneratorFactory generatorFactory;
    @Nonnull
    private final JsonReaderFactory readerFactory;

    public AbstractPrincipalSerializer() {
        JsonProvider provider = JsonProvider.provider();
        assert (provider != null);
        JsonGeneratorFactory gFactory = provider.createGeneratorFactory(null);
        JsonReaderFactory rFactory = provider.createReaderFactory(null);
        assert (gFactory != null && rFactory != null);
        this.generatorFactory = gFactory;
        this.readerFactory = rFactory;
    }

    @Nonnull
    protected synchronized JsonGenerator getJsonGenerator(@Nonnull Writer writer) {
        JsonGenerator jsonGenerator = this.generatorFactory.createGenerator(writer);
        assert (jsonGenerator != null);
        return jsonGenerator;
    }

    @Nonnull
    protected synchronized JsonReader getJsonReader(@Nonnull Reader reader) {
        JsonReader jr = this.readerFactory.createReader(reader);
        assert (jr != null);
        return jr;
    }
}

