/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.ticket.serialization.impl;

import jakarta.json.JsonObject;
import jakarta.json.stream.JsonGenerator;
import java.time.Instant;
import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.ticket.ProxyGrantingTicket;
import net.shibboleth.idp.cas.ticket.serialization.impl.AbstractTicketSerializer;
import net.shibboleth.shared.logic.Constraint;

public class ProxyGrantingTicketSerializer
extends AbstractTicketSerializer<ProxyGrantingTicket> {
    @Nonnull
    private static final String PARENT_FIELD = "parent";
    @Nonnull
    private static final String PGTURL_FIELD = "pgtUrl";

    @Override
    protected void serializeInternal(@Nonnull JsonGenerator generator, @Nonnull ProxyGrantingTicket ticket) {
        generator.write(PGTURL_FIELD, ticket.getProxyCallbackUrl());
        if (ticket.getParentId() != null) {
            generator.write(PARENT_FIELD, ticket.getParentId());
        }
    }

    @Override
    @Nonnull
    protected ProxyGrantingTicket createTicket(@Nonnull JsonObject o, @Nonnull String id, @Nonnull String service, @Nonnull Instant expiry) {
        return new ProxyGrantingTicket(id, service, expiry, (String)Constraint.isNotNull((Object)o.getString(PGTURL_FIELD), (String)"pgtUrl was not present"), o.getString(PARENT_FIELD, null));
    }
}

