/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.conf.impl;

import jakarta.servlet.FilterRegistration;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.util.Set;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;
import org.springframework.web.filter.DelegatingFilterProxy;

public class RegisterFilterChainServletContextInitializer
implements ServletContainerInitializer {
    @Nonnull
    @NotEmpty
    public static final String INIT_PARAMETER_ACTIVATION = "net.shibboleth.idp.registerFilterChain";
    @Nonnull
    @NotEmpty
    public static final String FILTER_NAME = "ShibbolethFilterChain";
    @Nonnull
    @NotEmpty
    public static final String TARGET_BEAN_NAME = "shibboleth.ChainingFilter";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RegisterFilterChainServletContextInitializer.class);

    public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
        String flag = ctx.getInitParameter(INIT_PARAMETER_ACTIVATION);
        if ("false".equalsIgnoreCase(flag)) {
            this.log.info("Filter registration is disabled");
            return;
        }
        this.log.debug("Attempting to register filter '{}'", (Object)FILTER_NAME);
        FilterRegistration.Dynamic headerFilter = ctx.addFilter(FILTER_NAME, DelegatingFilterProxy.class);
        headerFilter.addMappingForUrlPatterns(null, false, new String[]{"/*"});
        headerFilter.setInitParameter("targetBeanName", TARGET_BEAN_NAME);
        this.log.info("Registered the filter '{}'.", (Object)FILTER_NAME);
    }
}

