/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.conf.impl;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import java.util.Set;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.spring.context.DelimiterAwareApplicationContext;
import net.shibboleth.shared.spring.servlet.impl.DelegatingServletProxy;
import org.slf4j.Logger;
import org.springframework.web.servlet.DispatcherServlet;

public class ServletConfigServletContextInitializer
implements ServletContainerInitializer {
    @Nonnull
    @NotEmpty
    public static final String INIT_PARAMETER_IDP_ACTIVATION = "net.shibboleth.idp.registerIdPServlet";
    @Nonnull
    @NotEmpty
    public static final String INIT_PARAMETER_REMOTEUSER_ACTIVATION = "net.shibboleth.idp.registerRemoteUserServlet";
    @Nonnull
    @NotEmpty
    public static final String INIT_PARAMETER_X509_ACTIVATION = "net.shibboleth.idp.registerX509Servlet";
    @Nonnull
    @NotEmpty
    public static final String INIT_PARAMETER_METADATA_ACTIVATION = "net.shibboleth.idp.registerMetadataServlet";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ServletConfigServletContextInitializer.class);

    public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
        ServletRegistration.Dynamic registration;
        String idpFlag = ctx.getInitParameter(INIT_PARAMETER_IDP_ACTIVATION);
        String remoteUserFlag = ctx.getInitParameter(INIT_PARAMETER_REMOTEUSER_ACTIVATION);
        String x509Flag = ctx.getInitParameter(INIT_PARAMETER_X509_ACTIVATION);
        String metadataFlag = ctx.getInitParameter(INIT_PARAMETER_METADATA_ACTIVATION);
        if ("true".equalsIgnoreCase(idpFlag)) {
            this.log.info("Registering primary IdP servlet");
            registration = ctx.addServlet("idp", DispatcherServlet.class);
            registration.addMapping(new String[]{"/status", "/profile/*"});
            registration.setInitParameter("contextClass", DelimiterAwareApplicationContext.class.getName());
            registration.setInitParameter("contextConfigLocation", "classpath*:/META-INF/net/shibboleth/idp/mvc/preconfig.xml,classpath:/net/shibboleth/idp/conf/mvc-beans.xml,classpath:/net/shibboleth/idp/conf/webflow-config.xml,classpath*:/META-INF/net/shibboleth/idp/mvc/postconfig.xml");
        }
        if ("true".equalsIgnoreCase(remoteUserFlag)) {
            this.log.info("Registering RemoteUser authentication servlet");
            registration = ctx.addServlet("RemoteUserAuthHandler", (Servlet)new DelegatingServletProxy("shibboleth.RemoteUserAuthServlet"));
            registration.addMapping(new String[]{"/Authn/RemoteUser"});
        }
        if ("true".equalsIgnoreCase(x509Flag)) {
            this.log.info("Registering X.509 authentication servlet");
            registration = ctx.addServlet("X509AuthHandler", (Servlet)new DelegatingServletProxy("shibboleth.X509AuthServlet"));
            registration.addMapping(new String[]{"/Authn/X509"});
        }
        if ("true".equals(metadataFlag)) {
            this.log.info("Registering metadata endpoint servlet");
            registration = ctx.addJspFile("MetadataAccessHandler", "/WEB-INF/jsp/metadata.jsp");
            registration.addMapping(new String[]{"/shibboleth"});
        }
    }
}

