/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.module.core.impl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.module.impl.CoreIdPModule;
import net.shibboleth.profile.module.Module;
import net.shibboleth.profile.module.ModuleContext;
import net.shibboleth.profile.module.ModuleException;

public final class Core
extends CoreIdPModule {
    @Nonnull
    private static final String[] AUTO_CREATED = new String[]{"conf", "credentials", "metadata", "flows", "messages", "views", "logs"};

    public Core() throws IOException, ModuleException {
        super(Core.class);
    }

    public boolean isEnabled(@Nonnull ModuleContext moduleContext) {
        return true;
    }

    @Nonnull
    public Map<Module.ModuleResource, Module.ResourceResult> enable(@Nonnull ModuleContext moduleContext) throws ModuleException {
        try {
            if (!moduleContext.getInstallLocation().startsWith("classpath:")) {
                Path home = Path.of(moduleContext.getInstallLocation(), new String[0]);
                for (String folder : AUTO_CREATED) {
                    Path resolved = home.resolve(folder);
                    if (!Files.exists(resolved, new LinkOption[0])) {
                        Files.createDirectories(resolved, new FileAttribute[0]);
                        continue;
                    }
                    if (Files.isDirectory(resolved, new LinkOption[0])) continue;
                    throw new IOException("Folder '" + folder + "' exists, but is not a directory.");
                }
                Path antFile = home.resolve("bin").resolve("build.xml");
                if (Files.exists(antFile, new LinkOption[0])) {
                    Files.delete(antFile);
                }
                if (Files.exists(antFile = home.resolve("bin").resolve("ant.bat"), new LinkOption[0])) {
                    Files.delete(antFile);
                }
                if (Files.exists(antFile = home.resolve("bin").resolve("ant.sh"), new LinkOption[0])) {
                    Files.delete(antFile);
                }
            }
        }
        catch (Exception e) {
            throw new ModuleException(e);
        }
        return super.enable(moduleContext);
    }

    @Nonnull
    public Map<Module.ModuleResource, Module.ResourceResult> disable(@Nonnull ModuleContext moduleContext, boolean clean) throws ModuleException {
        throw new ModuleException("This module cannot be disabled.");
    }
}

